-- filtered indexes support starts with SQL 2008, make sure you check before creating the constraint
if (cast(replace(cast(serverproperty('productversion') as nvarchar(2)), '.', '') as int) >= 10) -- SQL 2008 or newer
begin
    declare @sql nvarchar(2000);
    set @sql = N'if not exists (select * from sys.indexes where name = ''UIX_UserSecurity_LoginEmail'' AND object_id = object_id(''dbo.UserSecurity''))
        create unique index UIX_UserSecurity_LoginEmail on dbo.UserSecurity(LoginEmail) where loginemail is not null';
    exec sp_executesql @sql;
end;