with cteUpdate as 
(
    select c.ID, isnull(count(distinct tu.TodoUsersTodoID), 0) as TodoOpenCount
    from dbo.Connections c
        left outer join dbo.TodoUsers tu on tu.TodoUsersConnectionID = c.ID and tu.TodoUsersStatus in (0 /*Default*/, 1 /*Open*/, 2 /*Assigned*/, 3 /*InProgress*/)
    group by c.ID, c.TodoOpenCount
)
update c
set TodoOpenCount = cte.TodoOpenCount
from dbo.Connections c
    inner join cteUpdate cte on cte.ID = c.ID
where c.TodoOpenCount <> cte.TodoOpenCount;