alter trigger dbo.tr_TodoUsers_Insert_Upate_Delete
on dbo.TodoUsers after insert, update, delete
as 
begin
    with cteRows as
    (
        select i.TodoUsersConnectionID from inserted i union select d.TodoUsersConnectionID from deleted d
    )
    ,cteUpdate as 
    (
        select c.ID, isnull(count(distinct tu.TodoUsersTodoID), 0) as TodoOpenCount
        from dbo.Connections c
            inner join cteRows r on r.TodoUsersConnectionID = c.ID
            left outer join dbo.TodoUsers tu on tu.TodoUsersConnectionID = c.ID and tu.TodoUsersStatus in (0 /*Default*/, 1 /*Open*/, 2 /*Assigned*/, 3 /*InProgress*/)
        group by c.ID, c.TodoOpenCount
    )
    update c
    set TodoOpenCount = cte.TodoOpenCount
    from dbo.Connections c
        inner join cteUpdate cte on cte.ID = c.ID
    where c.TodoOpenCount <> cte.TodoOpenCount;
end