declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.UserAccount') and name= N'tr_UserAccount';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_UserAccount
on dbo.UserAccount
for insert, update
as 
begin
    set nocount on

    if (update(Data))
    begin
        insert into dbo.UserInfoHistory (HistoryType, UserInfoID, ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, Data)
        select case when d.ID is null then ''I'' else ''U'' end, i.ID, case when i.ModifiedDate = d.ModifiedDate then getutcdate() else isnull(i.ModifiedDate, getutcdate()) end, i.ModifiedUserName, i.ModifiedLoggedUserName, i.Data
        from inserted i
            left outer join deleted d on i.ID = d.ID
    end;
end;');