declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.UserInfo') and name= N'tr_VIEW_UserInfo_Update';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_VIEW_UserInfo_Update
on dbo.UserInfo
with execute as owner
instead of update
as
begin
    update u
    set 
        FullName = i.FullName
        ,ConnectionOverrides = i.ConnectionOverrides
        ,IsTemplate = isnull(i.IsTemplate, 0)
        ,Email = i.Email
        ,IsOwner = isnull(i.IsOwner, 0)
        ,Password = i.Password
        ,PasswordSalt = i.PasswordSalt
        ,LastLoginDate = i.LastLoginDate
        ,LastPasswordChangedDate = i.LastPasswordChangedDate
        ,PersonalConnectionCacheID = i.PersonalConnectionCacheID
        ,PersonalConnections = i.PersonalConnections
        ,ModifiedDate = getutcdate()
        ,ModifiedUserName = null
        ,ModifiedLoggedUserName = null
    from dbo.UserAccount u
        inner join inserted i on i.ID = u.ID

    update s
    set 
        Name = i.Name
        ,IsAdministrator = i.IsAdministrator
         ,IsEnabled = i.IsEnabled
        ,IsLockedOut = i.IsLockedOut
        ,DataSourceID = i.DataSourceID
        ,UserType = i.UserType
        ,CanAdd = i.CanAdd
        ,CanDelete = i.CanDelete
        ,CanEdit = i.CanEdit
        ,CustomSecurity = i.CustomSecurity
        ,CanAddCredentials = i.CanAddCredentials
        ,CanAddDataEntry = i.CanAddDataEntry
        ,CanEditCredentials = i.CanEditCredentials
        ,CanEditDataEntry = i.CanEditDataEntry
        ,CanDeleteCredentials = i.CanDeleteCredentials
        ,CanDeleteDataEntry = i.CanDeleteDataEntry
        ,LastLockoutDate = i.LastLockoutDate
        ,FailedPasswordAttemptCount = i.FailedPasswordAttemptCount
        ,FailedPasswordAttemptWindowStart = i.FailedPasswordAttemptWindowStart
        ,ModifiedDate = getutcdate()
        ,ModifiedUserName = null
        ,ModifiedLoggedUserName = null
    from dbo.UserSecurity s
        inner join inserted i on i.ID = s.ID
end;');