declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.UserInfo') and name= N'tr_VIEW_UserInfo_Insert';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_VIEW_UserInfo_Insert
on dbo.UserInfo
with execute as owner
instead of insert
as
begin
    insert into dbo.UserAccount (ID, FullName, ConnectionOverrides, IsTemplate, Email, IsOwner, Password, PasswordSalt, LastLoginDate, LastPasswordChangedDate, PersonalConnectionCacheID, PersonalConnections, CreationDate, ModifiedDate)
    select ID, FullName, ConnectionOverrides, isnull(IsTemplate, 0), Email, isnull(IsOwner, 0), Password, PasswordSalt, LastLoginDate, LastPasswordChangedDate, PersonalConnectionCacheID, PersonalConnections, isnull(CreationDate, getutcdate()), isnull(CreationDate, getutcdate()) from inserted

    insert into dbo.UserSecurity (ID, Name, UserType, IsAdministrator, IsEnabled, IsLockedOut, DataSourceID, CanAdd, CanDelete, CanEdit, CustomSecurity, CanAddCredentials, CanAddDataEntry, CanEditCredentials, CanEditDataEntry, CanDeleteCredentials, CanDeleteDataEntry, LastLockoutDate, FailedPasswordAttemptCount, FailedPasswordAttemptWindowStart, CreationDate, ModifiedDate)
    select ID, Name, isnull(UserType, 0), isnull(IsAdministrator, 0), isnull(IsEnabled, 1), isnull(IsLockedOut, 0), isnull(DataSourceID, ''{00000000-0000-0000-0000-000000000000}''), CanAdd, CanDelete, CanEdit, CustomSecurity, CanAddCredentials, CanAddDataEntry, CanEditCredentials, CanEditDataEntry, CanDeleteCredentials, CanDeleteDataEntry, LastLockoutDate, isnull(FailedPasswordAttemptCount, 0), FailedPasswordAttemptWindowStart, isnull(CreationDate, getutcdate()), isnull(CreationDate, getutcdate()) from inserted
end;');