declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.DatabaseInfo') and name= N'tr_DatabaseInfo';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_DatabaseInfo
on dbo.DatabaseInfo
for insert, update
as 
begin
    set nocount on

    if (not UPDATE(Settings))
    begin
        return;
    end;

    declare @Settings nvarchar(max)
    declare @Data nvarchar(max)

    select @Settings = Settings from inserted
    set @Data = (select top 1 Data from dbo.DataSourceSettingHistory order by ModifiedDate desc)

    if (@Settings = @Data)
    begin
        return;
    end;

    insert into dbo.DataSourceSettingHistory (ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, Data)
    select getutcdate(), DataSourceSettingModifiedUserName, DataSourceSettingModifiedLoggedUserName, Settings
    from inserted i
end;');