if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.SubscriptionEvent'))
    create table dbo.SubscriptionEvent
    (
        ID int not null identity(1, 1) constraint PK_SubscriptionEvent primary key nonclustered
        ,SubscriptionID uniqueidentifier not null constraint FK_SubscriptionEvent_Subscription foreign key references dbo.Subscription(ID) on delete cascade
        ,Date datetime not null constraint DF_SubscriptionEvent_Date default getdate()
        ,ItemID uniqueidentifier null
        ,HistoryID int null
        ,EventProcessed bit not null constraint DF_SubscriptionEvent_EventProcessed default (0)
    );

if not exists (SELECT * FROM sys.indexes WHERE name='CI_SubscriptionEvent_EventProcessed_SubscriptionID' AND object_id = OBJECT_ID('dbo.SubscriptionEvent'))
    create clustered index CI_SubscriptionEvent_EventProcessed_SubscriptionID on dbo.SubscriptionEvent (EventProcessed asc, SubscriptionID asc);