if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.UserSecurity'))
    create table dbo.UserSecurity
    (
        ID uniqueidentifier not null constraint PK_UserSecurity PRIMARY KEY CLUSTERED
        ,Name nvarchar(100) null
        ,UserType int not null constraint DF_UserSecurity_UserType default (0)
        ,IsAdministrator bit not null constraint DF_UserSecurity_IsAdministrator default (0)
        ,IsEnabled int not null constraint DF_UserSecurity_IsEnabled default (1)
        ,IsLockedOut bit not null constraint DF_UserSecurity_IsLockedOut default (0)
        ,DataSourceID uniqueidentifier not null constraint DF_UserSecurity_DataSourceID default ('{00000000-0000-0000-0000-000000000000}')
        ,Departments nvarchar(256) null
        ,SecurityKey nvarchar(max) null
        ,AccountSettings nvarchar(max) null
        ,CanAdd bit not null
        ,CanDelete bit not null
        ,CanEdit bit not null
        ,CustomSecurity nvarchar(max) null
        ,CanAddCredentials bit null
        ,CanAddDataEntry bit null
        ,CanEditCredentials bit null
        ,CanEditDataEntry bit null
        ,CanDeleteCredentials bit null
        ,CanDeleteDataEntry bit null
        ,LastLockoutDate datetime null
        ,FailedPasswordAttemptCount int not null constraint DF_UserSecurity_FailedPasswordAttemptCount default (0)
        ,FailedPasswordAttemptWindowStart datetime null
        ,CreationDate datetime not null constraint DF_UserSecurity_CreationDate default (getdate())
        ,CreatedByUserName nvarchar(256) null
        ,CreatedByLoggedUserName nvarchar(256) null
        ,ModifiedDate datetime null constraint DF_UserSecurity_ModifiedDate default (getdate())
        ,ModifiedUserName nvarchar(256) null
        ,ModifiedLoggedUserName nvarchar(256) null
        ,constraint FK_UserSecurity_ID foreign key (ID) references dbo.UserAccount(ID) on delete cascade
    )