if not exists (select * from sys.indexes where name = 'CI_ConnectionLog_StartDateTimeUTC' and object_id = object_id(N'dbo.ConnectionLog'))
    create table dbo.ConnectionLogNew
    (
        ID uniqueidentifier NOT NULL constraint PK_ConnectionLog primary key nonclustered,
        Username nvarchar(256) NULL,
        MachineName nvarchar(256) NULL,
        Message nvarchar(max) NULL,
        MessageType int NULL,
        ConnectionName nvarchar(512) NULL,
        ConnectionTypeName nvarchar(512) NULL,
        ConnectionID uniqueidentifier NULL,
        StartDateTime datetime NULL,
        EndDateTime datetime NULL,
        LoggedUserName nvarchar(256) NULL,
        GroupName nvarchar(max) NULL,
        StartDateTimeUTC datetime NULL,
        EndDateTimeUTC datetime NULL,
        Cost money NULL,
        Comment nvarchar(max) NULL,
        Prompt nvarchar(max) NULL,
        Data nvarchar(max) NULL,
        ManualEndDateTime datetime NULL,
        UserInfoID uniqueidentifier NULL constraint FK_ConnectionLog_UserInfoID FOREIGN KEY REFERENCES dbo.UserInfo(ID),
        ManualClosedBy nvarchar(256) NULL,
        SecurityGroup uniqueidentifier NULL,
        SupportClose bit NULL,
        OpenMode int NULL,
        CloseMode int NULL,
        HostName nvarchar(100) NULL,
        IsEmbedded bit NULL,
        ClosePrompt nvarchar(max) NULL,
        Status nvarchar(50) NULL,
        ActivityDuration int NULL,
        DataSourceID uniqueidentifier NOT NULL CONSTRAINT DF_ConnectionLog_DataSourceID DEFAULT ('{00000000-0000-0000-0000-000000000000}'),
        CreationDate datetime NOT NULL CONSTRAINT DF_ConnectionLog_CreationDate DEFAULT (getdate()),
        ActiveTime int NULL,
        Application varchar(100) NULL,
        Version varchar(100) NULL,
        IsPrivate bit NOT NULL CONSTRAINT DF_ConnectionLog_IsPrivate DEFAULT (0),
        PrivateUserID uniqueidentifier NULL constraint FK_ConnectionLog_PrivateUserID FOREIGN KEY REFERENCES dbo.UserInfo(ID),
        CustomerID uniqueidentifier NULL
    )