DECLARE @ConstraintName sysname;
SELECT 
    @ConstraintName = KCU.CONSTRAINT_NAME
FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS RC 
    INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU ON KCU.CONSTRAINT_CATALOG = RC.CONSTRAINT_CATALOG AND KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA  AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME
WHERE
    KCU.TABLE_NAME = 'Todo' AND
    KCU.COLUMN_NAME = 'CustomerID' AND
    KCU.CONSTRAINT_SCHEMA = 'dbo';
IF @ConstraintName IS NOT NULL EXEC('alter table dbo.Todo drop constraint ' + @ConstraintName)