disable trigger all on dbo.Connections;

with cteAttachmentCounts as
(
    select
        b.ID as ConnectionID
        ,SUM(case a.IsPrivate when 0 then 1 else 0 end) as AttachmentCount
        ,SUM(case a.IsPrivate when 1 then 1 else 0 end) as AttachmentPrivateCount
    from dbo.Connections b
        left outer join dbo.Attachment a on a.ConnectionID = b.ID
    group by b.ID
)
update c
set
   AttachmentCount = b.AttachmentCount
   ,AttachmentPrivateCount = b.AttachmentPrivateCount
from dbo.Connections c
    inner join cteAttachmentCounts b on c.ID = b.ConnectionID
where
    c.AttachmentCount <> b.AttachmentCount or c.AttachmentPrivateCount <> b.AttachmentPrivateCount;

enable trigger all on dbo.Connections;