update c
    set
       TodoOpenCount = isnull(a.[Count], 0)
    from dbo.Connections c
        left outer join       
        (select t.ConnectionID, COUNT(distinct tu.TodoUsersTodoID) [Count]
        from dbo.Todo t
            left outer join dbo.TodoUsers tu on tu.TodoUsersTodoID = t.ID and tu.TodoUsersStatus in (0 /*Default*/, 1 /*Open*/, 2 /*Assigned*/, 3 /*InProgress*/)
        group by t.ConnectionID) a on a.ConnectionID = c.ID
    where TodoOpenCount <> isnull(a.[Count], 0)