CREATE TRIGGER dbo.tr_TodoUsers_Insert_Upate_Delete
ON dbo.TodoUsers AFTER INSERT, UPDATE, DELETE
AS 
BEGIN
    update c
    set
       TodoOpenCount = isnull(a.[Count], 0)
    from dbo.Connections c
        inner join       
        (select t.ConnectionID, COUNT(distinct tu.TodoUsersTodoID) [Count]
        from (select i.TodoUsersTodoID from inserted i union select d.TodoUsersTodoID from deleted d) a
            inner join dbo.Todo t on t.ID = a.TodoUsersTodoID
            left outer join dbo.TodoUsers tu on tu.TodoUsersTodoID = t.ID and tu.TodoUsersStatus in (0 /*Default*/, 1 /*Open*/, 2 /*Assigned*/, 3 /*InProgress*/)
        group by t.ConnectionID) a on a.ConnectionID = c.ID
END