declare @sql nvarchar(max), @table_name sysname, @column_name sysname, @type_name sysname

declare column_cursor cursor for 
select
    N'[' + s.name + N'].[' + t.name + ']',
    c.name,
    case when st.name = N'text' then
        N'nvarchar(max)'
    else
        N'n' + st.name + N'(' + case when c.max_length >= 1000 or c.max_length = -1 then N'max' else cast(c.max_length as nvarchar(10)) end + N')'
    end + case c.is_nullable when 1 then N' null' else N' not null' end
from sys.columns c
    inner join sys.tables t on t.object_id = c.object_id
    inner join sys.systypes st on st.xtype = c.system_type_id
    inner join sys.schemas s on s.schema_id = t.schema_id
where
    (st.name = 'char' or st.name = 'varchar' or st.name = 'text')
    -- this is just to be 100% safe
    and t.name in ('Attachment', 'ConnectionLog', 'Connections', 'Credential', 'Customer', 'DatabaseInfo', 'GroupInfo', 'Inventory', 'LogMessage', 'Monitoring', 'Todo', 'UserGroupInfo', 'UserInfo', 'UserProfile')
order by 1, 2

open column_cursor

fetch next from column_cursor 
into @table_name, @column_name, @type_name

while @@fetch_status = 0
begin
    set @sql = N'alter table ' + @table_name + N' alter column [' + @column_name + N'] ' + @type_name
    
    print @sql 
    
    exec sp_executesql @sql
    
    fetch next from column_cursor 
    into @table_name, @column_name, @type_name
end 

close column_cursor;
deallocate column_cursor;