if not exists (select * FROM sys.syscolumns where name = 'LoggedUserName' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD LoggedUserName varchar(256) NULL;
 
if not exists (select * FROM sys.syscolumns where name = 'GroupName' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD GroupName varchar(512) NULL;
 
if not exists (select * FROM sys.syscolumns where name = 'StartDateTimeUTC' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD StartDateTimeUTC datetime NULL;
  
if not exists (select * FROM sys.syscolumns where name = 'EndDateTimeUTC' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD EndDateTimeUTC datetime NULL;
  
if not exists (select * FROM sys.syscolumns where name = 'Cost' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD Cost money NULL;
  
if not exists (select * FROM sys.syscolumns where name = 'Comment' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD Comment nvarchar(max) NULL;    

if not exists (select * FROM sys.syscolumns where name = 'Prompt' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD Prompt nvarchar(max) NULL;    

if not exists (select * FROM sys.syscolumns where name = 'Data' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD Data nvarchar(max) NULL;    
      
if not exists (select * FROM sys.syscolumns where name = 'Settings' AND id = object_id(N'dbo.UserGroupInfo')) 
  alter table dbo.UserGroupInfo ADD Settings nvarchar(max) NULL;
  
if not exists (select * FROM sys.syscolumns where name = 'IsTemplate' AND id = object_id(N'dbo.UserInfo')) 
  alter table dbo.UserInfo ADD IsTemplate bit NOT NULL default(0);
    
if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.Customer')) BEGIN
  create table dbo.Customer (
    ID uniqueidentifier DEFAULT newid() NOT NULL,
    SecurityGroup uniqueidentifier null FOREIGN KEY REFERENCES dbo.GroupInfo(ID),
    Data nvarchar(max),
    constraint PK_Customer primary key clustered (ID)
  );
END;

if not exists (select * FROM sys.syscolumns where name = 'CustomerID' AND id = object_id(N'dbo.ConnectionLog')) 
  alter table dbo.ConnectionLog ADD CustomerID uniqueidentifier null FOREIGN KEY REFERENCES dbo.Customer(ID);

if not exists (select * FROM sys.syscolumns where name = 'CustomerID' AND id = object_id(N'dbo.Connections')) 
  alter table dbo.Connections ADD CustomerID uniqueidentifier null FOREIGN KEY REFERENCES dbo.Customer(ID);

if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.Todo')) BEGIN
  create table dbo.Todo (
    ID uniqueidentifier DEFAULT newid() NOT NULL,
    ConnectionID uniqueidentifier null FOREIGN KEY REFERENCES dbo.Connections(ID),
    CreationDate datetime not null,
    DueDate datetime,
    Name varchar(250),
    Priority int,
    Data nvarchar(max),
    constraint PK_Todo primary key clustered (ID)
  );
END;

if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.Inventory')) BEGIN
  create table dbo.Inventory (
    ID uniqueidentifier DEFAULT newid() NOT NULL,
    ConnectionID uniqueidentifier null FOREIGN KEY REFERENCES dbo.Connections(ID),
    CreationDate datetime not null,
    Data nvarchar(max),
    constraint PK_Inventory primary key clustered (ID)
  );
END;

if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.Monitoring')) BEGIN
  create table dbo.Monitoring (
    ID uniqueidentifier DEFAULT newid() NOT NULL,
    ConnectionID uniqueidentifier null FOREIGN KEY REFERENCES dbo.Connections(ID),
    CreationDate datetime not null,
    Data nvarchar(max),
    constraint PK_Monitoring primary key clustered (ID)
  );
END;