if not exists (select * FROM sys.syscolumns where name = 'Settings' AND id = object_id(N'dbo.DatabaseInfo')) 
  alter table dbo.DatabaseInfo ADD Settings nvarchar(max) NULL;

if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.ConnectionLog')) BEGIN
  create table dbo.ConnectionLog (
    ID uniqueidentifier default newid() NOT NULL,
    Username VARCHAR(256),
    MachineName VARCHAR(256),
    Message VARCHAR(1000),
    MessageType int,
    ConnectionName VARCHAR(512), 
    ConnectionTypeName VARCHAR(512), 
    ConnectionID uniqueidentifier,
    StartDateTime datetime,
    EndDateTime datetime,
    primary key (ID)
  );
END;

if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.Attachment')) BEGIN
  create table dbo.Attachment (
    ID uniqueidentifier DEFAULT newid() NOT NULL,
    Description VARCHAR(1000),
    ConnectionID uniqueidentifier,
    CreationDateTime datetime,
    Username VARCHAR(256),
    constraint PK_Attachment primary key clustered (ID)
  );
END;