(function(){
	define("dbfen/client/view/recoverlist",function(require, exports, module){
		//require("lib/jquery/select");
		var User = require("dbfen/client/api/user");
		var Tree = require("lib/util/tree");
		var Task = require("dbfen/client/api/task");
		var File = require("dbfen/client/api/task/file");
		var Mysql = require("dbfen/client/api/task/mysql");
		var Mssql = require("dbfen/client/api/task/mssql");
		var dbfen = require("dbfen/client/com/dbfen");
		var backup_loca ="";
		var treeContent ;
		
		var recoveryPid;//恢复更新进度查询线程id
		var isExecRecovery = false;//是否执行了恢复
		var Module = {
			init: function(){
				//先初始化任务列表, 初始化完成后,取第一个任务信息来回写页面,回调方法里的参数 task是第一个任务的参数
				initViewTaskList(function(task){
					//initViewTaskInfo(task);
					$(window).on({
						recovery: function(e){//用户执行恢复任务触发的事件
							/* 写cookie start */
							/*var expires = new Date();
								expires.setFullYear(expires.getFullYear() -1); //保存99年
							var cookieConfig = {//cookie参数
								path: "/",
								expires: expires
							};
							$.cookie("showRecovery", "", cookieConfig);*/
							/* 写cookie end */

							var task = getTaskFromSelect();
							isExecRecovery = true;
							task.taskFilter = Task.TASK_FILTER.recovery;
							var $state = $("#state");
                            var progress = "0%";
							clearTimeout(recoveryPid);
                            $(".z-recoverBtn").removeAttr("id").addClass("btn-disable").siblings(".z-tips").show();
                            $state.show();
							$state.find(".z-tip").hide();
							$state.find(".z-progress").show();
							$state.find(".z-num p").html("文件数:&nbsp;0");//文件变化
							$state.find(".z-size p").html("大小:&nbsp;0");//文件变化
							$state.find(".text").text(progress);
							$state.find(".plan").css("width", progress);
							$state.find(".z-time p").text("");

							(function update(){
								recoveryPid = setTimeout(function(){
									updateViewProgress(task);
									update();
								}, 4000);
							})();
						}
					});


					//$(window).trigger("recovery");//更新进度
					//var task = getTaskFromSelect();
					//updateViewProgress(task);

					//设备目标变更
					$("#host").on({
						change: function(e){
							Task.getRecoverTaskList(function(result){//取任务列表 
								var data = result.data || {};
								var list = data.list || [];
								updateTaskTypeList(list);
							});
						}
					});

					//修改类型
					$(".typeModify").on({
						click: function(e){
							$(this).closest(".line").hide().siblings(".select-bar").show();
						}
					});

					//选择任务类型
                    $(function(){
                        var task = getTaskFromSelect();
                        //initViewTaskInfo(task);//初始化页面
                        if($(".z-typeName").text() == "Oracle"){
                            $(".content-div").closest(".bar").hide();
                        }else{
                            $(".content-div").closest(".bar").show();
                        }
                        updateDateList(task);
                    });
					$("#recoverType").live({
						change: function(e){
							var task = getTaskFromSelect();
							//initViewTaskInfo(task);//初始化页面
                            if($(this).val() == Task.TASK_TYPE.oracle){
                                $(".content-div").closest(".bar").hide();
                            }else{
                                $(".content-div").closest(".bar").show();
                            }
							updateDateList(task);
						}
					});
					
					//修改时间
					$("#timeModify").on({
						click: function(e){
							$(this).closest(".line").hide().siblings(".select-bar").show();
						}
					});
					//选择时间
					$("#recoverDate").live({
						change: function(e){
							var $select = $(this);
							var $option = $select.find("option:selected");
							var $val = parseInt($select.val());
							var task = getTaskFromSelect();
							task.date = $option.attr("date");
							$(".z-fileNum").text($option.attr("num"));
							$(".z-fileSize").text($option.attr("count"));
							updateViewContent(task);//更新可以选择的恢复内容
						}
					});
					
					//选择位置
					$("input[name=location]").live({
						change: function(e){
							var $val = $(this).val();
							$(this).closest("p").addClass("cor_black").siblings("p").removeClass("cor_black");
							if($val == 1){
								$(".z-locaInp").val(backup_loca);
								$(".z-choose").hide();
							}else if($val == 2){
								$(".z-locaInp").val("");
								$(".z-choose").show();
							}
						}
					});
					
					//指定位置
					$(".z-locaInp").on({
						click: function(e){
							var task = getTaskFromSelect();
							File.showViewRecoveryDir(task);//显示要恢复到指定文件的地址
						}
					});
					
					//选择内容
					$("#all").on({
						change: function(e){
							if($(this).is(":checked")){
								$("#content").slideDown();
							}else{
								$("#content").slideUp();
							}
						}
					});
					
					//运行恢复
					$("#recoverBtn").live({
						click: function(e){
							var $val = $("#recoverType").val();
							var content = "";
							var date = ($("#recoverDate").val()||"").trim();
							var loc = $("input[name=location]:checked")[0];
							var task = getTaskFromSelect();
                            var isLocal = dbfen.isLocalhost($("#host").val());
							if(loc.value!="1" && isLocal){
								if(!$(".z-locaInp").val()){
									return $.alert("亲,您要选择恢复到指定的位置");
								}
							}
							if($val == Task.TASK_TYPE.file){//文件
								var list = treeContent.getSelectDir();
								content = list.join("|");
								$("#content").attr("value", content);
							}else{
								content = $("#content input:checked").map(function(){
									return $(this).val();
								}).get().join("|");
								$("#content").attr("value", content);
							}
							if(date == ""){
								$.alert("亲,你没有进行过备份哦^^,不能进行恢复任务");
								return;
							}
							var host = $("#host").val();
							//本地任务才检测 
							if(/^\s*$/.test(content) && dbfen.isLocalhost(host)){
                                if($val != Task.TASK_TYPE.oracle){
                                    $.alert("亲,请选择要恢复的内容^^");
                                    return;
                                }
							}
							//var pid = layer.load(360);
							
							//判断此任务是否有东西在处理(备份,恢复,迁移等)
							Task.isHandle(task, function(result){
								//layer.close(pid);
								var data = result.data;
								if(data.isHandle){//
									$.alert("亲,备份和恢复不能同时执行");
								}else{
									Task.showViewVerify(task);
								}
							});
						}
					});
				});
			}
		}
		/** 初始化任务列表 */
		function initViewTaskList(callback){
			Task.getRecoverTaskList(function(result){//取任务列表
				var data = result.data || {};
				var list = data.list || [];

				if(result.code == 0){
					if(list.length < 1){
						$.alert("亲,您没有创建过任务,请到备份页面创建任务!");
					}else{
						updateHostList(list);//生成设备列表
						//updateTaskTypeList(list);
					}								
				}else{
					$.alert(res.msg || "取任务信息失败");
				}
				callback && callback(list[0]);
			});
		}

		/* 初始化任务信息,并回写界面 */
		/*function initViewTaskInfo(task){
			Task.getInfo({
				taskId: task.taskId,
				taskType: task.taskType
			}, function(result){
				switch(result.code){
				case 0:
					var data = result.data ||{},
						backupList = data.backupList||[],
						backup = backupList[0] || {};
					for(var i in backupList){
						var item = backupList[i];
						if(item.errCode == 0){
							backup = item;
							break;
						}
					}
					//updateView(data);//更新界面(除了任务类型列表外的其它内容)
					$(".z-typeName").text($("#recoverType option:selected").text());
					task.date = backup.backupDate;
					//updateViewContent(task);//更新可以选择的恢复内容
					break;
				default:
					$.alert(result.msg || "更新界面数据失败");
				}
			});			
		}*/
		/** 更新主机设备 */
		function updateHostList(list){
			var map = {},
                html = [],
                isRemoteHost = false;//是否有远程主机

			$.each(list, function(i, task){
				var key = task.host;
				if(dbfen.isLocalhost(task.host)){
					key = "本机";
				}else{
                    isRemoteHost = true;
                }
				if( !map[key] ){
					map[key] = task;
				}
			});
			$.each(map, function(host, task){
				html.push('<option value="'+task.host+'">'+host+'</option>');
			});
            if(isRemoteHost!=true){//没有远程主机,不显示
                $(".z-device").hide();
            }
            var first = list[0]||{};//第一个显示出来的任务
            if(!dbfen.isLocalhost(first.host)){//不是本地任务
                $(".z-host .z-name").html(first.host);//显示远程的主机名
                //远程主机的访问,不用选择目录地址,还原到默认位置
                $("input[name=location]").each(function(i, input){
                    if(input.value == "1"){
                        input.checked=true;
                    }else{
                        input.checked=false;
                    }
                });
            }
			$("#host").html(html.join(""));
			updateTaskTypeList(list);//迭代更新任务类型列表
		}
		/** 更新任务类型 */
		function updateTaskTypeList(list){
			var host = $("#host").val();//主机ip
			var isLocalhost = dbfen.isLocalhost(host);
			//生成类型列表
			var TASK_TYPE = Task.TASK_TYPE;
			var html = [];
			$.each(list, function(i, task){
				switch(task.taskType){
				case TASK_TYPE.file:
					if(isLocalhost){//本地主机/
						html.push('<option value="'+task.taskType+'" taskid="'+task.taskId+'" tasktype="'+task.taskType+'">文件</option>');
					}
					break;
				case TASK_TYPE.mysql:
                    if( task.host == host ){
					    html.push('<option value="'+task.taskType+'" taskid="'+task.taskId+'" tasktype="'+task.taskType+'">MySQL</option>');
                    };
					break;
				case TASK_TYPE.mssql:
                    if( task.host == host ) {
                        html.push('<option value="' + task.taskType + '" taskid="' + task.taskId + '" tasktype="' + task.taskType + '">MSSQL</option>');
                    };
					break;
                case TASK_TYPE.oracle:
                    if( task.host == host ) {
                        html.push('<option value="' + task.taskType + '" taskid="' + task.taskId + '" tasktype="' + task.taskType + '">Oracle</option>');
                    };
                    break;
				}
			});
			$("#recoverType").html(html.join(""));
			$(".z-typeName").text($("#recoverType option:selected").text());

			//更新备份时间版本
			var taskId = $("#recoverType option:selected").attr("taskId");
			$.each(list, function(i, task){
				if(taskId == task.taskId){
					updateDateList(task);
				}
			});
		}
		/** 更新任务的时间版本列表 */
		function updateDateList(task){
			Task.getInfo(task, function(result){
				var task = result.data || {list:[]};
				task.backupList = task.backupList || [];
				var backup = task.backupList[0] || {
					count:0,
					uploadSize: 0,
					backupDate: 0
				};
				//取最新的成功备份记录
				for(var i in task.backupList){
					var item = task.backupList[i];
					if(item.errCode == 0){
						backup = item;
						break;
					}
				}
				if(backup.backupDate>0){
					var date = new Date(backup.backupDate*1000);
					$(".z-modify").text(date.format("yyyy-MM-dd hh:mm:ss"));
				}
				//时间下拉框
				var html=[];
				$.each(task.backupList||[], function(i, backup){
					if(backup.errCode != 0){//不是成功的任务
						return;
					}
					var date = new Date(backup.backupDate*1000);
					backup.formatDate=date.format("yyyy-MM-dd hh:mm:ss") ;
					var h ='<option value="'+backup.backupDate+'" date="'+backup.backupDate+'" num="'+(backup.changedFields||0)+'" count="'+dbfen.formatByte(backup.changedSize)+'">'+backup.formatDate+'</option>';
					html.push( h);
				});
				var h = html.join("");
				$("#recoverDate").html( h );

				//取最新的成功备份记录
				for(var i in task.backupList){
					var item = task.backupList[i];
					if(item.errCode == 0){
						backup = item;
						break;
					}
				}
				if(backup.backupDate>0){
					var date = new Date(backup.backupDate*1000);
					$(".z-modify").text(date.format("yyyy-MM-dd hh:mm:ss"));
				}
				
				$(".z-fileNum").text(backup.totalFiles);
				$(".z-fileSize").text(dbfen.formatByte(backup.totalSize));
				$(".z-locaInp").val(backup.backup||"");
				$("#content").empty().removeAttr("class").hide();

				//dbfen.isLocalhost(task.host) ? $(".z-line-location").show() : $(".z-line-location").hide();
				var $option = $("#recoverDate option:selected");
				task.date = $option.attr("date");//时间 版本

				updateViewContent(task);//更新恢复内容列表
				updateViewProgress(task);
			});
		}
		/** 更新进度条 */
		function updateViewProgress(_task){
            //判断此任务是否有东西在处理(备份,恢复,迁移等)
            Task.isHandle(_task, function(result){
                var data_T = result.data;
                if(data_T.isHandle){
                    $(".z-recoverBtn").removeAttr("id").addClass("btn-disable").siblings(".z-tips").show();
                }else{
                    $(".z-recoverBtn").attr("id", "recoverBtn").removeClass("btn-disable").siblings(".z-tips").hide();
                }
            });

            var $state = $("#state");
			_task.taskFilter = Task.TASK_FILTER.recovery;
			//取任务状态
			Task.getState(_task, function(result){
				var task = result.data;
				var TASK_STATE = Task.TASK_STATE;
                if(parseInt(task.startTime)<=0 && parseInt(new Date().getTime()) < parseInt(task.startTime)*1000){
                    return;
                }
				if(result.code == 0){
					var scanSize = parseInt(task.scanSize);//扫描大小
					var totalSize = parseInt(task.totalSize);//总大小
					var progress = parseInt(scanSize * 100 / totalSize) || 0;//进度
                    if( progress == "100" ){
                        progress = "99";
                    }
					switch(task.taskState){
					case TASK_STATE.recoveryFile:
					case TASK_STATE.recoveryWait:
					case TASK_STATE.recoveryDb:
						$state.show();
						break;
					case TASK_STATE.recoveryFinish://恢复完成
						clearTimeout(recoveryPid);//停止循环
						progress = "100";
						if(isExecRecovery){
                            isExecRecovery = false;
                            if(task.taskType == Task.TASK_TYPE.oracle){
                                $.alert("亲，恢复完成，建议再执行一次备份");
                            }else{
                                $.alert("亲，恢复完成");
                            }

						}
						$state.show();
						break;
					}

					/* 进度条  */
					if(parseInt(task.startTime)>0){
						var date = new Date(parseInt(task.startTime)*1000);
						$state.find(".z-time p").text(date.format('yyyy-MM-dd hh:mm:ss'));
					}
					if(_task.taskType==Task.TASK_TYPE.file){
						$(".backup-list .z-type").html("文件恢复进度");
					}else if(_task.taskType==Task.TASK_TYPE.mysql){
						$(".backup-list .z-type").html("MySQL恢复进度");
					}else if(_task.taskType==Task.TASK_TYPE.mssql){
						$(".backup-list .z-type").html("MSSQL恢复进度");
					}else{
                        $(".backup-list .z-type").html("Oracle恢复进度");
                    }
					progress = progress+"%";
					$state.find(".z-tip").hide();
					$state.find(".z-progress").show();

					$state.find(".z-num p").html("文件数:&nbsp;"+task.totalFiles);//文件变化
					$state.find(".z-size p").html("大小:&nbsp;"+dbfen.formatByte(totalSize||0));//文件变化
					$state.find(".text").text(progress);
					$state.find(".plan").css("width", progress);
					/* */
				}else{
					$.alert(result.msg || "取任务状态信息失败~~");
				}
			});
		}
	
		/** 
			更新内容,用户选择的备份内容
		*/
		function updateViewContent(task){
			$("#content").html("");
			if( task.taskType == Task.TASK_TYPE.file){//恢复类型,文件
				$(".content-div .z-ic").attr("class", "file-ic z-ic");
				treeContent = new Tree({
					id: "content",
					autoload: false,//任务类型 恢复
					url: '/task/get_restore_list?taskId='+task.taskId+"&taskType="+task.taskType+"&date="+task.date
				});
			}else if(task.taskType == Task.TASK_TYPE.mssql){//恢复类型, mssql
				$(".content-div .z-ic").attr("class", "mysql-ic z-ic");
				__updateViewDatabase({
					taskId: task.taskId,
					taskType: task.taskType,
					date: task.date
				});
			}else if(task.taskType == Task.TASK_TYPE.mysql){//mysql
				$(".content-div .z-ic").attr("class", "mssql-ic z-ic");
				__updateViewDatabase({
					taskId: task.taskId,
					taskType: task.taskType,
					date: task.date
				});
			};
			$("#all").prop("checked",false);
		}
		/**
			取数据库列表并显示
			task: {
				taskId,
				taskType,
				date
			}
		*/
		function __updateViewDatabase (task){
			//取任务列表
			$("#content").append('<ul class="list"></ul>');
			//取用户备份内容列表(用户创建任务时,选择的要备份内容)
			Task.getBackupContentList(task, function(result){
				switch(result.code){
				case 0:
					var list = result.data.list || [];
					var html = [];
					for(var i=0;i<list.length;i++){
						var item = list[i]||{};
						var h = '';
						h+='<li class="cf">';
						if(item.checked){
							h+='<label class="checkbox-beauty"><input type="checkbox" value="'+item.name+'" checked/><span class="spr"></span><span class="mysql-ic">'+item.name+'</span></label>';
						}else{
							h+='<label class="checkbox-beauty"><input type="checkbox" value="'+item.name+'"/><span class="spr"></span><span class="mysql-ic">'+item.name+'</label>';
						}							
						h+='</li>';
						html.push(h);
					}
					$(".list").html(html.join(""));
					break;
				default: 
					$("#recoverBtn").tips(result.msg||'创建失败');
				}
			});
		}
		//从下拉框里取用户选择的任务信息
		function getTaskFromSelect(){
			$task = $("#recoverType option:selected");
			return {
				taskId: $task.attr("taskId"),
				taskType: $task.attr("taskType")
			}
		}
		module.exports = Module;
	})
})();