/**
* 模板编译类, 对模板语言做处理,自动转化为对应的值
*@author kenny
*/
(function(){
	define("lib/util/template", function(require, exports, module){
		var REG_VAR = /\$\{\s*\w*\s*\}/g;
		function isNull(v){
			return v == null || v=== undefined;
		}
		var Module = {
			/**
			*	编译字符
				param:
					str: 字符串,
					data: 对象数据 {} 这种格式
				例子:
					var demo = '<p>${name}</p>';
					var html = compile(demo, {name:'kenny'});
					console.log(html);
					//>输出: <p>kenny</p>
			*/
			compile: function(str, data){
				if(str instanceof String){
					str = str.replace(REG_VAR, function(name){
						name = name.replace(/(\$\{)|(\})/g, "").replace(/(^\s*)|(\s*$)/g, "");
						return isNull(data[name]) ? "" : data[name];
					});
				}
				return str||"";
			}
		};
		module.exports = Module;
	});
})();