/**
 * 	消息传送模块
 *   @author kenny
 */
(function() {
	define("lib/util/message", function(require, exports, module) {
		var Module = {
			send: function(win, data) {
				if(win instanceof jQuery){
					win =  win[0];
				}
				if(!win){
					return;
				}
				if (win.nodeType == 1 && win.tagName == "IFRAME") {
					win = win.contentWindow;
				}
				var tar = location.protocol + "//" + location.host;
				win.postMessage(data, tar);
			},
			on: function(callback) {
				$(window).on({
					message: function(e) {
						try {
							var oEvent = e.originalEvent || {};
							var data = oEvent.data ;
							callback && callback(data);
						} catch (e) {
							console.log(e.stack, e);
						}
					}
				});
			}
		};
		module.exports = Module;
	});
})();