/**
 * iframe组件,自适应
 * @author kenny
 */
(function() {
	//iframe高度自适应
	function autoSize(iframe) {
			if (iframe) { //ff
				if (iframe.contentDocument && iframe.contentDocument.body.offsetHeight) {
					iframe.height = iframe.contentDocument.body.offsetHeight;
				} else if (iframe.Document && iframe.Document.body.scrollHeight) {
					iframe.height = iframe.Document.body.scrollHeight;
				}
			}
		}
		//iframe宽度自适应
	function autoWidth(iframe) {
		if (iframe) { //ff
			if (iframe.contentDocument && iframe.contentDocument.body.offsetWidth) {
				iframe.width = iframe.contentDocument.body.offsetWidth;
			} else if (iframe.Document && iframe.Document.body.scrollWidth) { //ie
				iframe.width = iframe.Document.body.scrollWidth;
			}
		}
	}
	define("lib/jquery/iframe", function(require, exports, module) {
		$.fn.iframeAuto = function(iframe) {
			iframe = $(iframe)[0] || this;
			autoSize(iframe);
			autoWidth(iframe);
		}
		module.exports = $;
	});
})();