/**
* 用户相关api
* 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
*@author kenny
*/
(function() {
	define("dbfen/client/api/user", function(require, exports, module) {
		require("lib/jquery/cookie");
		require("lib/jquery/layer");
		//require("lib/jquery/scrollbar");
		var dbfen = require("dbfen/client/com/dbfen");

		function writeLoginCookie(user){
			var expires = new Date();
				expires.setFullYear(expires.getFullYear() + 99); //保存99年
			var cookieConfig = {//cookie参数
				path: "/",
				expires: expires
			};
			//$.cookie('email', user.email, cookieConfig);
		}
		var Module = {
			/*
			* 检测用户是否需要登录
			* 参数: 
				callback: 回调
				param: {
					isShow:false , //如果isShow=true, 表示如果检测到用户未登录,会弹出登录窗口让用户登录
				}
			*/
			checkLogin: function(callback, param) {
				Module.getUser(function(user){
					if(user){
						callback && callback(user);
					}else{
						if(param && param.isShow){
							Module.showViewLogin(function(){
								Module.getUser(function(user){
									callback && callback(user);
								});
							});
						}else{
							callback && callback(null);
						}						
					}
				});
			},
			/**
			*	用户登录接口
			* param:
				user:{
					email:
					password
				}
				callback: function(data){

				}
			*/
			login: function(user, callback) {	
				var newUser = $.extend({}, user);
				newUser.password = dbfen.en(newUser.password);						
				dbfen.ajax({
					url: "/user/login",
					data: newUser,
					success: function(result) {
						var user = result.data || {};
						switch (result.code) {
							case 0:
								writeLoginCookie(user);
								try{
									parent.$ && parent.$(parent).trigger("login");//触发登录事件
									if(parent.mainWindow){
										parent.mainWindow.$(parent.mainWindow).trigger("login");
									}
								}catch(e){
									console.log(e);
								}
								callback && callback(result);
								break;
							default:
								callback && callback(result);
								break;
						}
					}
				});
			},
			/** 
			 * 取用户信息
			 */
			getUser: function(callback) {
				//var token = $.cookie('token');
				var email = $.cookie('email');
				var user ;
				if(email){
					user = {
						email: email
					};
				}
				if (user) {
					callback && callback(user);
				} else {
					callback && callback(null);
				}
			},
			/** 
			 * 用户注册
			 */
			register: function(user, callback) {
				var newUser = $.extend({}, user);
				newUser.password = dbfen.en(newUser.password);		
				dbfen.ajax({
					url: '/user/register',
					data: newUser,
					success: function(result){
						writeLoginCookie(result.data);
						parent.$(parent.document.body).trigger("login");//触发登录
						callback && callback(result);
					}
				});
			},
			/** 显示登录页面 */
			showViewLogin: function(callback) {
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/user/login.html',
					checkLogin: false, //不需要登录
					callback: callback,
					height: "300px"
				});	
				/*parent.seajs.use("lib/jquery/layer", function() {
					var layer = parent.__popWindowId;
					parent.__popWindowId = parent.$.layer({
						type: 2,
						shade: [0.2, '#000'],
						shadeClose: false,
						closeBtn: [0, true],
						title: '登录',
						iframe: {
							src: getBaseUrl() + '/view/user/login.html?' + new Date().getTime()
						},
						area: ['400px', '390'],
						border: [1, 1, '#ccc'],
						close: function(index) {
							callback && callback();
							// layer.msg('您获得了子窗口标记：' + layer.getChildFrame('#name', index).val(),3,1);
						}
					});
					parent.$("#xubox_layer"+layer+", #xubox_shade"+layer).remove();
				});*/
			},
			/** 显示注册页面 */
			showViewRegister: function() {
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/user/register.html',
					checkLogin: false //不需要登录
				});	
				/*parent.seajs.use("lib/jquery/layer", function() {
					var layer = parent.__popWindowId;
					parent.__popWindowId =parent.$.layer({
						type: 2,
						shade: [0.2, '#000'],
						shadeClose: false,
						closeBtn: [0, true],
						fix: false,
						title: '注册',
						iframe: {
							src: getBaseUrl() + '/view/user/register.html?' + new Date().getTime()
						},
						area: ['400px', '390'],
						border: [1, 1, '#ccc'],
						close: function(index) {}
					});

					parent.$("#xubox_layer"+layer+", #xubox_shade"+layer).remove();
				});*/
			},
            showViewFirst: function(){
                dbfen.popWindow({//打开页面,默认需要登录
                    url:'/view/user/first.html',
                    checkLogin: false, //不需要登录
                    height:240
                });
            }
		};
        window.User = Module;
		module.exports = Module;
	});
})();