/**
 * 任务相关api oracle
 * 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
 *@author kenny
 */
(function() {
    var g_taskType = 4;//任务类型
    define("dbfen/client/api/task/oracle", function(require, exports, module) {
        var dbfen = require("dbfen/client/com/dbfen");
        var User = require("dbfen/client/api/user");
        var Task = require("dbfen/client/api/task");
        var Module = {
            //添加任务
            create: function(task, callback) {
                resetTask(task);
                dbfen.ajax({
                    url: "/task/db/create",
                    data: task,
                    success: callback
                });
            },
            /**
             * 设置环境参数
             * task:{taskId,taskType,host,port,userName,passord}
             */
            setting: function(task, callback) {
                resetTask(task);
                dbfen.ajax({
                    url: "/task/db/setting",
                    data: task,
                    success: callback
                });
            },
            /**
             * 取得环境参数
             */
            getSetting: function(task, callback) {
                resetTask(task);
                dbfen.ajax({
                    url: "/task/db/get_setting",
                    data: task,
                    success: function(result){
                        var data = result.data || {};
                        data.password = dbfen.de(data.password);
                        callback && callback(result);
                    }
                });
            },
            /**
             * 设置备份
             * task:{taskId,taskType,host,port,userName,passord}
             * schedType: schedType,
             schedData:schedData
             */
            setBackup: function(task, callback) {
                resetTask(task);
                dbfen.ajax({
                    url: "/task/db/set_backup",
                    data: task,
                    success: callback
                });
            },
            /**
             *	取得备份设置
             */
            getBackup: function(task, callback) {
                resetTask(task);
                dbfen.ajax({
                    url: "/task/db/get_backup",
                    data: task,
                    success: callback
                });
            },
            /**
             *	取得报告
             */
            getReportList: function(task, callback) {
                resetTask(task);
                Task.getInfo(task, function(result){
                    var data = result.data || {};
                    var res = {
                        code: result.code,
                        data: {
                            list: data.backupList || []
                        }
                    };
                    callback && callback(res);
                });
            },
            /**
             *显示编辑参数页面
             * param: {taskId, taskType}
             */
            showViewSetting: function(task) {
                resetTask(task);
                dbfen.popWindow({//打开页面,默认需要登录
                    url:'/view/task/oracle/setting.html?' + $.param(task),
                    title:'编辑参数'
                });
            },
            /**
             *	显示临时文件目录页面
             */
            showDir: function() {
                dbfen.popWindow({
                    url: "/view/task/oracle/dir.html",
                    title:'临时文件目录'
                });
            },
            /**
             *显示查看mssql报告
             * param: {taskId, taskType}
             */
            showViewReports: function(task) {
                resetTask(task);
                dbfen.popWindow({//打开页面,默认需要登录
                    url:'/view/task/oracle/reports.html?' + $.param(task),
                    title:'查看报告',
                    width: '500px'
                });
            },
            showViewBackup: function(task) {
                resetTask(task);
                dbfen.popWindow({//打开页面,默认需要登录
                    url:'/view/task/oracle/backup.html?' + $.param(task),
                    title:'设置备份'
                });
            }
        };
        function resetTask(task){
            task.taskType =  g_taskType;
            return task;
        }
        module.exports = Module;
    });

})();