/**
* 任务相关api mysql
* 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
*@author kenny
*/
(function() {
	var g_taskType = 1,//任务类型
		g_dbType = 1; //db类型
	define("dbfen/client/api/task/mysql", function(require, exports, module) {
		var dbfen = require("dbfen/client/com/dbfen");
		var User = require("dbfen/client/api/user");
		var Task = require("dbfen/client/api/task");
		var Module = {
			//添加任务
			create: function(task, callback) {
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);	
				dbfen.ajax({
					url: "/task/db/create",
					data: newTask,
					success: callback
				});
			},
			/* 检测db连接能否成功 
				task:{
					taskType,//任务类型
					instance,//实例名
					userName,//用户名
					password //密码
				}
			*/
			connect: function(task, callback){
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);	
				dbfen.ajax({
					url: "/task/db/connect",
					data: newTask,
					success: callback
				});
			},
			/**
			 * 设置环境参数
             * task:{taskId,taskType,host,port,userName,passord}
			 */
			setting: function(task, callback) {
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);	
				dbfen.ajax({
					url: "/task/db/setting",
					data: newTask,
					success: callback
				});
			},
			/**
			 * 取得环境参数
			 */
			getSetting: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_setting",
					data: task,
					success: function(result){
						var data = result.data || {};
						data.password = dbfen.de(data.password);	
						callback && callback(result);
					}
				});
			},
			/**
			 * 设置备份
             * task:{taskId,taskType,host,port,userName,passord}
             * schedType: schedType,
             schedData:schedData
			 */
			setBackup: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/set_backup",
					data: task,
					success: callback
				});
			},
			/**
			 *	取得备份设置
			 */
			getBackup: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_backup",
					data: task,
					success: callback
				});
			},
			/**
			 *	取得报告
			 */
			getReportList: function(task, callback) {
				resetTask(task);
				Task.getInfo(task, function(result){
					var data = result.data || {};
					var res = {
						code: result.code,
						data: {
							list: data.backupList || []
						}
					};
					callback && callback(res);
				});
			},
			/**
			 *	设置数据库
			 	参数:
			 	task: {
					names: ["db1", "db2"] //数据库名字列表
			 	}
			 */
			setDB: function(task, callback) {
				resetTask(task);
				if(task.names instanceof Array){
					task.names = task.names.join(",");
				}
				dbfen.ajax({
					url: "/task/db/set_db",
					data: task,
					success: callback
				});
			},
			/**
			 * 	取数数据库列表
             * 	task:{taskId,taskType}
			 */
			getDBList: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_db_list",
					data: task,
					success: callback
				});
			},
			//显示数据库选择页面
			showViewSelect: function() {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/select.html?'+$.param(task),
					title:'添加数据库'
				});
			},
			//显示数据库创建页面
			showViewCreate: function(param) {
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/create.html?'+$.param(param||{}),
					title:'填写参数'
				});
			},
			/**
			 *显示页面,,,显示实例选择页面
			 * param: {taskId, taskType}
			 */
			showViewDB: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/db.html?'+$.param(task),
					title:'选择数据库'
				});
			},
			/**
			 *显示编辑参数页面,,
			 * param: {taskId, taskType}
			 */
			showViewSetting: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/setting.html?'+$.param(task),
					title:'编辑参数'
				});		
			},
			/**
			 *显示查看MYSQL报告,,
			 * param: {taskId, taskType}
			 */
			showViewReports: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/reports.html?' + $.param(task),
					title:'查看报告',
					width: '500px'
				});			
			},
			showViewBackup: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mysql/backup.html?' + $.param(task),
					title:'设置备份'
				});				
			}
		};
		function resetTask(task){
			task.taskType =  g_taskType;
			return task;
		}
		module.exports = Module;
	});

})();