/**
* 任务相关api mssql
* 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
*@author kenny
*/
(function() {
	var g_taskType = 2;//任务类型

	define("dbfen/client/api/task/mssql", function(require, exports, module) {
		var dbfen = require("dbfen/client/com/dbfen");
		var User = require("dbfen/client/api/user");
		var Task = require("dbfen/client/api/task");
		var Module = {
			//添加任务
			create: function(task, callback) {
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);	
				dbfen.ajax({
					url: "/task/db/create",
					data: newTask,
					success: callback
				});
			},
			/* 检测db连接能否成功 
				task:{
					taskType,//任务类型
					instance,//实例名
					userName,//用户名
					password//密码
				}
			*/
			connect: function(task, callback){
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);		
				dbfen.ajax({
					url: "/task/db/connect",
					data: newTask,
					success: callback
				});
			},
            /* 检测远程连接能否成功
             task:{
                 rpcUserName,//远程用户名
                 rpcPassword,//远程密码
                 rpcPath,//共享目录
                 localMapPath//映射目录
             }
             */
            connecRemote: function(task, callback){
                resetTask(task);
                var newTask = $.extend({}, task);
                newTask.rpcPassword = dbfen.en(newTask.rpcPassword);
                dbfen.ajax({
                    url: "/task/db/checkpath",
                    data: newTask,
                    success: callback
                });
            },
			/**
			 * 设置环境参数
			 */
			setting: function(task, callback) {
				resetTask(task);
				var newTask = $.extend({}, task);
				newTask.password = dbfen.en(newTask.password);
				dbfen.ajax({
					url: "/task/db/setting",
					data: newTask,
					success: callback
				});
			},
			/**
			 * 取得环境参数
			 */
			getSetting: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_setting",
					data: task,
					success: function(result){
						var data = result.data || {};
						data.password       = dbfen.de(data.password || "");
                        data.rpcPassword    = dbfen.de(data.rpcPassword || "");
                        data.rpcPath        = dbfen.justEscape(data.rpcPath || "");
                        data.localMapPath   = dbfen.justEscape(data.localMapPath || "");
						callback && callback(result);
					}
				});
			},
			/**
			 * 设置备份
			 */
			setBackup: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/set_backup",
					data: task,
					success: callback
				});
			},
			/**
			 *	取得备份设置
			 */
			getBackup: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_backup",
					data: task,
					success: callback
				});
			},
			/**
			 *	取得报告
			 */
			getReportList: function(task, callback) {
				resetTask(task);
				Task.getInfo(task, function(result){
					var data = result.data || {};
					var res = {
						code: result.code,
						data: {
							list: data.backupList || []
						}
					};
					callback && callback(res);
				});
			},
			/** 
				取数据库实例列表
			*/
			getInstances: function(task, callback){
				if(task instanceof Function){
					callback = task;
					task = {};
				}
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_db_instance",
					data: task,
					success: callback
				});
			},
			/**
			 *	设置数据库实例
			 */
			setDB: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/set_db",
					data: task,
					success: callback
				});
			},
			/**
			 * 	取数数据库实例列表
			 */
			getDBList: function(task, callback) {
				resetTask(task);
				dbfen.ajax({
					url: "/task/db/get_db_list",
					data: task,
					success: callback
				});
			},
			//显示数据库选择页面
			showViewSelect: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/select.html',
					title:'添加数据库'
				});	
			},
			//显示数据库创建页面
			showViewCreate: function(task) {
                task = task || {};
                var newTask = $.extend({}, task);
                newTask.rpcPassword = dbfen.en(newTask.rpcPassword || "");
                newTask.rpcPath     = dbfen.antiEscape(newTask.rpcPath || "");
                newTask.localMapPath= dbfen.antiEscape(newTask.localMapPath || "");
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/create.html?' + $.param(newTask),
					title:'填写参数'
				});
			},
			//显示远程数据库创建页面
			showViewCreateRemote: function(task) {
                task = task || {};
                var newTask = $.extend({}, task);
                newTask.rpcPassword = dbfen.de(newTask.rpcPassword || "");
                newTask.rpcPath     = dbfen.justEscape(newTask.rpcPath || "");
                newTask.localMapPath= dbfen.justEscape(newTask.localMapPath || "");
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/create_remote.html?' + $.param(newTask),
					title:'填写参数'
                    //height: "412px"
				});
			},
			/**
			 *显示页面,,,显示实例选择页面
			 * param: {taskId, taskType}
			 */
			showViewDB: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/db.html?' + $.param(task),
					title:'选择数据库'
				});
			},
			/**
			 *显示编辑参数页面
			 * param: {taskId, taskType}
			 */
			showViewSetting: function(task) {
				resetTask(task);
                var newTask = $.extend({}, task);
                newTask.rpcPassword = dbfen.en(newTask.rpcPassword);
                newTask.rpcPath     = dbfen.antiEscape(newTask.rpcPath || "");
                newTask.localMapPath= dbfen.antiEscape(newTask.localMapPath || "");
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/setting.html?' + $.param(newTask),
					title:'编辑参数'
				});			
			},
            /**
             *显示远程数据库编辑页面
             * param: {taskId, taskType}
             */
            showViewSettingRemote: function(task) {
                resetTask(task);
                dbfen.popWindow({//打开页面,默认需要登录
                    url:'/view/task/mssql/setting_remote.html?' + $.param(task),
                    title:'编辑参数'
                   // height: "412px"
                });
            },
			/**
			 *显示查看mssql报告
			 * param: {taskId, taskType}
			 */
			showViewReports: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/reports.html?' + $.param(task),
					title:'查看报告',
					width: '500px'
				});			
			},
			showViewBackup: function(task) {
				resetTask(task);
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/mssql/backup.html?' + $.param(task),
					title:'设置备份'
				});			
			}
		};

		function resetTask(task){
			task.taskType =  g_taskType;
			return task;
		}

		module.exports = Module;
	});

})();