/**
* 任务相关api file
* 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
*@author kenny
*/
(function() {
	var g_taskType = 0;//任务类型, 文件
	define("dbfen/client/api/task/file", function(require, exports, module) {
		var dbfen = require("dbfen/client/com/dbfen");
		var User = require("dbfen/client/api/user");
		var Task = require("dbfen/client/api/task");
		var Module = {
			getUrlDir: function(){//取文件目录的请求url地址
				if(dbfen.getEnvironment() == "local"){
					return "/testdata/task/file/get_dir_list.json";
				}
				return "/task/file/get_dir_list";
			},
			//添加任务
			create: function(task, callback) {
				task.taskType = g_taskType;
				dbfen.ajax({
					url: "/task/file/create",
					data: task,
					success: callback
				});
			},
			/**
			 * 设置环境参数
			 */
			setting: function(task, callback) {
				task.taskType = g_taskType;
				dbfen.ajax({
					url: "/task/file/edit",
					data: task,
					success: callback
				});
			},
			/**
			 * 设置备份
			 */
			setBackup: function(task, callback) {
				task.taskType = g_taskType;
				dbfen.ajax({
					url: "/task/file/set_backup",
					data: task,
					success: callback
				});
			},
			/**
			 *	取得备份设置
			 */
			getBackup: function(task, callback) {
				task.taskType = g_taskType;
				dbfen.ajax({
					url: "/task/file/get_backup",
					data: task,
					type: "get",
					success: callback
				});
			},
			/**
			 *	取得报告
			 */
			getReportList: function(task, callback) {
				task.taskType = g_taskType;
				Task.getInfo(task, function(result){
					var data = result.data || {};
					var res = {
						code: result.code,
						data: {
							list: data.backupList || []
						}
					};
					callback && callback(res);
				});
				/*dbfen.ajax({
					url: "/task/file/get_report_list",
					data: task,
					type: "get",
					success: callback
				});*/
			},
			/*显示数据库选择页面
			showViewSelect: function() {
				User.checkLogin(function(user){//检测用户登录
					if(!user) return;//用户登录没有成功或没有登录
					parent.seajs.use("lib/jquery/layer", function() {
						var layer = parent.__popWindowId;
						parent.__popWindowId = parent.$.layer({
							type: 2,
							shade: [0.2, '#000'],
							shadeClose: false,
							closeBtn: [0, true],
							fix: false,
							title: '选择数据库',
							iframe: {
								src: getBaseUrl() + '/view/task/file/select.html?' + new Date().getTime()
							},
							area: ['400px', '390'],
							border: [1, 1, '#ccc'],
							close: function(index) {}
						});
						parent.$("#xubox_layer" + layer + ", #xubox_shade" + layer).remove();
					});
				}, {
					isShow: true
				});
				
			},*/
			//显示数据库创建页面
			showViewCreate: function() {
				dbfen.popWindow({//打开页面,默认需要登录
					url:'/view/task/file/create.html',
					title:'选择文件'
				});
			},
			/**
			 *显示页面,,,显示实例选择页面
			 * param: {taskId, taskType}
			 */
			showViewDir: function(task) {
				task.taskType = g_taskType;
				dbfen.popWindow({//打开页面,默认需要登录
					title: '选择文件',
					url:'/view/task/file/dir.html?' + $.param(task)
				});				
			},
			/**
			 *显示编辑参数页面,,
			 * param: {taskId, taskType}
			 */
			showViewSetting: function(task) {
				task.taskType = g_taskType;
				dbfen.popWindow({//打开页面,默认需要登录
					title: '选择文件',
					url:'/view/task/file/setting.html?' + $.param(task)
				});			
			},
			/**
			 *显示查看file报告,,
			 * param: {taskId, taskType}
			 */
			showViewReports: function(task) {
				task.taskType = g_taskType;
				dbfen.popWindow({//打开页面,默认需要登录
					title: '查看报告',
					url:'/view/task/file/reports.html?' + $.param(task),
					width: '500px'
				});				
			},
			/** 
				显示备份页面 
				task:{ taskId, taskType }
			*/
			showViewBackup: function(task) {
				task.taskType = g_taskType;
				dbfen.popWindow({//打开页面,默认需要登录
					title: '设置备份',
					url:'/view/task/file/backup.html?' + $.param(task)
				});			
			},
			/**
			 *显示恢复页面选择目录,,
			 * param: {taskId, taskType}
			 */
			showViewRecoveryDir: function(task) {
				task.taskType = g_taskType;
				dbfen.popWindow({//打开页面,默认需要登录
					title: '恢复',
					url:'/view/recover/selectdir.html?' + $.param(task)
				});			
			}
		};

		module.exports = Module;
	});

})();