/**
 * 系统相关api
 * 使用: seajs.use("dbfen/client/api/user", function(User){

		User.login({userId:33});
	});
 *@author kenny
 */
(function () {
    define("dbfen/client/api/system", function (require, exports, module) {
        var dbfen = require("dbfen/client/com/dbfen");
        var isExecLoad = false;//是否执行过load
        var Module = {
            //取系统配置信息
            get: function (callback) {
                dbfen.ajax({
                    url: "/sysinfo/get",
                    data: {},
                    success: function (result) {
                        callback && callback(result, result.data);
                    }
                });
            },
            /**
             * 系统进度状态重置
             * @param callback
             */
            reflesh: function (callback) {
                $.ajax({
                    url: "/system/reflesh",
                    data: {},
                    dataType: "json",
                    success: function (result) {
                        isExecLoad = true;
                        callback && callback(result, result.data);
                    },
                    error: function (e) {
                        isExecLoad = true;
                        try {
                            console.error("调用system/reflesh,为不影响正常流程,出错也正常回调");
                        } catch (e) {
                        }
                        callback && callback({code:1, msg:"调用system/load接口出错",data:{}},{});
                    }
                });
            }
        };
        module.exports = Module;
    });

})();