/**
* 配置相关api
* 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
*@author kenny
*/
(function(){
	define("dbfen/client/api/setting", function(require, exports, module){
		var dbfen = require("dbfen/client/com/dbfen");
		var User = require("dbfen/client/api/user");
		var Module = {
			get: function(callback){
				dbfen.ajax({
					url:"/setting/get",
					data: {},
					success: callback
				});
			},
			set: function(info, callback){
				dbfen.ajax({
					url:"/setting/set",
					data: info,
					success: callback
				});
			},
			getLocalBackup: function(callback){
				dbfen.ajax({
					url:"/localbackup/get",
					data:{},
                    success: callback
				});
			},
			setLocalBackup: function(info, callback){
                var newInfo = $.extend({}, info);
                newInfo.dataPath= dbfen.antiEscape(newInfo.dataPath || "");
				dbfen.ajax({
					url:"/localbackup/set",
					data: newInfo,
					success: callback
				});
			},
			/** 邮件通知 */
			showViewEmailNotice: function() {
				dbfen.popWindow({//打开页面,默认需要登录
					title:'邮件设置',
					url:'/view/setting/email.html' 
				});	
			},
			/** 速度限制 */
			showViewSpeedLimit: function() {
				dbfen.popWindow({//打开页面,默认需要登录
					title:'速度限制',
					url:'/view/setting/speed.html' 
				});	
			},
			/** 混合备份 */
			showViewLocal: function(){
				dbfen.popWindow({//打开页面,默认需要登录
					title:'混合备份',
					url:'/view/setting/local.html',
					height: "420px"
				});	
			}
		};
		module.exports = Module;
	});

})();