/**
 * 容灾数据恢复
 * 使用: seajs.use("dbfen/client/api/user", function(User){
	
		User.login({userId:33});
	});
 *@author kenny
 */
(function () {
    define("dbfen/client/api/disaster", function (require, exports, module) {
        require("lib/jquery/cookie");
        var dbfen = require("dbfen/client/com/dbfen");

        var Module = {
            getList: function (callback) {
                dbfen.ajax({
                    url: "/task/get_migrate_list",
                    success: function (result) {
                        var data = result.data || {};
                        switch (result.code) {
                            case 1: //正在下载中
                                setTimeout(function () {
                                    Module.getList(callback)
                                }, 2000);
                                break;
                            case 2: //没有记录
                            default :
                                callback && callback(result, data);
                        }

                    }
                });
            },
            //停止容灾恢复
            stop: function(callback){
                dbfen.ajax({
                    url: "/task/migrate/stop",
                    success: function (result) {
                        var data = result.data || {};
                        callback && callback(result, data);
                    }
                });
            },
            //容灾恢复
            recovery: function(info, callback){
                var data = {
                    destPath: info.destPath,
                    taskList: info.taskList
                };
                dbfen.ajax({
                    url: "/task/migrate",
                    data: data,
                    success: function (result) {
                        var data = result.data || {};
                        switch (result.code) {
                            case 1: //正在下载中
                                setTimeout(function () {
                                    Module.getList(callback)
                                }, 2000);
                                break;
                            default :
                                callback && callback(result, data);
                        }
                    }
                });
            },
            getProgress: function () {

            },
            /**
             * 验证设备key
             * @param data
             * @param callback
             */
            check: function (param, callback) {
                var data = {
                    deviceID: param.deviceID,
                    key: param.key
                };
                dbfen.ajax({
                    url: "/legacy/load",
                    data: data,
                    success: function (result) {
                        var data = result.data || {};
                        callback && callback(result, data);
                    }
                });
            },
            /**
             * 是否在处理设备间的数据恢复
             */
            isRecoverying: function () {
                return $.cookie("handle_recovery") == "true";
            },
            clearStore: function(){
                $.cookie("handle_recovery", "", {path:"/",expires:0});
                $.cookie("handle_recovery_step", "", {path:"/",expires:0});
                $.cookie("handle_recovery_data", "", {path:"/",expires:0});
            },
            showViewList: function () {
                $.cookie("handle_recovery", "true", {path:"/",expires:makeExpires()});
                $.cookie("handle_recovery_step", "list", {path:"/",expires:makeExpires()});
                dbfen.popWindow({//打开页面,默认需要登录
                    title: '容灾恢复',
                    url: '/view/disaster/list.html'
                });
            },
            /**
             * 显示登录恢复页面,用户在登录系统后,根据设备id+密钥来显示数据恢复页面
             */
            showViewLoginRecovery: function (user) {
                dbfen.popWindow({//打开页面,默认需要登录
                    title: '容灾恢复',
                    url: '/view/disaster/login_recovery.html',
                    width: "420px",
                    height: "340px"
                });
            },
            /**
             * 显示设备间迁移恢复数据的进度
             */
            showViewRecoveryProgress: function (data) {
                //如果没有正在备份,就不打开
                if(!Module.isRecoverying()){
                    return;
                }
                $.cookie("handle_recovery_step", "progress", {path:"/",expires:makeExpires()});

                $.cookie("handle_recovery_data", JSON.stringify(data),{path:"/",expires:makeExpires()});

                dbfen.popWindow({//打开页面,默认需要登录
                    title: '容灾恢复',
                    url: '/view/disaster/device_recovery_progress.html?url='+data.url,
                    width: "420px",
                    height: "300px",
                    closeBtn: [0,0]
                });
            },
            showViewCurrentStep: function(){
                if(Disaster.isRecoverying()){
                    var step = $.cookie("handle_recovery_step");
                    if(step=="list"){
                        Module.showViewList();
                    }else if(step == "progress"){
                        var cookieData = $.cookie("handle_recovery_data");
                        try{
                            cookieData = JSON.parse(cookieData);
                        }catch(e){
                            cookieData = null;
                        }
                        Module.showViewRecoveryProgress({
                            url: cookieData.url
                        })
                    }
                }
            },
            /**
             取容灾恢复状态,
             task:{
					taskId:1 取单个任务时要传.批量取不用传
				}

             调用:
             getState(task,callback);
             getState(callback);
             */
            getState: function(callback){
                dbfen.ajax({//
                    url:"/task/migrate/get_progress",
                    success: function(result){
                        var res = {
                            code: result.code,
                            msg: result.msg
                        };
                        var data = result.data || {};
                        var list = data.list || [];
                        list = list.sort(function(d1, d2){
                            var t1 = parseInt( d1.finishTime );
                            var t2 = parseInt( d2.finishTime );
                            return t1 < t2;
                        });
                        res.data = result.data;
                        callback && callback(res);
                    }
                });
            }
        };
        function makeExpires(){
            var expires = new Date();
            expires.setFullYear(expires.getFullYear() + 99); //保存99年
            return expires;
        }
        window.Disaster = Module;
        module.exports = Module;
    });

})();