#include "tool_setup.h"
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 */
#ifdef USE_MANUAL
#include "tool_hugehelp.h"
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _\n"
"  Project                     ___| | | |  _ \\| |\n"
"                             / __| | | | |_) | |\n"
"                            | (__| |_| |  _ <| |___\n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options / URLs]\n"
"\n"
"DESCRIPTION\n"
"       curl  is  a tool to transfer data from or to a server, using one of the\n"
"       supported protocols (DICT, FILE, FTP, FTPS, GOPHER, HTTP, HTTPS,  IMAP,\n"
, stdout);
 fputs(
"       IMAPS,  LDAP,  LDAPS,  MQTT, POP3, POP3S, RTMP, RTMPS, RTSP, SCP, SFTP,\n"
"       SMB, SMBS, SMTP, SMTPS, TELNET and TFTP). The command  is  designed  to\n"
"       work without user interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support, user authen-\n"
"       tication, FTP upload, HTTP post, SSL connections, cookies, file  trans-\n"
"       fer  resume,  Metalink,  and more. As you will see below, the number of\n"
"       features will make your head spin!\n"
"\n"
, stdout);
 fputs(
"       curl is powered by  libcurl  for  all  transfer-related  features.  See\n"
"       libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax is protocol-dependent. You'll find a detailed descrip-\n"
"       tion in RFC 3986.\n"
"\n"
"       You can specify multiple URLs or parts of URLs  by  writing  part  sets\n"
"       within braces and quoting the URL as in:\n"
"\n"
"         \"http://site.{one,two,three}.com\"\n"
"\n"
"       or you can get sequences of alphanumeric series by using [] as in:\n"
"\n"
, stdout);
 fputs(
"         \"ftp://ftp.example.com/file[1-100].txt\"\n"
"\n"
"         \"ftp://ftp.example.com/file[001-100].txt\"    (with leading zeros)\n"
"\n"
"         \"ftp://ftp.example.com/file[a-z].txt\"\n"
"\n"
"       Nested  sequences  are not supported, but you can use several ones next\n"
"       to each other:\n"
"\n"
"         \"http://example.com/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\"\n"
"\n"
"       You can specify any amount of URLs on the command line.  They  will  be\n"
, stdout);
 fputs(
"       fetched  in a sequential manner in the specified order. You can specify\n"
"       command line options and URLs mixed and in any  order  on  the  command\n"
"       line.\n"
"\n"
"       You  can  specify a step counter for the ranges to get every Nth number\n"
"       or letter:\n"
"\n"
"         \"http://example.com/file[1-100:10].txt\"\n"
"\n"
"         \"http://example.com/file[a-z:2].txt\"\n"
"\n"
"       When using [] or {} sequences when invoked from a command line  prompt,\n"
, stdout);
 fputs(
"       you probably have to put the full URL within double quotes to avoid the\n"
"       shell from interfering with it. This also  goes  for  other  characters\n"
"       treated special, like for example '&', '?' and '*'.\n"
"\n"
"       Provide  the IPv6 zone index in the URL with an escaped percentage sign\n"
"       and the interface name. Like in\n"
"\n"
"         \"http://[fe80::3%25eth0]/\"\n"
"\n"
"       If you specify URL without protocol:// prefix,  curl  will  attempt  to\n"
, stdout);
 fputs(
"       guess  what  protocol  you might want. It will then default to HTTP but\n"
"       try other protocols based on often-used host name prefixes.  For  exam-\n"
"       ple,  for  host names starting with \"ftp.\" curl will assume you want to\n"
"       speak FTP.\n"
"\n"
"       curl will do its best to use what you pass to it as a URL.  It  is  not\n"
"       trying  to  validate it as a syntactically correct URL by any means but\n"
"       is instead very liberal with what it accepts.\n"
"\n"
, stdout);
 fputs(
"       curl will attempt to re-use connections for multiple file transfers, so\n"
"       that  getting many files from the same server will not do multiple con-\n"
"       nects / handshakes. This improves speed. Of course this is only done on\n"
"       files  specified  on  a  single command line and cannot be used between\n"
"       separate curl invokes.\n"
"\n"
"OUTPUT\n"
"       If not told otherwise, curl writes the received data to stdout. It  can\n"
, stdout);
 fputs(
"       be  instructed  to  instead save that data into a local file, using the\n"
"       -o, --output or -O, --remote-name options. If curl  is  given  multiple\n"
"       URLs  to  transfer on the command line, it similarly needs multiple op-\n"
"       tions for where to save them.\n"
"\n"
"       curl does not parse or otherwise \"understand\" the content  it  gets  or\n"
"       writes  as  output.  It does no encoding or decoding, unless explicitly\n"
"       asked so with dedicated command line options.\n"
"\n"
"PROTOCOLS\n"
, stdout);
 fputs(
"       curl supports numerous protocols, or put in URL  terms:  schemes.  Your\n"
"       particular build may not support them all.\n"
"\n"
"       DICT   Lets you lookup words using online dictionaries.\n"
"\n"
"       FILE   Read  or  write  local  files.  curl  does not support accessing\n"
"              file:// URL remotely, but when running on Microsoft Windows  us-\n"
"              ing the native UNC approach will work.\n"
"\n"
"       FTP(S) curl  supports  the  File Transfer Protocol with a lot of tweaks\n"
, stdout);
 fputs(
"              and levers. With or without using TLS.\n"
"\n"
"       GOPHER Retrieve files.\n"
"\n"
"       HTTP(S)\n"
"              curl supports HTTP with numerous options and variations. It  can\n"
"              speak HTTP version 0.9, 1.0, 1.1, 2 and 3 depending on build op-\n"
"              tions and the correct command line options.\n"
"\n"
"       IMAP(S)\n"
"              Using the mail reading protocol, curl can \"download\" emails  for\n"
"              you. With or without using TLS.\n"
"\n"
"       LDAP(S)\n"
, stdout);
 fputs(
"              curl can do directory lookups for you, with or without TLS.\n"
"\n"
"       MQTT   curl supports MQTT version 3. Downloading over MQTT equals \"sub-\n"
"              scribe\" to a topic while uploading/posting equals \"publish\" on a\n"
"              topic.  MQTT  support  is experimental and TLS based MQTT is not\n"
"              supported (yet).\n"
"\n"
"       POP3(S)\n"
"              Downloading from a pop3 server means getting  a  mail.  With  or\n"
"              without using TLS.\n"
"\n"
"       RTMP(S)\n"
, stdout);
 fputs(
"              The  Realtime  Messaging  Protocol  is  primarily used to server\n"
"              streaming media and curl can download it.\n"
"\n"
"       RTSP   curl supports RTSP 1.0 downloads.\n"
"\n"
"       SCP    curl supports SSH version 2 scp transfers.\n"
"\n"
"       SFTP   curl supports SFTP (draft 5) done over SSH version 2.\n"
"\n"
"       SMB(S) curl supports SMB version 1 for upload and download.\n"
"\n"
"       SMTP(S)\n"
"              Uploading contents to an SMTP server  means  sending  an  email.\n"
, stdout);
 fputs(
"              With or without TLS.\n"
"\n"
"       TELNET Telling curl to fetch a telnet URL starts an interactive session\n"
"              where it sends what it reads  on  stdin  and  outputs  what  the\n"
"              server sends it.\n"
"\n"
"       TFTP   curl can do TFTP downloads and uploads.\n"
"\n"
"PROGRESS METER\n"
"       curl  normally  displays a progress meter during operations, indicating\n"
"       the amount of transferred data,  transfer  speeds  and  estimated  time\n"
, stdout);
 fputs(
"       left,  etc.  The progress meter displays number of bytes and the speeds\n"
"       are in bytes per second. The suffixes (k, M, G, T, P) are  1024  based.\n"
"       For example 1k is 1024 bytes. 1M is 1048576 bytes.\n"
"\n"
"       curl  displays  this  data to the terminal by default, so if you invoke\n"
"       curl to do an operation and it is about to write data to the  terminal,\n"
"       it disables the progress meter as otherwise it would mess up the output\n"
, stdout);
 fputs(
"       mixing progress meter and response data.\n"
"\n"
"       If you want a progress meter for HTTP POST or PUT requests, you need to\n"
"       redirect  the  response output to a file, using shell redirect (>), -o,\n"
"       --output or similar.\n"
"\n"
"       It is not the same case for FTP upload as that operation does not  spit\n"
"       out any response data to the terminal.\n"
"\n"
"       If  you  prefer  a  progress  \"bar\"  instead  of the regular meter, -#,\n"
, stdout);
 fputs(
"       --progress-bar is your friend. You can also disable the progress  meter\n"
"       completely with the -s, --silent option.\n"
"\n"
"OPTIONS\n"
"       Options  start  with  one or two dashes. Many of the options require an\n"
"       additional value next to them.\n"
"\n"
"       The short \"single-dash\" form of the options, -d  for  example,  may  be\n"
"       used with or without a space between it and its value, although a space\n"
"       is a recommended separator. The long \"double-dash\" form, -d, --data for\n"
, stdout);
 fputs(
"       example, requires a space between it and its value.\n"
"\n"
"       Short version options that don't need any additional values can be used\n"
"       immediately next to each other, like for example you  can  specify  all\n"
"       the options -O, -L and -v at once as -OLv.\n"
"\n"
"       In general, all boolean options are enabled with --option and yet again\n"
"       disabled with --no-option. That is, you use the exact same option  name\n"
, stdout);
 fputs(
"       but prefix it with \"no-\". However, in this list we mostly only list and\n"
"       show the --option version of them. (This concept with --no options  was\n"
"       added  in  7.19.0.  Previously  most options were toggled on/off on re-\n"
"       peated use of the same command line option.)\n"
"\n"
"       --abstract-unix-socket <path>\n"
"              (HTTP) Connect through an abstract Unix domain  socket,  instead\n"
"              of  using  the  network.  Note: netstat shows the path of an ab-\n"
, stdout);
 fputs(
"              stract socket prefixed with '@',  however  the  <path>  argument\n"
"              should not have this leading character.\n"
"\n"
"              Added in 7.53.0.\n"
"\n"
"       --alt-svc <file name>\n"
"              (HTTPS) WARNING: this option is experimental. Do not use in pro-\n"
"              duction.\n"
"\n"
"              This option enables the alt-svc parser in curl. If the file name\n"
"              points to an existing alt-svc cache file, that will be used. Af-\n"
, stdout);
 fputs(
"              ter a completed transfer, the cache will be saved  to  the  file\n"
"              name again if it has been modified.\n"
"\n"
"              Specify a \"\" file name (zero length) to avoid loading/saving and\n"
"              make curl just handle the cache in memory.\n"
"\n"
"              If this option is used several times, curl  will  load  contents\n"
"              from all the files but the last one will be used for saving.\n"
"\n"
"              Added in 7.64.1.\n"
"\n"
"       --anyauth\n"
, stdout);
 fputs(
"              (HTTP) Tells curl to figure out authentication method by itself,\n"
"              and use the most secure one the remote site claims  to  support.\n"
"              This is done by first doing a request and checking the response-\n"
"              headers, thus possibly inducing  an  extra  network  round-trip.\n"
"              This  is  used  instead  of  setting  a  specific authentication\n"
"              method, which you can do with  --basic,  --digest,  --ntlm,  and\n"
, stdout);
 fputs(
"              --negotiate.\n"
"\n"
"              Using --anyauth is not recommended if you do uploads from stdin,\n"
"              since it may require data to be sent twice and then  the  client\n"
"              must  be able to rewind. If the need should arise when uploading\n"
"              from stdin, the upload operation will fail.\n"
"\n"
"              Used together with -u, --user.\n"
"\n"
"              See also --proxy-anyauth, --basic and --digest.\n"
"\n"
"       -a, --append\n"
, stdout);
 fputs(
"              (FTP SFTP) When used in an upload, this makes curl append to the\n"
"              target  file  instead  of  overwriting  it.  If  the remote file\n"
"              doesn't exist, it will be created.  Note that this flag  is  ig-\n"
"              nored by some SFTP servers (including OpenSSH).\n"
"\n"
"       --aws-sigv4 <provider1[:provider2]>\n"
"              Use AWS V4 signature authentication in the transfer.\n"
"\n"
"              The  provider argument is a string that is used by the algorithm\n"
, stdout);
 fputs(
"              when creating outgoing authentication headers.\n"
"\n"
"              Added in 7.75.0.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication with the  re-\n"
"              mote host. This is the default and this option is usually point-\n"
"              less, unless you use it to override a previously set option that\n"
"              sets  a  different  authentication method (such as --ntlm, --di-\n"
"              gest, or --negotiate).\n"
"\n"
, stdout);
 fputs(
"              Used together with -u, --user.\n"
"\n"
"              See also --proxy-basic.\n"
"\n"
"       --cacert <file>\n"
"              (TLS) Tells curl to use the specified certificate file to verify\n"
"              the  peer.  The  file  may contain multiple CA certificates. The\n"
"              certificate(s) must be in PEM format. Normally curl is built  to\n"
"              use a default file for this, so this option is typically used to\n"
"              alter that default file.\n"
"\n"
, stdout);
 fputs(
"              curl recognizes the environment variable named  'CURL_CA_BUNDLE'\n"
"              if  it  is  set,  and uses the given path as a path to a CA cert\n"
"              bundle. This option overrides that variable.\n"
"\n"
"              The windows version of curl will automatically  look  for  a  CA\n"
"              certs file named 'curl-ca-bundle.crt', either in the same direc-\n"
"              tory as curl.exe, or in the Current Working Directory, or in any\n"
"              folder along your PATH.\n"
"\n"
, stdout);
 fputs(
"              If  curl  is  built  against  the  NSS  SSL library, the NSS PEM\n"
"              PKCS#11 module (libnsspem.so) needs to be available for this op-\n"
"              tion to work properly.\n"
"\n"
"              (iOS  and macOS only) If curl is built against Secure Transport,\n"
"              then this option is supported for  backward  compatibility  with\n"
"              other  SSL  engines,  but it should not be set. If the option is\n"
, stdout);
 fputs(
"              not set, then curl will use the certificates in the  system  and\n"
"              user  Keychain to verify the peer, which is the preferred method\n"
"              of verifying the peer's certificate chain.\n"
"\n"
"              (Schannel only) This option is supported for Schannel in Windows\n"
"              7  or later with libcurl 7.60 or later. This option is supported\n"
"              for backward compatibility with other SSL engines; instead it is\n"
, stdout);
 fputs(
"              recommended  to use Windows' store of root certificates (the de-\n"
"              fault for Schannel).\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --capath <dir>\n"
"              (TLS) Tells curl to use the specified certificate  directory  to\n"
"              verify  the  peer.  Multiple paths can be provided by separating\n"
"              them with \":\" (e.g.  \"path1:path2:path3\"). The certificates must\n"
, stdout);
 fputs(
"              be  in PEM format, and if curl is built against OpenSSL, the di-\n"
"              rectory must have been processed using the c_rehash utility sup-\n"
"              plied  with  OpenSSL.  Using  --capath can allow OpenSSL-powered\n"
"              curl to make SSL-connections much more  efficiently  than  using\n"
"              --cacert if the --cacert file contains many CA certificates.\n"
"\n"
"              If this option is set, the default capath value will be ignored,\n"
, stdout);
 fputs(
"              and if it is used several times, the last one will be used.\n"
"\n"
"       --cert-status\n"
"              (TLS) Tells curl to verify the status of the server  certificate\n"
"              by using the Certificate Status Request (aka. OCSP stapling) TLS\n"
"              extension.\n"
"\n"
"              If this option is enabled and the server sends an invalid  (e.g.\n"
"              expired) response, if the response suggests that the server cer-\n"
, stdout);
 fputs(
"              tificate has been revoked, or no response at  all  is  received,\n"
"              the verification fails.\n"
"\n"
"              This  is  currently  only implemented in the OpenSSL, GnuTLS and\n"
"              NSS backends.\n"
"\n"
"              Added in 7.41.0.\n"
"\n"
"       --cert-type <type>\n"
"              (TLS) Tells curl what type the provided  client  certificate  is\n"
"              using. PEM, DER, ENG and P12 are recognized types.  If not spec-\n"
"              ified, PEM is assumed.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -E, --cert, --key and --key-type.\n"
"\n"
"       -E, --cert <certificate[:password]>\n"
"              (TLS) Tells curl to use the specified  client  certificate  file\n"
"              when getting a file with HTTPS, FTPS or another SSL-based proto-\n"
"              col. The certificate must be in PKCS#12 format if  using  Secure\n"
"              Transport,  or PEM format if using any other engine.  If the op-\n"
, stdout);
 fputs(
"              tional password isn't specified, it will be queried for  on  the\n"
"              terminal.  Note  that  this  option assumes a \"certificate\" file\n"
"              that is the private key and the client certificate concatenated!\n"
"              See -E, --cert and --key to specify them independently.\n"
"\n"
"              If  curl  is  built against the NSS SSL library then this option\n"
"              can tell curl the nickname of the certificate to use within  the\n"
, stdout);
 fputs(
"              NSS  database defined by the environment variable SSL_DIR (or by\n"
"              default /etc/pki/nssdb). If the NSS  PEM  PKCS#11  module  (lib-\n"
"              nsspem.so)  is  available  then  PEM files may be loaded. If you\n"
"              want to use a file from the current directory, please precede it\n"
"              with  \"./\"  prefix, in order to avoid confusion with a nickname.\n"
"              If the nickname contains \":\", it needs to be preceded by \"\\\"  so\n"
, stdout);
 fputs(
"              that  it  is not recognized as password delimiter.  If the nick-\n"
"              name contains \"\\\", it needs to be escaped as \"\\\\\" so that it  is\n"
"              not recognized as an escape character.\n"
"\n"
"              If  curl is built against OpenSSL library, and the engine pkcs11\n"
"              is available, then a PKCS#11 URI (RFC 7512) can be used to spec-\n"
"              ify  a  certificate located in a PKCS#11 device. A string begin-\n"
, stdout);
 fputs(
"              ning with \"pkcs11:\" will be interpreted as a PKCS#11 URI.  If  a\n"
"              PKCS#11 URI is provided, then the --engine option will be set as\n"
"              \"pkcs11\" if none was provided and the --cert-type option will be\n"
"              set as \"ENG\" if none was provided.\n"
"\n"
"              (iOS  and macOS only) If curl is built against Secure Transport,\n"
"              then the certificate string can either be the name of a certifi-\n"
, stdout);
 fputs(
"              cate/private  key in the system or user keychain, or the path to\n"
"              a PKCS#12-encoded certificate and private key. If  you  want  to\n"
"              use  a  file  from the current directory, please precede it with\n"
"              \"./\" prefix, in order to avoid confusion with a nickname.\n"
"\n"
"              (Schannel only) Client certificates must be specified by a  path\n"
"              expression  to  a  certificate  store.  (Loading PFX is not sup-\n"
, stdout);
 fputs(
"              ported; you can import it to a store first). You can use \"<store\n"
"              location>\\<store  name>\\<thumbprint>\"  to refer to a certificate\n"
"              in  the  system  certificates  store,  for   example,   \"Curren-\n"
"              tUser\\MY\\934a7ac6f8a5d579285a74fa61e19f23ddfe8d7a\".   Thumbprint\n"
"              is usually a SHA-1 hex string which you can see  in  certificate\n"
"              details.  Following  store locations are supported: CurrentUser,\n"
, stdout);
 fputs(
"              LocalMachine, CurrentService, Services,  CurrentUserGroupPolicy,\n"
"              LocalMachineGroupPolicy, LocalMachineEnterprise.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also --cert-type, --key and --key-type.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (TLS) Specifies which ciphers to use in the connection. The list\n"
"              of ciphers must specify valid ciphers. Read  up  on  SSL  cipher\n"
, stdout);
 fputs(
"              list details on this URL:\n"
"\n"
"               https://curl.se/docs/ssl-ciphers.html\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --compressed-ssh\n"
"              (SCP SFTP) Enables built-in SSH compression.  This is a request,\n"
"              not an order; the server may or may not do it.\n"
"\n"
"              Added in 7.56.0.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using one of the algorithms\n"
, stdout);
 fputs(
"              curl supports, and automatically decompress the content. Headers\n"
"              are not modified.\n"
"\n"
"              If this option is used and the server sends an  unsupported  en-\n"
"              coding, curl will report an error.\n"
"\n"
"       -K, --config <file>\n"
"\n"
"              Specify  a  text  file  to read curl arguments from. The command\n"
"              line arguments found in the text file will be used  as  if  they\n"
"              were provided on the command line.\n"
"\n"
, stdout);
 fputs(
"              Options  and their parameters must be specified on the same line\n"
"              in the file, separated by whitespace, colon, or the equals sign.\n"
"              Long  option  names  can  optionally be given in the config file\n"
"              without the initial double dashes and if so, the colon or equals\n"
"              characters can be used as separators. If the option is specified\n"
"              with one or two dashes, there can be no colon or equals  charac-\n"
, stdout);
 fputs(
"              ter between the option and its parameter.\n"
"\n"
"              If  the  parameter  contains whitespace (or starts with : or =),\n"
"              the parameter must be  enclosed  within  quotes.  Within  double\n"
"              quotes,  the  following  escape sequences are available: \\\\, \\\",\n"
"              \\t, \\n, \\r and \\v. A backslash preceding any other letter is ig-\n"
"              nored.  If the first column of a config line is a '#' character,\n"
, stdout);
 fputs(
"              the rest of the line will be treated as a  comment.  Only  write\n"
"              one option per physical line in the config file.\n"
"\n"
"              Specify  the  filename  to -K, --config as '-' to make curl read\n"
"              the file from stdin.\n"
"\n"
"              Note that to be able to specify a URL in the  config  file,  you\n"
"              need  to  specify  it  using the --url option, and not by simply\n"
"              writing the URL on its own line. So, it could  look  similar  to\n"
, stdout);
 fputs(
"              this:\n"
"\n"
"              url = \"https://curl.se/docs/\"\n"
"\n"
"              When  curl  is invoked, it (unless -q, --disable is used) checks\n"
"              for a default config file and uses it if found. The default con-\n"
"              fig file is checked for in the following places in this order:\n"
"\n"
"              1) Use the CURL_HOME environment variable if set\n"
"\n"
"              2) Use the XDG_CONFIG_HOME environment variable if set (Added in\n"
"              7.73.0)\n"
"\n"
, stdout);
 fputs(
"              3) Use the HOME environment variable if set\n"
"\n"
"              4) Non-windows: use getpwuid to find the home directory\n"
"\n"
"              5) Windows: use APPDATA if set\n"
"\n"
"              6) Windows: use \"USERPROFILE0lication Data\" if set\n"
"\n"
"              7) On windows, if there is no .curlrc file in the home  dir,  it\n"
"              checks for one in the same dir the curl executable is placed. On\n"
"              Unix-like systems, it will simply try to load .curlrc  from  the\n"
, stdout);
 fputs(
"              determined home dir.\n"
"\n"
"              # --- Example file ---\n"
"              # this is a comment\n"
"              url = \"example.com\"\n"
"              output = \"curlhere.html\"\n"
"              user-agent = \"superagent/1.0\"\n"
"\n"
"              # and fetch another URL too\n"
"              url = \"example.com/docs/manpage.html\"\n"
"              -O\n"
"              referer = \"http://nowhereatall.example.com/\"\n"
"              # --- End of example file ---\n"
"\n"
, stdout);
 fputs(
"              This  option  can be used multiple times to load multiple config\n"
"              files.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum time in seconds that  you  allow  curl's  connection  to\n"
"              take.   This  only  limits the connection phase, so if curl con-\n"
"              nects within the given period it will continue - if not it  will\n"
"              exit.  Since version 7.32.0, this option accepts decimal values.\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -m, --max-time.\n"
"\n"
"       --connect-to <HOST1:PORT1:HOST2:PORT2>\n"
"\n"
"              For  a  request  to  the  given  HOST1:PORT1  pair,  connect  to\n"
"              HOST2:PORT2 instead.  This option is suitable to direct requests\n"
"              at a specific server, e.g. at a specific cluster node in a clus-\n"
"              ter of servers. This option is only used to establish  the  net-\n"
, stdout);
 fputs(
"              work  connection.  It  does NOT affect the hostname/port that is\n"
"              used for TLS/SSL (e.g. SNI, certificate verification) or for the\n"
"              application  protocols.  \"HOST1\"  and  \"PORT1\"  may be the empty\n"
"              string, meaning \"any host/port\". \"HOST2\" and \"PORT2\" may also be\n"
"              the   empty   string,   meaning   \"use  the  request's  original\n"
"              host/port\".\n"
"\n"
, stdout);
 fputs(
"              A \"host\" specified to this option is compared as a string, so it\n"
"              needs  to  match  the name used in request URL. It can be either\n"
"              numerical such as \"127.0.0.1\" or the full host name such as \"ex-\n"
"              ample.org\".\n"
"\n"
"              This option can be used many times to add many connect rules.\n"
"\n"
"              See also --resolve and -H, --header. Added in 7.49.0.\n"
"\n"
"       -C, --continue-at <offset>\n"
, stdout);
 fputs(
"              Continue/Resume  a  previous  file transfer at the given offset.\n"
"              The given offset is the exact  number  of  bytes  that  will  be\n"
"              skipped,  counting  from the beginning of the source file before\n"
"              it is transferred to the destination.  If used with uploads, the\n"
"              FTP server command SIZE will not be used by curl.\n"
"\n"
"              Use  \"-C  -\" to tell curl to automatically find out where/how to\n"
, stdout);
 fputs(
"              resume the transfer. It then uses the given  output/input  files\n"
"              to figure that out.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -r, --range.\n"
"\n"
"       -c, --cookie-jar <filename>\n"
"              (HTTP)  Specify to which file you want curl to write all cookies\n"
"              after a completed operation. Curl writes all  cookies  from  its\n"
, stdout);
 fputs(
"              in-memory  cookie storage to the given file at the end of opera-\n"
"              tions. If no cookies are known, no data  will  be  written.  The\n"
"              file  will  be written using the Netscape cookie file format. If\n"
"              you set the file name to a single dash, \"-\", the cookies will be\n"
"              written to stdout.\n"
"\n"
"              This  command  line  option will activate the cookie engine that\n"
, stdout);
 fputs(
"              makes curl record and use cookies. Another way to activate it is\n"
"              to use the -b, --cookie option.\n"
"\n"
"              If the cookie jar can't be created or written to, the whole curl\n"
"              operation won't fail or even report an error clearly. Using  -v,\n"
"              --verbose  will  get  a  warning displayed, but that is the only\n"
"              visible feedback you get about this possibly lethal situation.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the  last  specified  file\n"
"              name will be used.\n"
"\n"
"       -b, --cookie <data|filename>\n"
"              (HTTP) Pass the data to the HTTP server in the Cookie header. It\n"
"              is supposedly the data previously received from the server in  a\n"
"              \"Set-Cookie:\"   line.    The   data  should  be  in  the  format\n"
"              \"NAME1=VALUE1; NAME2=VALUE2\".\n"
"\n"
, stdout);
 fputs(
"              If no '=' symbol is used in the argument, it is instead  treated\n"
"              as a filename to read previously stored cookie from. This option\n"
"              also activates the cookie engine which will make curl record in-\n"
"              coming  cookies, which may be handy if you're using this in com-\n"
"              bination with the -L,  --location  option  or  do  multiple  URL\n"
"              transfers  on the same invoke. If the file name is exactly a mi-\n"
, stdout);
 fputs(
"              nus (\"-\"), curl will instead read the contents from stdin.\n"
"\n"
"              The file format of the file to read cookies from should be plain\n"
"              HTTP  headers  (Set-Cookie style) or the Netscape/Mozilla cookie\n"
"              file format.\n"
"\n"
"              The file specified with -b, --cookie is only used as  input.  No\n"
"              cookies  will  be written to the file. To store cookies, use the\n"
"              -c, --cookie-jar option.\n"
"\n"
, stdout);
 fputs(
"              Exercise caution if you  are  using  this  option  and  multiple\n"
"              transfers may occur.  If you use the NAME1=VALUE1; format, or in\n"
"              a file use the Set-Cookie format and  don't  specify  a  domain,\n"
"              then the cookie is sent for any domain (even after redirects are\n"
"              followed) and cannot be modified by a server-set cookie. If  the\n"
"              cookie  engine is enabled and a server sets a cookie of the same\n"
, stdout);
 fputs(
"              name then both will be sent on a future transfer to that server,\n"
"              likely not what you intended.  To address these issues set a do-\n"
"              main in Set-Cookie (doing that will include sub domains) or  use\n"
"              the Netscape format.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              Users very often want to both read cookies from a file and write\n"
, stdout);
 fputs(
"              updated cookies back to a file, so using both -b,  --cookie  and\n"
"              -c, --cookie-jar in the same command line is common.\n"
"\n"
"       --create-dirs\n"
"              When used in conjunction with the -o, --output option, curl will\n"
"              create the necessary local directory hierarchy as  needed.  This\n"
"              option  creates the dirs mentioned with the -o, --output option,\n"
"              nothing else. If the --output file name uses no dir  or  if  the\n"
, stdout);
 fputs(
"              dirs it mentions already exist, no dir will be created.\n"
"\n"
"              Created dirs are made with mode 0750 on unix style file systems.\n"
"              To  create remote directories when using FTP or SFTP, try --ftp-\n"
"              create-dirs.\n"
"\n"
"       --create-file-mode\n"
"              (SFTP SCP FILE) When curl is used to create files remotely using\n"
"              one  of  the supported protocols, this option allows the user to\n"
, stdout);
 fputs(
"              set which 'mode' to set on the file at creation time, instead of\n"
"              the default 0644.\n"
"\n"
"              This options takes an octal number as argument.\n"
"\n"
"              See also --ftp-create-dirs. Added in 7.75.0.\n"
"\n"
"       --crlf (FTP  SMTP)  Convert  LF  to  CRLF  in  upload.  Useful  for MVS\n"
"              (OS/390).\n"
"\n"
"              (SMTP added in 7.40.0)\n"
"\n"
"       --crlfile <file>\n"
"              (TLS) Provide a file using PEM format with a Certificate Revoca-\n"
, stdout);
 fputs(
"              tion List that may specify peer certificates that are to be con-\n"
"              sidered revoked.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.19.7.\n"
"\n"
"       --curves <algorithm list>\n"
"              (TLS) Tells curl to request specific curves to  use  during  SSL\n"
"              session  establishment according to RFC 8422, 5.1.  Multiple al-\n"
"              gorithms can be provided  by  separating  them  with  \":\"  (e.g.\n"
, stdout);
 fputs(
"              \"X25519:P-521\").   The parameter is available identically in the\n"
"              \"openssl s_client/s_server\" utilities.\n"
"\n"
"              --curves allows a OpenSSL powered curl to  make  SSL-connections\n"
"              with  exactly  the  (EC) curve requested by the client, avoiding\n"
"              intransparent client/server negotiations.\n"
"\n"
"              If this option is  set,  the  default  curves  list  built  into\n"
"              openssl will be ignored.\n"
"\n"
"              Added in 7.73.0.\n"
, stdout);
 fputs(
"\n"
"       --data-ascii <data>\n"
"              (HTTP) This is just an alias for -d, --data.\n"
"\n"
"       --data-binary <data>\n"
"              (HTTP)  This  posts data exactly as specified with no extra pro-\n"
"              cessing whatsoever.\n"
"\n"
"              If you start the data with the letter @, the rest  should  be  a\n"
"              filename.   Data  is  posted  in  a similar manner as -d, --data\n"
"              does, except that newlines and carriage  returns  are  preserved\n"
, stdout);
 fputs(
"              and conversions are never done.\n"
"\n"
"              Like  -d,  --data the default content-type sent to the server is\n"
"              application/x-www-form-urlencoded. If you want the  data  to  be\n"
"              treated as arbitrary binary data by the server then set the con-\n"
"              tent-type to octet-stream: -H \"Content-Type:  application/octet-\n"
"              stream\".\n"
"\n"
"              If  this  option  is  used several times, the ones following the\n"
, stdout);
 fputs(
"              first will append data as described in -d, --data.\n"
"\n"
"       --data-raw <data>\n"
"              (HTTP) This posts data similarly to -d, --data but  without  the\n"
"              special interpretation of the @ character.\n"
"\n"
"              See also -d, --data. Added in 7.43.0.\n"
"\n"
"       --data-urlencode <data>\n"
"              (HTTP)  This posts data, similar to the other -d, --data options\n"
"              with the exception that this performs URL-encoding.\n"
"\n"
, stdout);
 fputs(
"              To be CGI-compliant, the <data> part should begin  with  a  name\n"
"              followed  by a separator and a content specification. The <data>\n"
"              part can be passed to curl using one of the following syntaxes:\n"
"\n"
"              content\n"
"                     This will make curl URL-encode the content and pass  that\n"
"                     on.  Just  be careful so that the content doesn't contain\n"
"                     any = or @ symbols, as that will  then  make  the  syntax\n"
, stdout);
 fputs(
"                     match one of the other cases below!\n"
"\n"
"              =content\n"
"                     This  will make curl URL-encode the content and pass that\n"
"                     on. The preceding = symbol is not included in the data.\n"
"\n"
"              name=content\n"
"                     This will make curl URL-encode the content part and  pass\n"
"                     that  on.  Note that the name part is expected to be URL-\n"
"                     encoded already.\n"
"\n"
"              @filename\n"
, stdout);
 fputs(
"                     This will make curl load data from the  given  file  (in-\n"
"                     cluding  any  newlines), URL-encode that data and pass it\n"
"                     on in the POST.\n"
"\n"
"              name@filename\n"
"                     This will make curl load data from the  given  file  (in-\n"
"                     cluding  any  newlines), URL-encode that data and pass it\n"
"                     on in the POST. The name part  gets  an  equal  sign  ap-\n"
, stdout);
 fputs(
"                     pended,  resulting  in name=urlencoded-file-content. Note\n"
"                     that the name is expected to be URL-encoded already.\n"
"       See also -d, --data and --data-raw. Added in 7.18.0.\n"
"\n"
"       -d, --data <data>\n"
"              (HTTP MQTT) Sends the specified data in a POST  request  to  the\n"
"              HTTP server, in the same way that a browser does when a user has\n"
"              filled in an HTML form and presses the submit button. This  will\n"
, stdout);
 fputs(
"              cause curl to pass the data to the server using the content-type\n"
"              application/x-www-form-urlencoded.  Compare to -F, --form.\n"
"\n"
"              --data-raw is almost the same but does not have a special inter-\n"
"              pretation  of  the  @ character. To post data purely binary, you\n"
"              should instead use the --data-binary option.  To URL-encode  the\n"
"              value of a form field you may use --data-urlencode.\n"
"\n"
, stdout);
 fputs(
"              If  any of these options is used more than once on the same com-\n"
"              mand line, the data pieces specified  will  be  merged  together\n"
"              with  a  separating  &-symbol.  Thus,  using  '-d name=daniel -d\n"
"              skill=lousy'  would  generate  a  post  chunk  that  looks  like\n"
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
, stdout);
 fputs(
"              file name to read the data from, or - if you want curl  to  read\n"
"              the  data  from  stdin.  Posting data from a file named 'foobar'\n"
"              would thus be done with -d, --data @foobar. When -d,  --data  is\n"
"              told  to  read  from a file like that, carriage returns and new-\n"
"              lines will be stripped out. If you don't want the @ character to\n"
"              have a special interpretation use --data-raw instead.\n"
"\n"
, stdout);
 fputs(
"              See  also  --data-binary,  --data-urlencode and --data-raw. This\n"
"              option overrides -F, --form and -I,  --head  and  -T,  --upload-\n"
"              file.\n"
"\n"
"       --delegation <LEVEL>\n"
"              (GSS/kerberos)  Set  LEVEL to tell the server what it is allowed\n"
"              to delegate when it comes to user credentials.\n"
"\n"
"              none   Don't allow any delegation.\n"
"\n"
"              policy Delegates if and only if the OK-AS-DELEGATE flag  is  set\n"
, stdout);
 fputs(
"                     in  the  Kerberos  service  ticket,  which is a matter of\n"
"                     realm policy.\n"
"\n"
"              always Unconditionally allow the server to delegate.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This is an  authenti-\n"
"              cation  scheme  that  prevents the password from being sent over\n"
"              the wire in clear text. Use this in combination with the  normal\n"
"              -u, --user option to set user name and password.\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is  used  several times, only the first one is\n"
"              used.\n"
"\n"
"              See also -u, --user, --proxy-digest and --anyauth.  This  option\n"
"              overrides --basic and --ntlm and --negotiate.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT and LPRT commands\n"
"              when doing active FTP transfers. Curl will normally always first\n"
"              attempt  to use EPRT, then LPRT before using PORT, but with this\n"
, stdout);
 fputs(
"              option, it will use PORT right away. EPRT and  LPRT  are  exten-\n"
"              sions  to  the  original  FTP  protocol, and may not work on all\n"
"              servers, but they enable more functionality in a better way than\n"
"              the traditional PORT command.\n"
"\n"
"              --eprt can be used to explicitly enable EPRT again and --no-eprt\n"
"              is an alias for --disable-eprt.\n"
"\n"
"              If the server is accessed using IPv6, this option will  have  no\n"
, stdout);
 fputs(
"              effect as EPRT is necessary then.\n"
"\n"
"              Disabling  EPRT only changes the active behavior. If you want to\n"
"              switch to passive mode you need to not  use  -P,  --ftp-port  or\n"
"              force it with --ftp-pasv.\n"
"\n"
"       --disable-epsv\n"
"              (FTP)  (FTP)  Tell  curl  to disable the use of the EPSV command\n"
"              when doing passive FTP  transfers.  Curl  will  normally  always\n"
, stdout);
 fputs(
"              first  attempt to use EPSV before PASV, but with this option, it\n"
"              will not try using EPSV.\n"
"\n"
"              --epsv can be used to explicitly enable EPSV again and --no-epsv\n"
"              is an alias for --disable-epsv.\n"
"\n"
"              If  the  server is an IPv6 host, this option will have no effect\n"
"              as EPSV is necessary then.\n"
"\n"
"              Disabling EPSV only changes the passive behavior. If you want to\n"
, stdout);
 fputs(
"              switch to active mode you need to use -P, --ftp-port.\n"
"\n"
"       -q, --disable\n"
"              If  used  as the first parameter on the command line, the curlrc\n"
"              config file will not be read and used. See the -K, --config  for\n"
"              details on the default config file search path.\n"
"\n"
"       --disallow-username-in-url\n"
"              (HTTP)  This  tells  curl  to  exit if passed a url containing a\n"
"              username.\n"
"\n"
"              See also --proto. Added in 7.61.0.\n"
"\n"
, stdout);
 fputs(
"       --dns-interface <interface>\n"
"              (DNS) Tell curl to send outgoing DNS  requests  through  <inter-\n"
"              face>.  This  option is a counterpart to --interface (which does\n"
"              not affect DNS). The supplied string must be an  interface  name\n"
"              (not an address).\n"
"\n"
"              See  also  --dns-ipv4-addr  and --dns-ipv6-addr. --dns-interface\n"
"              requires that the underlying libcurl was  built  to  support  c-\n"
"              ares. Added in 7.33.0.\n"
, stdout);
 fputs(
"\n"
"       --dns-ipv4-addr <address>\n"
"              (DNS) Tell curl to bind to <ip-address> when making IPv4 DNS re-\n"
"              quests, so that the DNS requests originate  from  this  address.\n"
"              The argument should be a single IPv4 address.\n"
"\n"
"              See  also  --dns-interface  and --dns-ipv6-addr. --dns-ipv4-addr\n"
"              requires that the underlying libcurl was  built  to  support  c-\n"
"              ares. Added in 7.33.0.\n"
"\n"
"       --dns-ipv6-addr <address>\n"
, stdout);
 fputs(
"              (DNS) Tell curl to bind to <ip-address> when making IPv6 DNS re-\n"
"              quests, so that the DNS requests originate  from  this  address.\n"
"              The argument should be a single IPv6 address.\n"
"\n"
"              See  also  --dns-interface  and --dns-ipv4-addr. --dns-ipv6-addr\n"
"              requires that the underlying libcurl was  built  to  support  c-\n"
"              ares. Added in 7.33.0.\n"
"\n"
"       --dns-servers <addresses>\n"
, stdout);
 fputs(
"              Set the list of DNS servers to be used instead of the system de-\n"
"              fault.  The list of IP addresses should be separated  with  com-\n"
"              mas. Port numbers may also optionally be given as :<port-number>\n"
"              after each IP address.\n"
"\n"
"              --dns-servers requires that the underlying libcurl was built  to\n"
"              support c-ares. Added in 7.33.0.\n"
"\n"
"       --doh-url <URL>\n"
, stdout);
 fputs(
"              (all)  Specifies which DNS-over-HTTPS (DOH) server to use to re-\n"
"              solve hostnames, instead of  using  the  default  name  resolver\n"
"              mechanism. The URL must be HTTPS.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.62.0.\n"
"\n"
"       -D, --dump-header <filename>\n"
"              (HTTP  FTP) Write the received protocol headers to the specified\n"
"              file.\n"
"\n"
, stdout);
 fputs(
"              This option is handy to use when you want to store  the  headers\n"
"              that  an  HTTP site sends to you. Cookies from the headers could\n"
"              then be read in a  second  curl  invocation  by  using  the  -b,\n"
"              --cookie  option! The -c, --cookie-jar option is a better way to\n"
"              store cookies.\n"
"\n"
"              If no headers are received, the use of this option  will  create\n"
"              an empty file.\n"
"\n"
, stdout);
 fputs(
"              When  used  in FTP, the FTP server response lines are considered\n"
"              being \"headers\" and thus are saved there.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -o, --output.\n"
"\n"
"       --egd-file <file>\n"
"              (TLS) Specify the path name  to  the  Entropy  Gathering  Daemon\n"
"              socket.  The  socket  is  used to seed the random engine for SSL\n"
"              connections.\n"
"\n"
, stdout);
 fputs(
"              See also --random-file.\n"
"\n"
"       --engine <name>\n"
"              (TLS) Select the OpenSSL crypto engine to use for cipher  opera-\n"
"              tions. Use --engine list to print a list of build-time supported\n"
"              engines. Note that not all (or  none)  of  the  engines  may  be\n"
"              available at run-time.\n"
"\n"
"       --etag-compare <file>\n"
"              (HTTP) This option makes a conditional HTTP request for the spe-\n"
, stdout);
 fputs(
"              cific ETag read from the given file by sending a custom If-None-\n"
"              Match header using the extracted ETag.\n"
"\n"
"              For correct results, make sure that specified file contains only\n"
"              a single line with a desired ETag. An empty file is parsed as an\n"
"              empty ETag.\n"
"\n"
"              Use  the  option  --etag-save  to first save the ETag from a re-\n"
"              sponse, and then use this option to compare using the saved ETag\n"
, stdout);
 fputs(
"              in a subsequent request.\n"
"\n"
"              COMPARISON:  There  are 2 types of comparison or ETags: Weak and\n"
"              Strong.  This option expects, and uses a strong comparison.\n"
"\n"
"              Added in 7.68.0.\n"
"\n"
"       --etag-save <file>\n"
"              (HTTP) This option saves an HTTP ETag  to  the  specified  file.\n"
"              Etag  is  usually  part  of  headers returned by a request. When\n"
"              server sends an ETag, it must be enveloped by  a  double  quote.\n"
, stdout);
 fputs(
"              This  option  extracts  the  ETag  without the double quotes and\n"
"              saves it into the <file>.\n"
"\n"
"              A server can send a weak ETag which is prefixed  by  \"W/\".  This\n"
"              identifier  is  not  considered,  and only relevant ETag between\n"
"              quotation marks is parsed.\n"
"\n"
"              It an ETag wasn't sent by the server or it cannot be parsed,  an\n"
"              empty file is created.\n"
"\n"
"              Added in 7.68.0.\n"
"\n"
, stdout);
 fputs(
"       --expect100-timeout <seconds>\n"
"              (HTTP) Maximum time in seconds that you allow curl to wait for a\n"
"              100-continue response when curl emits an  Expects:  100-continue\n"
"              header  in  its  request.  By default curl will wait one second.\n"
"              This option accepts decimal values! When curl stops waiting,  it\n"
"              will continue as if the response has been received.\n"
"\n"
"              See also --connect-timeout. Added in 7.47.0.\n"
"\n"
"       --fail-early\n"
, stdout);
 fputs(
"              Fail and exit on the first detected transfer error.\n"
"\n"
"              When  curl is used to do multiple transfers on the command line,\n"
"              it will attempt to operate on each given URL, one by one. By de-\n"
"              fault,  it  will  ignore errors if there are more URLs given and\n"
"              the last URL's success will determine the error  code  curl  re-\n"
"              turns. So early failures will be \"hidden\" by subsequent success-\n"
"              ful transfers.\n"
"\n"
, stdout);
 fputs(
"              Using this option, curl will instead  return  an  error  on  the\n"
"              first  transfer  that  fails,  independent of the amount of URLs\n"
"              that are given on the command line. This way, no transfer  fail-\n"
"              ures go undetected by scripts and similar.\n"
"\n"
"              This option is global and does not need to be specified for each\n"
"              use of -:, --next.\n"
"\n"
"              This option does not imply -f, --fail, which causes transfers to\n"
, stdout);
 fputs(
"              fail  due  to the server's HTTP status code. You can combine the\n"
"              two options, however note -f, --fail is not global and is there-\n"
"              fore contained by -:, --next.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       -f, --fail\n"
"              (HTTP)  Fail  silently (no output at all) on server errors. This\n"
"              is mostly done to enable scripts etc to better deal with  failed\n"
"              attempts. In normal cases when an HTTP server fails to deliver a\n"
, stdout);
 fputs(
"              document, it returns an HTML document stating  so  (which  often\n"
"              also  describes  why and more). This flag will prevent curl from\n"
"              outputting that and return error 22.\n"
"\n"
"              This method is not fail-safe and there are occasions where  non-\n"
"              successful response codes will slip through, especially when au-\n"
"              thentication is involved (response codes 401 and 407).\n"
"\n"
"       --false-start\n"
, stdout);
 fputs(
"              (TLS) Tells curl to use false start during  the  TLS  handshake.\n"
"              False  start is a mode where a TLS client will start sending ap-\n"
"              plication data before verifying the server's  Finished  message,\n"
"              thus saving a round trip when performing a full handshake.\n"
"\n"
"              This  is currently only implemented in the NSS and Secure Trans-\n"
"              port (on iOS 7.0 or later, or OS X 10.9 or later) backends.\n"
"\n"
"              Added in 7.42.0.\n"
"\n"
, stdout);
 fputs(
"       --form-string <name=string>\n"
"              (HTTP SMTP IMAP) Similar to -F, --form  except  that  the  value\n"
"              string  for  the  named parameter is used literally. Leading '@'\n"
"              and '<' characters, and the ';type=' string in the value have no\n"
"              special meaning. Use this in preference to -F, --form if there's\n"
"              any possibility that the string value may  accidentally  trigger\n"
"              the '@' or '<' features of -F, --form.\n"
"\n"
, stdout);
 fputs(
"              See also -F, --form.\n"
"\n"
"       -F, --form <name=content>\n"
"              (HTTP  SMTP  IMAP) For HTTP protocol family, this lets curl emu-\n"
"              late a filled-in form in which a user  has  pressed  the  submit\n"
"              button.  This  causes  curl  to POST data using the Content-Type\n"
"              multipart/form-data according to RFC 2388.\n"
"\n"
"              For SMTP and IMAP protocols, this is the mean to compose a  mul-\n"
"              tipart mail message to transmit.\n"
"\n"
, stdout);
 fputs(
"              This  enables  uploading of binary files etc. To force the 'con-\n"
"              tent' part to be a file, prefix the file name with an @ sign. To\n"
"              just get the content part from a file, prefix the file name with\n"
"              the symbol <. The difference between @ and  <  is  then  that  @\n"
"              makes  a  file  get attached in the post as a file upload, while\n"
"              the < makes a text field and just get the contents for that text\n"
, stdout);
 fputs(
"              field from a file.\n"
"\n"
"              Tell  curl to read content from stdin instead of a file by using\n"
"              - as filename. This goes for both @ and < constructs. When stdin\n"
"              is used, the contents is buffered in memory first by curl to de-\n"
"              termine its size and allow a possible resend.  Defining a part's\n"
"              data from a named non-regular file (such as a named pipe or sim-\n"
, stdout);
 fputs(
"              ilar) is unfortunately not subject to buffering and will be  ef-\n"
"              fectively  read at transmission time; since the full size is un-\n"
"              known before the transfer starts, such data is sent as chunks by\n"
"              HTTP and rejected by IMAP.\n"
"\n"
"              Example: send an image to an HTTP server, where 'profile' is the\n"
"              name of the form-field to which the file  portrait.jpg  will  be\n"
"              the input:\n"
"\n"
, stdout);
 fputs(
"               curl -F profile=@portrait.jpg https://example.com/upload.cgi\n"
"\n"
"              Example:  send your name and shoe size in two text fields to the\n"
"              server:\n"
"\n"
"               curl -F name=John -F shoesize=11 https://example.com/\n"
"\n"
"              Example: send your essay in a text field to the server. Send  it\n"
"              as  a plain text field, but get the contents for it from a local\n"
"              file:\n"
"\n"
"               curl -F \"story=<hugefile.txt\" https://example.com/\n"
"\n"
, stdout);
 fputs(
"              You can also  tell  curl  what  Content-Type  to  use  by  using\n"
"              'type=', in a manner similar to:\n"
"\n"
"               curl -F \"web=@index.html;type=text/html\" example.com\n"
"\n"
"              or\n"
"\n"
"               curl -F \"name=daniel;type=text/foo\" example.com\n"
"\n"
"              You  can  also explicitly change the name field of a file upload\n"
"              part by setting filename=, like this:\n"
"\n"
"               curl -F \"file=@localfile;filename=nameinpost\" example.com\n"
"\n"
, stdout);
 fputs(
"              If filename/path contains ',' or ';', it must be quoted by  dou-\n"
"              ble-quotes like:\n"
"\n"
"               curl   -F  \"file=@\\\"localfile\\\";filename=\\\"nameinpost\\\"\"  exam-\n"
"              ple.com\n"
"\n"
"              or\n"
"\n"
"               curl -F 'file=@\"localfile\";filename=\"nameinpost\"' example.com\n"
"\n"
"              Note that if a filename/path is  quoted  by  double-quotes,  any\n"
"              double-quote or backslash within the filename must be escaped by\n"
"              backslash.\n"
"\n"
, stdout);
 fputs(
"              Quoting must also be applied to non-file  data  if  it  contains\n"
"              semicolons, leading/trailing spaces or leading double quotes:\n"
"\n"
"               curl  -F  'colors=\"red;  green;  blue\";type=text/x-myapp' exam-\n"
"              ple.com\n"
"\n"
"              You can add custom headers to the  field  by  setting  headers=,\n"
"              like\n"
"\n"
"                curl -F \"submit=OK;headers=\\\"X-submit-type: OK\\\"\" example.com\n"
"\n"
"              or\n"
"\n"
, stdout);
 fputs(
"                curl -F \"submit=OK;headers=@headerfile\" example.com\n"
"\n"
"              The  headers=  keyword may appear more that once and above notes\n"
"              about quoting apply. When headers are read from  a  file,  Empty\n"
"              lines and lines starting with '#' are comments and ignored; each\n"
"              header can be folded by splitting between two words and starting\n"
"              the  continuation  line  with a space; embedded carriage-returns\n"
, stdout);
 fputs(
"              and trailing spaces are stripped.   Here  is  an  example  of  a\n"
"              header file contents:\n"
"\n"
"                # This file contain two headers.\n"
"                X-header-1: this is a header\n"
"\n"
"                # The following header is folded.\n"
"                X-header-2: this is\n"
"                 another header\n"
"\n"
"              To  support  sending  multipart mail messages, the syntax is ex-\n"
"              tended as follows:\n"
, stdout);
 fputs(
"              - name can be omitted: the equal sign is the first character  of\n"
"              the argument,\n"
"              -  if  data  starts with '(', this signals to start a new multi-\n"
"              part: it can be followed by a content type specification.\n"
"              - a multipart can be terminated with a '=)' argument.\n"
"\n"
"              Example: the following command sends an SMTP  mime  e-mail  con-\n"
"              sisting in an inline part in two alternative formats: plain text\n"
, stdout);
 fputs(
"              and HTML. It attaches a text file:\n"
"\n"
"               curl -F '=(;type=multipart/alternative' \\\n"
"                       -F '=plain text message' \\\n"
"                       -F '= <body>HTML message</body>;type=text/html' \\\n"
"                    -F '=)' -F '=@textfile.txt' ...  smtp://example.com\n"
"\n"
"              Data can be encoded for transfer using encoder=.  Available  en-\n"
"              codings are binary and 8bit that do nothing else than adding the\n"
, stdout);
 fputs(
"              corresponding Content-Transfer-Encoding header, 7bit  that  only\n"
"              rejects 8-bit characters with a transfer error, quoted-printable\n"
"              and base64 that encodes  data  according  to  the  corresponding\n"
"              schemes, limiting lines length to 76 characters.\n"
"\n"
"              Example:  send  multipart mail with a quoted-printable text mes-\n"
"              sage and a base64 attached file:\n"
"\n"
"               curl -F '=text message;encoder=quoted-printable' \\\n"
, stdout);
 fputs(
"                    -F '=@localfile;encoder=base64' ... smtp://example.com\n"
"\n"
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"              This option overrides -d, --data and -I, --head  and  -T,  --up-\n"
"              load-file.\n"
"\n"
"       --ftp-account <data>\n"
"              (FTP) When an FTP server asks for \"account data\" after user name\n"
"              and password has been provided, this data is sent off using  the\n"
, stdout);
 fputs(
"              ACCT command.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.13.0.\n"
"\n"
"       --ftp-alternative-to-user <command>\n"
"              (FTP)  If  authenticating with the USER and PASS commands fails,\n"
"              send this  command.   When  connecting  to  Tumbleweed's  Secure\n"
"              Transport  server  over  FTPS  using a client certificate, using\n"
"              \"SITE AUTH\" will tell the server to retrieve the  username  from\n"
, stdout);
 fputs(
"              the certificate.\n"
"              Added in 7.15.5.\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP  SFTP)  When  an FTP or SFTP URL/operation uses a path that\n"
"              doesn't currently exist on the server, the standard behavior  of\n"
"              curl is to fail. Using this option, curl will instead attempt to\n"
"              create missing directories.\n"
"\n"
"              See also --create-dirs.\n"
"\n"
"       --ftp-method <method>\n"
, stdout);
 fputs(
"              (FTP) Control what method curl should use to reach a file on  an\n"
"              FTP(S)  server. The method argument should be one of the follow-\n"
"              ing alternatives:\n"
"\n"
"              multicwd\n"
"                     curl does a single CWD operation for each  path  part  in\n"
"                     the  given URL. For deep hierarchies this means very many\n"
"                     commands. This is how RFC 1738 says it  should  be  done.\n"
, stdout);
 fputs(
"                     This is the default but the slowest behavior.\n"
"\n"
"              nocwd  curl  does  no  CWD at all. curl will do SIZE, RETR, STOR\n"
"                     etc and give a full path to the server for all these com-\n"
"                     mands. This is the fastest behavior.\n"
"\n"
"              singlecwd\n"
"                     curl does one CWD with the full target directory and then\n"
"                     operates on the file \"normally\"  (like  in  the  multicwd\n"
, stdout);
 fputs(
"                     case).  This  is  somewhat  more standards compliant than\n"
"                     'nocwd' but without the full penalty of 'multicwd'.\n"
"\n"
"       Added in 7.15.1.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP) Use passive mode for the data connection. Passive  is  the\n"
"              internal  default behavior, but using this option can be used to\n"
"              override a previous -P, --ftp-port option.\n"
"\n"
"              If this option is used several times,  only  the  first  one  is\n"
, stdout);
 fputs(
"              used.  Undoing  an  enforced passive really isn't doable but you\n"
"              must then instead enforce the correct -P, --ftp-port again.\n"
"\n"
"              Passive mode means that curl will try the EPSV command first and\n"
"              then PASV, unless --disable-epsv is used.\n"
"              See also --disable-epsv. Added in 7.11.0.\n"
"\n"
"       -P, --ftp-port <address>\n"
"              (FTP)  Reverses  the  default initiator/listener roles when con-\n"
, stdout);
 fputs(
"              necting with FTP. This option makes curl use active  mode.  curl\n"
"              then  tells the server to connect back to the client's specified\n"
"              address and port, while passive mode asks the server to setup an\n"
"              IP  address  and  port for it to connect to. <address> should be\n"
"              one of:\n"
"\n"
"              interface\n"
"                     e.g. \"eth0\" to specify which interface's IP  address  you\n"
"                     want to use (Unix only)\n"
"\n"
, stdout);
 fputs(
"              IP address\n"
"                     e.g. \"192.168.10.1\" to specify the exact IP address\n"
"\n"
"              host name\n"
"                     e.g. \"my.host.domain\" to specify the machine\n"
"\n"
"              -      make  curl  pick the same IP address that is already used\n"
"                     for the control connection\n"
"\n"
"       If this option is used several times, the last one will be  used.  Dis-\n"
"       able  the  use  of PORT with --ftp-pasv. Disable the attempt to use the\n"
, stdout);
 fputs(
"       EPRT command instead of PORT by using --disable-eprt.  EPRT  is  really\n"
"       PORT++.\n"
"\n"
"       Since  7.19.5,  you can append \":[start]-[end]\" to the right of the ad-\n"
"       dress, to tell curl what TCP port range to use. That means you  specify\n"
"       a port range, from a lower to a higher number. A single number works as\n"
"       well, but do note that it increases the risk of failure since the  port\n"
"       may not be available.\n"
"\n"
"       See also --ftp-pasv and --disable-eprt.\n"
"\n"
, stdout);
 fputs(
"       --ftp-pret\n"
"              (FTP)  Tell  curl to send a PRET command before PASV (and EPSV).\n"
"              Certain FTP servers, mainly drftpd,  require  this  non-standard\n"
"              command  for  directory  listings as well as up and downloads in\n"
"              PASV mode.\n"
"\n"
"              Added in 7.20.0.\n"
"\n"
"       --ftp-skip-pasv-ip\n"
"              (FTP) Tell curl to not use the IP address the server suggests in\n"
"              its  response to curl's PASV command when curl connects the data\n"
, stdout);
 fputs(
"              connection. Instead curl will re-use the same IP address it  al-\n"
"              ready uses for the control connection.\n"
"\n"
"              Since curl 7.74.0 this option is enabled by default.\n"
"\n"
"              This  option has no effect if PORT, EPRT or EPSV is used instead\n"
"              of PASV.\n"
"\n"
"              See also --ftp-pasv. Added in 7.14.2.\n"
"\n"
"       --ftp-ssl-ccc-mode <active/passive>\n"
"              (FTP) Sets the CCC mode. The passive mode will not initiate  the\n"
, stdout);
 fputs(
"              shutdown, but instead wait for the server to do it, and will not\n"
"              reply to the shutdown from the server. The active mode initiates\n"
"              the shutdown and waits for a reply from the server.\n"
"\n"
"              See also --ftp-ssl-ccc. Added in 7.16.2.\n"
"\n"
"       --ftp-ssl-ccc\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Shuts down the SSL/TLS\n"
"              layer after authenticating. The rest of the control channel com-\n"
, stdout);
 fputs(
"              munication  will be unencrypted. This allows NAT routers to fol-\n"
"              low the FTP transaction. The default mode is passive.\n"
"\n"
"              See also --ssl and --ftp-ssl-ccc-mode. Added in 7.16.1.\n"
"\n"
"       --ftp-ssl-control\n"
"              (FTP) Require SSL/TLS for the FTP  login,  clear  for  transfer.\n"
"              Allows  secure  authentication, but non-encrypted data transfers\n"
"              for efficiency.  Fails the transfer if the server  doesn't  sup-\n"
, stdout);
 fputs(
"              port SSL/TLS.\n"
"\n"
"              Added in 7.16.0.\n"
"\n"
"       -G, --get\n"
"              When  used,  this  option  will make all data specified with -d,\n"
"              --data, --data-binary or --data-urlencode to be used in an  HTTP\n"
"              GET  request instead of the POST request that otherwise would be\n"
"              used. The data will be appended to the URL with a '?' separator.\n"
"              If used in combination with -I, --head, the POST data  will  in-\n"
, stdout);
 fputs(
"              stead be appended to the URL with a HEAD request.\n"
"\n"
"              If  this  option  is  used  several times, only the first one is\n"
"              used. This is because undoing a GET doesn't make sense, but  you\n"
"              should then instead enforce the alternative method you prefer.\n"
"\n"
"       -g, --globoff\n"
"              This option switches off the \"URL globbing parser\". When you set\n"
"              this option, you can specify URLs that contain the letters  {}[]\n"
, stdout);
 fputs(
"              without  having them being interpreted by curl itself. Note that\n"
"              these letters are not normal legal URL contents but they  should\n"
"              be encoded according to the URI standard.\n"
"\n"
"       --happy-eyeballs-timeout-ms <milliseconds>\n"
"              Happy  eyeballs is an algorithm that attempts to connect to both\n"
"              IPv4 and IPv6 addresses for dual-stack  hosts,  preferring  IPv6\n"
, stdout);
 fputs(
"              first for the number of milliseconds. If the IPv6 address cannot\n"
"              be connected to within that time then a  connection  attempt  is\n"
"              made to the IPv4 address in parallel. The first connection to be\n"
"              established is the one that is used.\n"
"\n"
"              The range of suggested useful values is limited. Happy  Eyeballs\n"
"              RFC  6555  says  \"It  is RECOMMENDED that connection attempts be\n"
, stdout);
 fputs(
"              paced 150-250 ms apart to balance human factors against  network\n"
"              load.\"  libcurl currently defaults to 200 ms. Firefox and Chrome\n"
"              currently default to 300 ms.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.59.0.\n"
"\n"
"       --haproxy-protocol\n"
"              (HTTP) Send a HAProxy PROXY protocol v1 header at the  beginning\n"
"              of  the  connection. This is used by some load balancers and re-\n"
, stdout);
 fputs(
"              verse proxies to indicate the client's true IP address and port.\n"
"              This option is primarily useful when sending test requests to  a\n"
"              service that expects this header.\n"
"\n"
"              Added in 7.60.0.\n"
"\n"
"       -I, --head\n"
"              (HTTP FTP FILE) Fetch the headers only! HTTP-servers feature the\n"
"              command HEAD which this uses to get nothing but the header of  a\n"
"              document.  When  used  on an FTP or FILE file, curl displays the\n"
, stdout);
 fputs(
"              file size and last modification time only.\n"
"\n"
"       -H, --header <header/@file>\n"
"              (HTTP) Extra header to include in the request when sending  HTTP\n"
"              to  a  server. You may specify any number of extra headers. Note\n"
"              that if you should add a custom header that has the same name as\n"
"              one  of  the  internal  ones curl would use, your externally set\n"
"              header will be used instead of the internal one. This allows you\n"
, stdout);
 fputs(
"              to  make  even  trickier  stuff than curl would normally do. You\n"
"              should not replace internally set headers without  knowing  per-\n"
"              fectly well what you're doing. Remove an internal header by giv-\n"
"              ing a replacement without content  on  the  right  side  of  the\n"
"              colon, as in: -H \"Host:\". If you send the custom header with no-\n"
"              value then its header must be terminated with a semicolon,  such\n"
, stdout);
 fputs(
"              as -H \"X-Custom-Header;\" to send \"X-Custom-Header:\".\n"
"\n"
"              curl  will  make  sure  that each header you add/replace is sent\n"
"              with the proper end-of-line marker, you should thus not add that\n"
"              as a part of the header content: do not add newlines or carriage\n"
"              returns, they will only mess things up for you.\n"
"\n"
"              This option can take an argument in @filename style, which  then\n"
, stdout);
 fputs(
"              adds  a  header  for  each line in the input file. Using @- will\n"
"              make curl read the header file from stdin. Added in 7.55.0.\n"
"\n"
"              You need --proxy-header to send custom headers  intended  for  a\n"
"              HTTP proxy. Added in 7.37.0.\n"
"\n"
"              Passing  on  a  \"Transfer-Encoding: chunked\" header when doing a\n"
"              HTTP request with a request body, will make curl send  the  data\n"
"              using chunked encoding.\n"
"\n"
"              Example:\n"
"\n"
, stdout);
 fputs(
"               curl -H \"X-First-Name: Joe\" http://example.com/\n"
"\n"
"              WARNING:  headers  set  with  this option will be set in all re-\n"
"              quests - even after redirects are followed, like when told  with\n"
"              -L,  --location. This can lead to the header being sent to other\n"
"              hosts than the original host, so  sensitive  headers  should  be\n"
"              used with caution combined with following redirects.\n"
"\n"
, stdout);
 fputs(
"              This  option  can  be  used multiple times to add/replace/remove\n"
"              multiple headers.\n"
"\n"
"              See also -A, --user-agent and -e, --referer.\n"
"\n"
"       -h, --help <category>\n"
"              Usage help. This lists all commands of the  <category>.   If  no\n"
"              arg  was  provided, curl will display the most important command\n"
"              line arguments.  If the argument \"all\" was provided,  curl  will\n"
, stdout);
 fputs(
"              display  all  options available.  If the argument \"category\" was\n"
"              provided, curl will display all categories and their meanings.\n"
"\n"
"       --hostpubmd5 <md5>\n"
"              (SFTP SCP) Pass a string containing 32 hexadecimal  digits.  The\n"
"              string  should  be the 128 bit MD5 checksum of the remote host's\n"
"              public key, curl will refuse the connection with the host unless\n"
"              the md5sums match.\n"
"\n"
"              Added in 7.17.1.\n"
"\n"
, stdout);
 fputs(
"       --hsts <file name>\n"
"              (HTTPS) WARNING: this option is experimental. Do not use in pro-\n"
"              duction.\n"
"\n"
"              This option enables HSTS for the  transfer.  If  the  file  name\n"
"              points  to an existing HSTS cache file, that will be used. After\n"
"              a completed transfer, the cache will be saved to the  file  name\n"
"              again if it has been modified.\n"
"\n"
"              Specify a \"\" file name (zero length) to avoid loading/saving and\n"
, stdout);
 fputs(
"              make curl just handle HSTS in memory.\n"
"\n"
"              If this option is used several times, curl  will  load  contents\n"
"              from all the files but the last one will be used for saving.\n"
"\n"
"              Added in 7.74.0.\n"
"\n"
"       --http0.9\n"
"              (HTTP) Tells curl to be fine with HTTP version 0.9 response.\n"
"\n"
"              HTTP/0.9  is  a completely headerless response and therefore you\n"
"              can also connect with this to non-HTTP servers and still  get  a\n"
, stdout);
 fputs(
"              response since curl will simply transparently downgrade - if al-\n"
"              lowed.\n"
"\n"
"              Since curl 7.66.0, HTTP/0.9 is disabled by default.\n"
"\n"
"       -0, --http1.0\n"
"              (HTTP) Tells curl to use HTTP version 1.0 instead of  using  its\n"
"              internally preferred HTTP version.\n"
"\n"
"              This option overrides --http1.1 and --http2.\n"
"\n"
"       --http1.1\n"
"              (HTTP) Tells curl to use HTTP version 1.1.\n"
"\n"
, stdout);
 fputs(
"              This  option  overrides  -0,  --http1.0  and  --http2.  Added in\n"
"              7.33.0.\n"
"\n"
"       --http2-prior-knowledge\n"
"              (HTTP) Tells curl to  issue  its  non-TLS  HTTP  requests  using\n"
"              HTTP/2  without  HTTP/1.1  Upgrade.  It requires prior knowledge\n"
"              that the server supports HTTP/2 straight  away.  HTTPS  requests\n"
"              will  still  do HTTP/2 the standard way with negotiated protocol\n"
"              version in the TLS handshake.\n"
"\n"
, stdout);
 fputs(
"              --http2-prior-knowledge requires that the underlying libcurl was\n"
"              built to support HTTP/2. This option overrides --http1.1 and -0,\n"
"              --http1.0 and --http2. Added in 7.49.0.\n"
"\n"
"       --http2\n"
"              (HTTP) Tells curl to use HTTP version 2.\n"
"\n"
"              See also --http1.1 and --http3. --http2 requires that the under-\n"
"              lying libcurl was built to support HTTP/2. This option overrides\n"
, stdout);
 fputs(
"              --http1.1 and -0, --http1.0 and  --http2-prior-knowledge.  Added\n"
"              in 7.33.0.\n"
"\n"
"       --http3\n"
"              (HTTP)  WARNING: this option is experimental. Do not use in pro-\n"
"              duction.\n"
"\n"
"              Tells curl to use HTTP version 3 directly to the host  and  port\n"
"              number used in the URL. A normal HTTP/3 transaction will be done\n"
"              to a host and then get redirected via Alt-SVc, but  this  option\n"
, stdout);
 fputs(
"              allows  a  user to circumvent that when you know that the target\n"
"              speaks HTTP/3 on the given host and port.\n"
"\n"
"              This option will make curl fail if a QUIC connection  cannot  be\n"
"              established,  it cannot fall back to a lower HTTP version on its\n"
"              own.\n"
"\n"
"              See also --http1.1 and --http2. --http3 requires that the under-\n"
"              lying libcurl was built to support HTTP/3. This option overrides\n"
, stdout);
 fputs(
"              --http1.1 and -0, --http1.0 and --http2 and --http2-prior-knowl-\n"
"              edge. Added in 7.66.0.\n"
"\n"
"       --ignore-content-length\n"
"              (FTP  HTTP)  For HTTP, Ignore the Content-Length header. This is\n"
"              particularly useful for servers running Apache 1.x,  which  will\n"
"              report  incorrect  Content-Length  for files larger than 2 giga-\n"
"              bytes.\n"
"\n"
"              For FTP (since 7.46.0), skip the RETR command to figure out  the\n"
, stdout);
 fputs(
"              size before downloading a file.\n"
"\n"
"       -i, --include\n"
"              Include  the  HTTP  response headers in the output. The HTTP re-\n"
"              sponse headers can include things  like  server  name,  cookies,\n"
"              date of the document, HTTP version and more...\n"
"\n"
"              To view the request headers, consider the -v, --verbose option.\n"
"\n"
"              See also -v, --verbose.\n"
"\n"
"       -k, --insecure\n"
, stdout);
 fputs(
"              (TLS) By default, every SSL connection curl makes is verified to\n"
"              be secure. This option allows curl to proceed and  operate  even\n"
"              for server connections otherwise considered insecure.\n"
"\n"
"              The  server  connection  is verified by making sure the server's\n"
"              certificate contains the right name  and  verifies  successfully\n"
"              using the cert store.\n"
"\n"
"              See this online resource for further details:\n"
, stdout);
 fputs(
"               https://curl.se/docs/sslcerts.html\n"
"\n"
"              See also --proxy-insecure and --cacert.\n"
"\n"
"       --interface <name>\n"
"\n"
"              Perform  an operation using a specified interface. You can enter\n"
"              interface name, IP address or host name. An example  could  look\n"
"              like:\n"
"\n"
"               curl --interface eth0:1 https://www.example.com/\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
, stdout);
 fputs(
"              On  Linux  it can be used to specify a VRF, but the binary needs\n"
"              to either have CAP_NET_RAW or to be run as root.  More  informa-\n"
"              tion   about  Linux  VRF:  https://www.kernel.org/doc/Documenta-\n"
"              tion/networking/vrf.txt\n"
"\n"
"              See also --dns-interface.\n"
"\n"
"       -4, --ipv4\n"
"              This option tells curl to resolve names to IPv4 addresses  only,\n"
"              and not for example try IPv6.\n"
"\n"
, stdout);
 fputs(
"              See  also  --http1.1  and  --http2.  This  option  overrides -6,\n"
"              --ipv6.\n"
"\n"
"       -6, --ipv6\n"
"              This option tells curl to resolve names to IPv6 addresses  only,\n"
"              and not for example try IPv4.\n"
"\n"
"              See  also  --http1.1  and  --http2.  This  option  overrides -4,\n"
"              --ipv4.\n"
"\n"
"       -j, --junk-session-cookies\n"
"              (HTTP) When curl is told to read cookies from a given file, this\n"
, stdout);
 fputs(
"              option will make it discard all \"session cookies\". This will ba-\n"
"              sically have the same effect as if a  new  session  is  started.\n"
"              Typical  browsers  always  discard  session cookies when they're\n"
"              closed down.\n"
"\n"
"              See also -b, --cookie and -c, --cookie-jar.\n"
"\n"
"       --keepalive-time <seconds>\n"
"              This option sets the time a connection needs to remain idle  be-\n"
, stdout);
 fputs(
"              fore  sending  keepalive  probes and the time between individual\n"
"              keepalive probes. It is currently effective on operating systems\n"
"              offering  the  TCP_KEEPIDLE  and  TCP_KEEPINTVL  socket  options\n"
"              (meaning Linux, recent AIX, HP-UX and more). This option has  no\n"
"              effect if --no-keepalive is used.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
, stdout);
 fputs(
"              If unspecified, the option defaults to 60 seconds.\n"
"\n"
"              Added in 7.18.0.\n"
"\n"
"       --key-type <type>\n"
"              (TLS) Private key file type. Specify which type your --key  pro-\n"
"              vided  private  key  is. DER, PEM, and ENG are supported. If not\n"
"              specified, PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --key <key>\n"
, stdout);
 fputs(
"              (TLS SSH) Private key file name. Allows you to provide your pri-\n"
"              vate  key in this separate file. For SSH, if not specified, curl\n"
"              tries  the  following  candidates  in  order:   '~/.ssh/id_rsa',\n"
"              '~/.ssh/id_dsa', './id_rsa', './id_dsa'.\n"
"\n"
"              If  curl is built against OpenSSL library, and the engine pkcs11\n"
"              is available, then a PKCS#11 URI (RFC 7512) can be used to spec-\n"
, stdout);
 fputs(
"              ify  a  private key located in a PKCS#11 device. A string begin-\n"
"              ning with \"pkcs11:\" will be interpreted as a PKCS#11 URI.  If  a\n"
"              PKCS#11 URI is provided, then the --engine option will be set as\n"
"              \"pkcs11\" if none was provided and the --key-type option will  be\n"
"              set as \"ENG\" if none was provided.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --krb <level>\n"
, stdout);
 fputs(
"              (FTP)  Enable Kerberos authentication and use. The level must be\n"
"              entered and should be one of 'clear', 'safe', 'confidential', or\n"
"              'private'.  Should  you  use  a  level that is not one of these,\n"
"              'private' will instead be used.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              --krb requires that the underlying libcurl was built to  support\n"
"              Kerberos.\n"
"\n"
"       --libcurl <file>\n"
, stdout);
 fputs(
"              Append  this  option  to any ordinary curl command line, and you\n"
"              will get a libcurl-using C source code written to the file  that\n"
"              does the equivalent of what your command-line operation does!\n"
"\n"
"              If  this  option is used several times, the last given file name\n"
"              will be used.\n"
"\n"
"              Added in 7.16.1.\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want curl  to  use  -  for\n"
, stdout);
 fputs(
"              both downloads and uploads. This feature is useful if you have a\n"
"              limited pipe and you'd like your transfer not to use your entire\n"
"              bandwidth. To make it slower than it otherwise would be.\n"
"\n"
"              The  given speed is measured in bytes/second, unless a suffix is\n"
"              appended.  Appending 'k' or 'K' will count the number  as  kilo-\n"
"              bytes,  'm' or 'M' makes it megabytes, while 'g' or 'G' makes it\n"
, stdout);
 fputs(
"              gigabytes. Examples: 200K, 3m and 1G.\n"
"\n"
"              If you also use the -Y, --speed-limit option, that  option  will\n"
"              take precedence and might cripple the rate-limiting slightly, to\n"
"              help keeping the speed-limit logic working.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -l, --list-only\n"
"              (FTP POP3) (FTP) When listing  an  FTP  directory,  this  switch\n"
, stdout);
 fputs(
"              forces  a  name-only view. This is especially useful if the user\n"
"              wants to machine-parse the contents of an  FTP  directory  since\n"
"              the normal directory view doesn't use a standard look or format.\n"
"              When used like this, the option causes a NLST command to be sent\n"
"              to the server instead of LIST.\n"
"\n"
"              Note:  Some  FTP  servers  list  only files in their response to\n"
, stdout);
 fputs(
"              NLST; they do not include sub-directories and symbolic links.\n"
"\n"
"              (POP3) When retrieving a specific email from POP3,  this  switch\n"
"              forces  a  LIST command to be performed instead of RETR. This is\n"
"              particularly useful if the user wants to see if a specific  mes-\n"
"              sage id exists on the server and what size it is.\n"
"\n"
"              Note:  When combined with -X, --request, this option can be used\n"
, stdout);
 fputs(
"              to send an UIDL command instead, so the user may use the email's\n"
"              unique  identifier  rather  than it's message id to make the re-\n"
"              quest.\n"
"\n"
"              Added in 4.0.\n"
"\n"
"       --local-port <num/range>\n"
"              Set a preferred single number or range (FROM-TO) of  local  port\n"
"              numbers to use for the connection(s).  Note that port numbers by\n"
"              nature are a scarce resource that will be busy at times so  set-\n"
, stdout);
 fputs(
"              ting  this range to something too narrow might cause unnecessary\n"
"              connection setup failures.\n"
"\n"
"              Added in 7.15.2.\n"
"\n"
"       --location-trusted\n"
"              (HTTP) Like -L, --location, but will allow sending  the  name  +\n"
"              password to all hosts that the site may redirect to. This may or\n"
"              may not introduce a security breach if the site redirects you to\n"
"              a  site  to which you'll send your authentication info (which is\n"
, stdout);
 fputs(
"              plaintext in the case of HTTP Basic authentication).\n"
"\n"
"              See also -u, --user.\n"
"\n"
"       -L, --location\n"
"              (HTTP) If the server reports that the requested page  has  moved\n"
"              to a different location (indicated with a Location: header and a\n"
"              3XX response code), this option will make curl redo the  request\n"
"              on  the  new  place.  If used together with -i, --include or -I,\n"
, stdout);
 fputs(
"              --head, headers from all requested pages will be shown. When au-\n"
"              thentication  is  used,  curl  only sends its credentials to the\n"
"              initial host. If a redirect takes curl to a different  host,  it\n"
"              won't  be  able to intercept the user+password. See also --loca-\n"
"              tion-trusted on how to change this. You can limit the amount  of\n"
"              redirects to follow by using the --max-redirs option.\n"
"\n"
, stdout);
 fputs(
"              When  curl  follows  a redirect and if the request is a POST, it\n"
"              will do the following request with a GET if  the  HTTP  response\n"
"              was  301,  302,  or  303. If the response code was any other 3xx\n"
"              code, curl will re-send the following request using the same un-\n"
"              modified method.\n"
"\n"
"              You can tell curl to not change POST requests to GET after a 30x\n"
, stdout);
 fputs(
"              response by using the dedicated  options  for  that:  --post301,\n"
"              --post302 and --post303.\n"
"\n"
"              The  method  set  with  -X,  --request overrides the method curl\n"
"              would otherwise select to use.\n"
"\n"
"       --login-options <options>\n"
"              (IMAP POP3 SMTP) Specify the login options to use during  server\n"
"              authentication.\n"
"\n"
"              You  can  use the login options to specify protocol specific op-\n"
, stdout);
 fputs(
"              tions that may be used during authentication.  At  present  only\n"
"              IMAP,  POP3 and SMTP support login options. For more information\n"
"              about the login options please see RFC 2384, RFC 5092  and  IETF\n"
"              draft draft-earhart-url-smtp-00.txt\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.34.0.\n"
"\n"
"       --mail-auth <address>\n"
, stdout);
 fputs(
"              (SMTP)  Specify  a  single address. This will be used to specify\n"
"              the authentication address (identity)  of  a  submitted  message\n"
"              that is being relayed to another server.\n"
"\n"
"              See also --mail-rcpt and --mail-from. Added in 7.25.0.\n"
"\n"
"       --mail-from <address>\n"
"              (SMTP)  Specify  a single address that the given mail should get\n"
"              sent from.\n"
"\n"
"              See also --mail-rcpt and --mail-auth. Added in 7.20.0.\n"
"\n"
, stdout);
 fputs(
"       --mail-rcpt-allowfails\n"
"              (SMTP) When sending data to multiple recipients, by default curl\n"
"              will  abort  SMTP conversation if at least one of the recipients\n"
"              causes RCPT TO command to return an error.\n"
"\n"
"              The default behavior can be changed by  passing  --mail-rcpt-al-\n"
"              lowfails  command-line option which will make curl ignore errors\n"
"              and proceed with the remaining valid recipients.\n"
"\n"
, stdout);
 fputs(
"              In case when all recipients cause RCPT TO command to fail,  curl\n"
"              will  abort SMTP conversation and return the error received from\n"
"              to the last RCPT TO command.  Added in 7.69.0.\n"
"\n"
"       --mail-rcpt <address>\n"
"              (SMTP) Specify a single address, user name or mailing list name.\n"
"              Repeat this option several times to send to multiple recipients.\n"
"              When  performing a mail transfer, the recipient should specify a\n"
, stdout);
 fputs(
"              valid email address to send the mail to.\n"
"\n"
"              When performing an address verification (VRFY command), the  re-\n"
"              cipient  should  be  specified as the user name or user name and\n"
"              domain (as per Section 3.5 of RFC5321). (Added in 7.34.0)\n"
"\n"
"              When performing a mailing list expand (EXPN command), the recip-\n"
"              ient  should  be  specified using the mailing list name, such as\n"
, stdout);
 fputs(
"              \"Friends\" or \"London-Office\".  (Added in 7.34.0)\n"
"\n"
"              Added in 7.20.0.\n"
"\n"
"       -M, --manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify the maximum size (in bytes) of a file  to  download.  If\n"
"              the  file requested is larger than this value, the transfer will\n"
"              not start and curl will return with exit code 63.\n"
"\n"
, stdout);
 fputs(
"              A size modifier may be used. For example, Appending 'k'  or  'K'\n"
"              will  count  the  number  as  kilobytes,  'm'  or  'M'  makes it\n"
"              megabytes, while 'g' or 'G' makes it gigabytes. Examples:  200K,\n"
"              3m and 1G. (Added in 7.58.0)\n"
"\n"
"              NOTE:  The  file size is not always known prior to download, and\n"
"              for such files this option has no effect even if the file trans-\n"
, stdout);
 fputs(
"              fer  ends  up  being larger than this given limit. This concerns\n"
"              both FTP and HTTP transfers.\n"
"\n"
"              See also --limit-rate.\n"
"\n"
"       --max-redirs <num>\n"
"              (HTTP) Set maximum  number  of  redirection-followings  allowed.\n"
"              When  -L,  --location is used, is used to prevent curl from fol-\n"
"              lowing redirections too much. By default, the limit is set to 50\n"
"              redirections. Set this option to -1 to make it unlimited.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -m, --max-time <seconds>\n"
"              Maximum  time  in  seconds that you allow the whole operation to\n"
"              take.  This is useful for preventing your batch jobs from  hang-\n"
"              ing  for  hours due to slow networks or links going down.  Since\n"
"              7.32.0, this option accepts decimal values, but the actual time-\n"
, stdout);
 fputs(
"              out will decrease in accuracy as the specified timeout increases\n"
"              in decimal precision.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also --connect-timeout.\n"
"\n"
"       --metalink\n"
"              This option can tell curl to parse and process a  given  URI  as\n"
"              Metalink  file  (both  version 3 and 4 (RFC 5854) are supported)\n"
"              and make use of the mirrors listed within for failover if  there\n"
, stdout);
 fputs(
"              are  errors (such as the file or server not being available). It\n"
"              will also verify the hash of the file after  the  download  com-\n"
"              pletes.  The Metalink file itself is downloaded and processed in\n"
"              memory and not stored in the local file system.\n"
"\n"
"              Example to use a remote Metalink file:\n"
"\n"
"               curl --metalink http://www.example.com/example.metalink\n"
"\n"
, stdout);
 fputs(
"              To use a Metalink file in the local file system, use FILE proto-\n"
"              col (file://):\n"
"\n"
"               curl --metalink file://example.metalink\n"
"\n"
"              Please  note  that if FILE protocol is disabled, there is no way\n"
"              to use a local Metalink file at the time of this  writing.  Also\n"
"              note  that  if  --metalink  and -i, --include are used together,\n"
"              --include will be ignored. This is because including headers  in\n"
, stdout);
 fputs(
"              the  response  will break Metalink parser and if the headers are\n"
"              included in the file described in Metalink file, hash check will\n"
"              fail.\n"
"\n"
"              --metalink  requires  that  the  underlying libcurl was built to\n"
"              support metalink. Added in 7.27.0.\n"
"\n"
"       --negotiate\n"
"              (HTTP) Enables Negotiate (SPNEGO) authentication.\n"
"\n"
"              This option requires a library built with GSS-API or  SSPI  sup-\n"
, stdout);
 fputs(
"              port.  Use  -V,  --version  to  see  if  your curl supports GSS-\n"
"              API/SSPI or SPNEGO.\n"
"\n"
"              When using this option, you must also provide a fake -u,  --user\n"
"              option  to  activate the authentication code properly. Sending a\n"
"              '-u :' is enough as the user name  and  password  from  the  -u,\n"
"              --user option aren't actually used.\n"
"\n"
"              If  this  option  is  used  several times, only the first one is\n"
, stdout);
 fputs(
"              used.\n"
"\n"
"              See also --basic, --ntlm, --anyauth and --proxy-negotiate.\n"
"\n"
"       --netrc-file <filename>\n"
"              This option is similar to -n, --netrc, except that  you  provide\n"
"              the  path  (absolute  or  relative)  to the netrc file that curl\n"
"              should use.  You can only specify one netrc file per invocation.\n"
"              If  several --netrc-file options are provided, the last one will\n"
"              be used.\n"
"\n"
, stdout);
 fputs(
"              It will abide by --netrc-optional if specified.\n"
"\n"
"              This option overrides -n, --netrc. Added in 7.21.5.\n"
"\n"
"       --netrc-optional\n"
"              Very similar to -n, --netrc, but this option  makes  the  .netrc\n"
"              usage optional and not mandatory as the -n, --netrc option does.\n"
"\n"
"              See also --netrc-file. This option overrides -n, --netrc.\n"
"\n"
"       -n, --netrc\n"
"              Makes  curl  scan  the  .netrc  (_netrc  on Windows) file in the\n"
, stdout);
 fputs(
"              user's home directory for login name and password. This is typi-\n"
"              cally  used for FTP on Unix. If used with HTTP, curl will enable\n"
"              user authentication. See netrc(5) ftp(1) for details on the file\n"
"              format.  Curl  will  not  complain if that file doesn't have the\n"
"              right permissions (it should not be either world- or group-read-\n"
"              able).  The environment variable \"HOME\" is used to find the home\n"
"              directory.\n"
"\n"
, stdout);
 fputs(
"              A quick and very simple example of how to setup a .netrc to  al-\n"
"              low  curl  to  FTP to the machine host.domain.com with user name\n"
"              'myself' and password 'secret' should look similar to:\n"
"\n"
"              machine host.domain.com login myself password secret\n"
"\n"
"       -:, --next\n"
"              Tells curl to use a separate operation for the following URL and\n"
"              associated  options.  This  allows  you  to send several URL re-\n"
, stdout);
 fputs(
"              quests, each with their own specific options, for example,  such\n"
"              as different user names or custom requests for each.\n"
"\n"
"              -:,  --next  will  reset  all local options and only global ones\n"
"              will have their values survive over to the  operation  following\n"
"              the  -:,  --next  instruction. Global options include -v, --ver-\n"
"              bose, --trace, --trace-ascii and --fail-early.\n"
"\n"
, stdout);
 fputs(
"              For example, you can do both a GET and a POST in a  single  com-\n"
"              mand line:\n"
"\n"
"               curl www1.example.com --next -d postthis www2.example.com\n"
"\n"
"              Added in 7.36.0.\n"
"\n"
"       --no-alpn\n"
"              (HTTPS)  Disable  the ALPN TLS extension. ALPN is enabled by de-\n"
"              fault if libcurl was built with an  SSL  library  that  supports\n"
"              ALPN.  ALPN is used by a libcurl that supports HTTP/2 to negoti-\n"
, stdout);
 fputs(
"              ate HTTP/2 support with the server during https sessions.\n"
"\n"
"              See also --no-npn and --http2. --no-alpn requires that  the  un-\n"
"              derlying libcurl was built to support TLS. Added in 7.36.0.\n"
"\n"
"       -N, --no-buffer\n"
"              Disables the buffering of the output stream. In normal work sit-\n"
"              uations, curl will use a standard buffered  output  stream  that\n"
"              will have the effect that it will output the data in chunks, not\n"
, stdout);
 fputs(
"              necessarily exactly when the data arrives.   Using  this  option\n"
"              will disable that buffering.\n"
"\n"
"              Note  that  this  is the negated option name documented. You can\n"
"              thus use --buffer to enforce the buffering.\n"
"\n"
"       --no-keepalive\n"
"              Disables the use of keepalive messages on  the  TCP  connection.\n"
"              curl otherwise enables them by default.\n"
"\n"
"              Note  that  this  is the negated option name documented. You can\n"
, stdout);
 fputs(
"              thus use --keepalive to enforce keepalive.\n"
"\n"
"       --no-npn\n"
"              (HTTPS) Disable the NPN TLS extension. NPN is enabled by default\n"
"              if  libcurl was built with an SSL library that supports NPN. NPN\n"
"              is used by a libcurl that supports HTTP/2  to  negotiate  HTTP/2\n"
"              support with the server during https sessions.\n"
"\n"
"              See  also  --no-alpn and --http2. --no-npn requires that the un-\n"
, stdout);
 fputs(
"              derlying libcurl was built to support TLS. Added in 7.36.0.\n"
"\n"
"       --no-progress-meter\n"
"              Option to switch off the progress meter output without muting or\n"
"              otherwise  affecting warning and informational messages like -s,\n"
"              --silent does.\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --progress-meter to enable the progress meter again.\n"
"\n"
, stdout);
 fputs(
"              See also -v, --verbose and -s, --silent. Added in 7.67.0.\n"
"\n"
"       --no-sessionid\n"
"              (TLS)  Disable curl's use of SSL session-ID caching.  By default\n"
"              all transfers are done using the cache. Note that while  nothing\n"
"              should  ever  get  hurt  by attempting to reuse SSL session-IDs,\n"
"              there seem to be broken SSL implementations in the wild that may\n"
"              require you to disable this in order for you to succeed.\n"
"\n"
, stdout);
 fputs(
"              Note  that  this  is the negated option name documented. You can\n"
"              thus use --sessionid to enforce session-ID caching.\n"
"\n"
"              Added in 7.16.0.\n"
"\n"
"       --noproxy <no-proxy-list>\n"
"              Comma-separated list of hosts which do not use a proxy,  if  one\n"
"              is  specified.  The only wildcard is a single * character, which\n"
"              matches all hosts, and effectively disables the proxy. Each name\n"
, stdout);
 fputs(
"              in  this  list  is matched as either a domain which contains the\n"
"              hostname, or the hostname itself. For example,  local.com  would\n"
"              match   local.com,  local.com:80,  and  www.local.com,  but  not\n"
"              www.notlocal.com.\n"
"\n"
"              Since 7.53.0, This option overrides  the  environment  variables\n"
"              that  disable the proxy. If there's an environment variable dis-\n"
, stdout);
 fputs(
"              abling a proxy, you can set noproxy list to \"\" to override it.\n"
"\n"
"              Added in 7.19.4.\n"
"\n"
"       --ntlm-wb\n"
"              (HTTP) Enables NTLM much in the style --ntlm does, but hand over\n"
"              the  authentication  to the separate binary ntlmauth application\n"
"              that is executed when needed.\n"
"\n"
"              See also --ntlm and --proxy-ntlm.\n"
"\n"
"       --ntlm (HTTP) Enables  NTLM  authentication.  The  NTLM  authentication\n"
, stdout);
 fputs(
"              method was designed by Microsoft and is used by IIS web servers.\n"
"              It is a proprietary protocol, reverse-engineered by clever  peo-\n"
"              ple and implemented in curl based on their efforts. This kind of\n"
"              behavior should not be endorsed, you should  encourage  everyone\n"
"              who  uses  NTLM to switch to a public and documented authentica-\n"
"              tion method instead, such as Digest.\n"
"\n"
, stdout);
 fputs(
"              If you want to enable NTLM for your proxy  authentication,  then\n"
"              use --proxy-ntlm.\n"
"\n"
"              If  this  option  is  used  several times, only the first one is\n"
"              used.\n"
"\n"
"              See also  --proxy-ntlm.  --ntlm  requires  that  the  underlying\n"
"              libcurl  was built to support TLS. This option overrides --basic\n"
"              and --negotiate and --digest and --anyauth.\n"
"\n"
"       --oauth2-bearer <token>\n"
, stdout);
 fputs(
"              (IMAP POP3 SMTP HTTP) Specify the Bearer  Token  for  OAUTH  2.0\n"
"              server  authentication.  The Bearer Token is used in conjunction\n"
"              with the user name which can be specified as part of  the  --url\n"
"              or -u, --user options.\n"
"\n"
"              The  Bearer  Token  and user name are formatted according to RFC\n"
"              6750.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --output-dir <dir>\n"
"\n"
, stdout);
 fputs(
"              This option specifies the directory in  which  files  should  be\n"
"              stored, when -O, --remote-name or -o, --output are used.\n"
"\n"
"              The  given  output directory is used for all URLs and output op-\n"
"              tions on the command line, up until the first -:, --next.\n"
"\n"
"              If the specified target directory doesn't exist,  the  operation\n"
"              will fail unless --create-dirs is also used.\n"
"\n"
, stdout);
 fputs(
"              If this option is used multiple times, the last specified direc-\n"
"              tory will be used.\n"
"\n"
"              See also -O, --remote-name and -J,  --remote-header-name.  Added\n"
"              in 7.73.0.\n"
"\n"
"       -o, --output <file>\n"
"              Write output to <file> instead of stdout. If you are using {} or\n"
"              [] to fetch multiple documents, you should quote the URL and you\n"
"              can  use  '#' followed by a number in the <file> specifier. That\n"
, stdout);
 fputs(
"              variable will be replaced with the current string  for  the  URL\n"
"              being fetched. Like in:\n"
"\n"
"               curl \"http://{one,two}.example.com\" -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
"               curl \"http://{site,host}.host[1-5].com\" -o \"#1_#2\"\n"
"\n"
"              You  may use this option as many times as the number of URLs you\n"
"              have. For example, if you specify two URLs on the  same  command\n"
, stdout);
 fputs(
"              line, you can use it like this:\n"
"\n"
"                curl -o aa example.com -o bb example.net\n"
"\n"
"              and  the  order  of  the -o options and the URLs doesn't matter,\n"
"              just that the first -o is for the first URL and so  on,  so  the\n"
"              above command line can also be written as\n"
"\n"
"                curl example.com example.net -o aa -o bb\n"
"\n"
"              See  also  the --create-dirs option to create the local directo-\n"
, stdout);
 fputs(
"              ries dynamically. Specifying the output as '-' (a  single  dash)\n"
"              will force the output to be done to stdout.\n"
"\n"
"              See  also -O, --remote-name, --remote-name-all and -J, --remote-\n"
"              header-name.\n"
"\n"
"       --parallel-immediate\n"
"              When doing parallel transfers, this option  will  instruct  curl\n"
"              that it should rather prefer opening up more connections in par-\n"
, stdout);
 fputs(
"              allel at once rather than waiting to see if new transfers can be\n"
"              added as multiplexed streams on another connection.\n"
"\n"
"              See also -Z, --parallel and --parallel-max. Added in 7.68.0.\n"
"\n"
"       --parallel-max\n"
"              When  asked to do parallel transfers, using -Z, --parallel, this\n"
"              option controls the maximum amount of transfers to do simultane-\n"
"              ously.\n"
"\n"
"              The default is 50.\n"
"\n"
, stdout);
 fputs(
"              See also -Z, --parallel. Added in 7.66.0.\n"
"\n"
"       -Z, --parallel\n"
"              Makes  curl perform its transfers in parallel as compared to the\n"
"              regular serial manner.\n"
"\n"
"              Added in 7.66.0.\n"
"\n"
"       --pass <phrase>\n"
"              (SSH TLS) Passphrase for the private key\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --path-as-is\n"
"              Tell curl to not handle sequences of /../ or /./  in  the  given\n"
, stdout);
 fputs(
"              URL  path.  Normally curl will squash or merge them according to\n"
"              standards but with this option set you tell it not to do that.\n"
"\n"
"              Added in 7.42.0.\n"
"\n"
"       --pinnedpubkey <hashes>\n"
"              (TLS) Tells curl to  use  the  specified  public  key  file  (or\n"
"              hashes)  to  verify the peer. This can be a path to a file which\n"
"              contains a single public key in PEM or DER format, or any number\n"
, stdout);
 fputs(
"              of base64 encoded sha256 hashes preceded by 'sha256//' and sepa-\n"
"              rated by ';'\n"
"\n"
"              When negotiating a TLS or SSL connection,  the  server  sends  a\n"
"              certificate  indicating  its identity. A public key is extracted\n"
"              from this certificate and if it does not exactly match the  pub-\n"
"              lic  key provided to this option, curl will abort the connection\n"
"              before sending or receiving any data.\n"
"\n"
, stdout);
 fputs(
"              PEM/DER support:\n"
"                7.39.0: OpenSSL, GnuTLS and GSKit\n"
"                7.43.0: NSS and wolfSSL\n"
"                7.47.0: mbedtls sha256 support:\n"
"                7.44.0: OpenSSL, GnuTLS, NSS and wolfSSL\n"
"                7.47.0: mbedtls Other SSL backends not supported.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --post301\n"
"              (HTTP) Tells curl to respect RFC 7231/6.4.2 and not convert POST\n"
, stdout);
 fputs(
"              requests into GET requests when following a 301 redirection. The\n"
"              non-RFC behavior is ubiquitous in web browsers, so curl does the\n"
"              conversion by default to maintain consistency. However, a server\n"
"              may require a POST to remain a POST after  such  a  redirection.\n"
"              This option is meaningful only when using -L, --location.\n"
"\n"
"              See  also  --post302,  --post303  and  -L,  --location. Added in\n"
"              7.17.1.\n"
"\n"
, stdout);
 fputs(
"       --post302\n"
"              (HTTP) Tells curl to respect RFC 7231/6.4.3 and not convert POST\n"
"              requests into GET requests when following a 302 redirection. The\n"
"              non-RFC behavior is ubiquitous in web browsers, so curl does the\n"
"              conversion by default to maintain consistency. However, a server\n"
"              may require a POST to remain a POST after  such  a  redirection.\n"
"              This option is meaningful only when using -L, --location.\n"
"\n"
, stdout);
 fputs(
"              See  also  --post301,  --post303  and  -L,  --location. Added in\n"
"              7.19.1.\n"
"\n"
"       --post303\n"
"              (HTTP) Tells curl to violate RFC 7231/6.4.4 and not convert POST\n"
"              requests  into  GET  requests when following 303 redirections. A\n"
"              server may require a POST to remain a POST after a 303 redirect-\n"
"              ion. This option is meaningful only when using -L, --location.\n"
"\n"
, stdout);
 fputs(
"              See  also  --post302,  --post301  and  -L,  --location. Added in\n"
"              7.26.0.\n"
"\n"
"       --preproxy [protocol://]host[:port]\n"
"              Use the specified SOCKS proxy before connecting to  an  HTTP  or\n"
"              HTTPS  -x,  --proxy.  In  such a case curl first connects to the\n"
"              SOCKS proxy and then connects (through SOCKS)  to  the  HTTP  or\n"
"              HTTPS proxy. Hence pre proxy.\n"
"\n"
, stdout);
 fputs(
"              The pre proxy string should be specified with a protocol:// pre-\n"
"              fix to  specify  alternative  proxy  protocols.  Use  socks4://,\n"
"              socks4a://,  socks5://  or  socks5h://  to  request the specific\n"
"              SOCKS version to be used. No protocol specified will  make  curl\n"
"              default to SOCKS4.\n"
"\n"
"              If  the  port number is not specified in the proxy string, it is\n"
"              assumed to be 1080.\n"
"\n"
, stdout);
 fputs(
"              User and password that might be provided in the proxy string are\n"
"              URL  decoded by curl. This allows you to pass in special charac-\n"
"              ters such as @ by using %40 or pass in a colon with %3a.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       -#, --progress-bar\n"
"              Make curl display transfer progress as a simple progress bar in-\n"
, stdout);
 fputs(
"              stead of the standard, more informational, meter.\n"
"\n"
"              This  progress  bar draws a single line of '#' characters across\n"
"              the screen and shows a percentage if the transfer size is known.\n"
"              For  transfers  without  a  known size, there will be space ship\n"
"              (-=o=-) that moves back and forth but only while data  is  being\n"
"              transferred, with a set of flying hash sign symbols on top.\n"
"\n"
"       --proto-default <protocol>\n"
, stdout);
 fputs(
"              Tells curl to use protocol for any URL missing a scheme name.\n"
"\n"
"              Example:\n"
"\n"
"               curl --proto-default https ftp.mozilla.org\n"
"\n"
"              An  unknown  or  unsupported  protocol causes error CURLE_UNSUP-\n"
"              PORTED_PROTOCOL (1).\n"
"\n"
"              This option does not change the default proxy protocol (http).\n"
"\n"
"              Without this option curl would make a guess based on  the  host,\n"
"              see --url for details.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.45.0.\n"
"\n"
"       --proto-redir <protocols>\n"
"              Tells  curl to limit what protocols it may use on redirect. Pro-\n"
"              tocols denied by --proto are not overridden by this option.  See\n"
"              --proto for how protocols are represented.\n"
"\n"
"              Example, allow only HTTP and HTTPS on redirect:\n"
"\n"
"               curl --proto-redir -all,http,https http://example.com\n"
"\n"
"              By default curl will allow HTTP, HTTPS, FTP and FTPS on redirect\n"
, stdout);
 fputs(
"              (7.65.2).  Older versions of curl allowed all protocols on redi-\n"
"              rect  except several disabled for security reasons: Since 7.19.4\n"
"              FILE and SCP are disabled, and since 7.40.0  SMB  and  SMBS  are\n"
"              also  disabled.  Specifying all or +all enables all protocols on\n"
"              redirect, including those disabled for security.\n"
"\n"
"              Added in 7.20.2.\n"
"\n"
"       --proto <protocols>\n"
, stdout);
 fputs(
"              Tells curl to limit what protocols it may use in  the  transfer.\n"
"              Protocols  are evaluated left to right, are comma separated, and\n"
"              are each a protocol name or 'all', optionally prefixed  by  zero\n"
"              or more modifiers. Available modifiers are:\n"
"\n"
"              +  Permit this protocol in addition to protocols already permit-\n"
"                 ted (this is the default if no modifier is used).\n"
"\n"
, stdout);
 fputs(
"              -  Deny this protocol, removing it from the  list  of  protocols\n"
"                 already permitted.\n"
"\n"
"              =  Permit  only this protocol (ignoring the list already permit-\n"
"                 ted), though subject to later modification by subsequent  en-\n"
"                 tries in the comma separated list.\n"
"\n"
"              For example:\n"
"\n"
"              --proto -ftps  uses the default protocols, but disables ftps\n"
"\n"
"              --proto -all,https,+http\n"
, stdout);
 fputs(
"                             only enables http and https\n"
"\n"
"              --proto =http,https\n"
"                             also only enables http and https\n"
"\n"
"       Unknown protocols produce a warning. This allows scripts to safely rely\n"
"       on being able to disable potentially dangerous protocols, without rely-\n"
"       ing  upon  support  for that protocol being built into curl to avoid an\n"
"       error.\n"
"\n"
"       This option can be used multiple times, in which case the effect is the\n"
, stdout);
 fputs(
"       same as concatenating the protocols into one instance of the option.\n"
"\n"
"       See also --proto-redir and --proto-default. Added in 7.20.2.\n"
"\n"
"       --proxy-anyauth\n"
"              Tells  curl to pick a suitable authentication method when commu-\n"
"              nicating with the given HTTP proxy. This might  cause  an  extra\n"
"              request/response round-trip.\n"
"\n"
"              See also -x, --proxy, --proxy-basic and --proxy-digest. Added in\n"
"              7.13.2.\n"
"\n"
"       --proxy-basic\n"
, stdout);
 fputs(
"              Tells curl to use HTTP Basic authentication  when  communicating\n"
"              with the given proxy. Use --basic for enabling HTTP Basic with a\n"
"              remote host. Basic is the  default  authentication  method  curl\n"
"              uses with proxies.\n"
"\n"
"              See also -x, --proxy, --proxy-anyauth and --proxy-digest.\n"
"\n"
"       --proxy-cacert <file>\n"
"              Same as --cacert but used in HTTPS proxy context.\n"
"\n"
, stdout);
 fputs(
"              See  also  --proxy-capath,  --cacert,  --capath and -x, --proxy.\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-capath <dir>\n"
"              Same as --capath but used in HTTPS proxy context.\n"
"\n"
"              See also --proxy-cacert, -x,  --proxy  and  --capath.  Added  in\n"
"              7.52.0.\n"
"\n"
"       --proxy-cert-type <type>\n"
"              Same as --cert-type but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-cert <cert[:passwd]>\n"
, stdout);
 fputs(
"              Same as -E, --cert but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-ciphers <list>\n"
"              Same as --ciphers but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-crlfile <file>\n"
"              Same as --crlfile but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-digest\n"
"              Tells  curl to use HTTP Digest authentication when communicating\n"
, stdout);
 fputs(
"              with the given proxy. Use --digest for enabling HTTP Digest with\n"
"              a remote host.\n"
"\n"
"              See also -x, --proxy, --proxy-anyauth and --proxy-basic.\n"
"\n"
"       --proxy-header <header/@file>\n"
"              (HTTP)  Extra header to include in the request when sending HTTP\n"
"              to a proxy. You may specify any number of extra headers. This is\n"
"              the  equivalent option to -H, --header but is for proxy communi-\n"
, stdout);
 fputs(
"              cation only like in CONNECT requests when you  want  a  separate\n"
"              header  sent  to  the proxy to what is sent to the actual remote\n"
"              host.\n"
"\n"
"              curl will make sure that each header  you  add/replace  is  sent\n"
"              with the proper end-of-line marker, you should thus not add that\n"
"              as a part of the header content: do not add newlines or carriage\n"
"              returns, they will only mess things up for you.\n"
"\n"
, stdout);
 fputs(
"              Headers  specified  with this option will not be included in re-\n"
"              quests that curl knows will not be sent to a proxy.\n"
"\n"
"              Starting in 7.55.0, this option can take an argument  in  @file-\n"
"              name  style, which then adds a header for each line in the input\n"
"              file. Using @- will make curl read the header file from stdin.\n"
"\n"
"              This option can be used  multiple  times  to  add/replace/remove\n"
"              multiple headers.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.37.0.\n"
"       --proxy-insecure\n"
"              Same as -k, --insecure but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-key-type <type>\n"
"              Same as --key-type but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-key <key>\n"
"              Same as --key but used in HTTPS proxy context.\n"
"\n"
"       --proxy-negotiate\n"
"              Tells  curl  to  use HTTP Negotiate (SPNEGO) authentication when\n"
, stdout);
 fputs(
"              communicating with the given proxy. Use --negotiate for enabling\n"
"              HTTP Negotiate (SPNEGO) with a remote host.\n"
"\n"
"              See also --proxy-anyauth and --proxy-basic. Added in 7.17.1.\n"
"\n"
"       --proxy-ntlm\n"
"              Tells  curl  to  use HTTP NTLM authentication when communicating\n"
"              with the given proxy. Use --ntlm for enabling NTLM with a remote\n"
"              host.\n"
"\n"
"              See also --proxy-negotiate and --proxy-anyauth.\n"
"\n"
, stdout);
 fputs(
"       --proxy-pass <phrase>\n"
"              Same as --pass but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-pinnedpubkey <hashes>\n"
"              (TLS)  Tells  curl  to  use  the  specified  public key file (or\n"
"              hashes) to verify the proxy. This can be a path to a file  which\n"
"              contains a single public key in PEM or DER format, or any number\n"
"              of base64 encoded sha256 hashes preceded by 'sha256//' and sepa-\n"
, stdout);
 fputs(
"              rated by ';'\n"
"\n"
"              When  negotiating  a  TLS  or SSL connection, the server sends a\n"
"              certificate indicating its identity. A public key  is  extracted\n"
"              from  this certificate and if it does not exactly match the pub-\n"
"              lic key provided to this option, curl will abort the  connection\n"
"              before sending or receiving any data.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --proxy-service-name <name>\n"
"              This  option allows you to change the service name for proxy ne-\n"
"              gotiation.\n"
"\n"
"              Added in 7.43.0.\n"
"\n"
"       --proxy-ssl-allow-beast\n"
"              Same as --ssl-allow-beast but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-tls13-ciphers <ciphersuite list>\n"
"              (TLS) Specifies which cipher suites to use in the connection  to\n"
, stdout);
 fputs(
"              your HTTPS proxy when it negotiates TLS 1.3. The list of ciphers\n"
"              suites must specify valid ciphers. Read up  on  TLS  1.3  cipher\n"
"              suite details on this URL:\n"
"\n"
"               https://curl.se/docs/ssl-ciphers.html\n"
"\n"
"              This  option  is  currently  used only when curl is built to use\n"
"              OpenSSL 1.1.1 or later. If you are using a different SSL backend\n"
"              you  can try setting TLS 1.3 cipher suites by using the --proxy-\n"
, stdout);
 fputs(
"              ciphers option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --proxy-tlsauthtype <type>\n"
"              Same as --tlsauthtype but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-tlspassword <string>\n"
"              Same as --tlspassword but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       --proxy-tlsuser <name>\n"
"              Same as --tlsuser but used in HTTPS proxy context.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.52.0.\n"
"\n"
"       --proxy-tlsv1\n"
"              Same as -1, --tlsv1 but used in HTTPS proxy context.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       -U, --proxy-user <user:password>\n"
"              Specify the user name and password to use for proxy  authentica-\n"
"              tion.\n"
"\n"
"              If  you use a Windows SSPI-enabled curl binary and do either Ne-\n"
"              gotiate or NTLM authentication then you can tell curl to  select\n"
, stdout);
 fputs(
"              the user name and password from your environment by specifying a\n"
"              single colon with this option: \"-U :\".\n"
"\n"
"              On systems where it works, curl will hide the given option argu-\n"
"              ment  from  process listings. This is not enough to protect cre-\n"
"              dentials from possibly getting seen by other users on  the  same\n"
"              system  as  they will still be visible for a brief moment before\n"
, stdout);
 fputs(
"              cleared. Such sensitive data should be retrieved from a file in-\n"
"              stead or similar and never used in clear text in a command line.\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -x, --proxy [protocol://]host[:port]\n"
"              Use the specified proxy.\n"
"\n"
"              The  proxy string can be specified with a protocol:// prefix. No\n"
"              protocol specified or http:// will be treated as HTTP proxy. Use\n"
, stdout);
 fputs(
"              socks4://, socks4a://, socks5:// or socks5h:// to request a spe-\n"
"              cific SOCKS version to be used.  (The protocol support was added\n"
"              in curl 7.21.7)\n"
"\n"
"              HTTPS  proxy  support  via https:// protocol prefix was added in\n"
"              7.52.0 for OpenSSL, GnuTLS and NSS.\n"
"\n"
"              Unrecognized and unsupported  proxy  protocols  cause  an  error\n"
"              since  7.52.0.   Prior  versions may ignore the protocol and use\n"
, stdout);
 fputs(
"              http:// instead.\n"
"\n"
"              If the port number is not specified in the proxy string,  it  is\n"
"              assumed to be 1080.\n"
"\n"
"              This  option  overrides  existing environment variables that set\n"
"              the proxy to use. If there's an environment variable  setting  a\n"
"              proxy, you can set proxy to \"\" to override it.\n"
"\n"
"              All operations that are performed over an HTTP proxy will trans-\n"
, stdout);
 fputs(
"              parently be converted to HTTP. It means  that  certain  protocol\n"
"              specific operations might not be available. This is not the case\n"
"              if you can tunnel through the proxy, as one with the -p, --prox-\n"
"              ytunnel option.\n"
"\n"
"              User and password that might be provided in the proxy string are\n"
"              URL decoded by curl. This allows you to pass in special  charac-\n"
"              ters such as @ by using %40 or pass in a colon with %3a.\n"
"\n"
, stdout);
 fputs(
"              The  proxy host can be specified the exact same way as the proxy\n"
"              environment variables, including the protocol  prefix  (http://)\n"
"              and the embedded user + password.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --proxy1.0 <host[:port]>\n"
"              Use  the  specified  HTTP  1.0  proxy. If the port number is not\n"
"              specified, it is assumed at port 1080.\n"
"\n"
, stdout);
 fputs(
"              The only difference between this and the HTTP proxy  option  -x,\n"
"              --proxy,  is that attempts to use CONNECT through the proxy will\n"
"              specify an HTTP 1.0 protocol instead of the default HTTP 1.1.\n"
"\n"
"       -p, --proxytunnel\n"
"              When an HTTP proxy is used -x, --proxy, this  option  will  make\n"
"              curl  tunnel through the proxy. The tunnel approach is made with\n"
"              the HTTP proxy CONNECT request and requires that the  proxy  al-\n"
, stdout);
 fputs(
"              lows direct connect to the remote port number curl wants to tun-\n"
"              nel through to.\n"
"\n"
"              To suppress proxy CONNECT response headers when curl is  set  to\n"
"              output headers use --suppress-connect-headers.\n"
"\n"
"              See also -x, --proxy.\n"
"\n"
"       --pubkey <key>\n"
"              (SFTP SCP) Public key file name. Allows you to provide your pub-\n"
"              lic key in this separate file.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"              (As of 7.39.0, curl attempts to automatically extract the public\n"
"              key  from the private key file, so passing this option is gener-\n"
"              ally not required. Note that this public key extraction requires\n"
"              libcurl  to  be linked against a copy of libssh2 1.2.8 or higher\n"
"              that is itself linked against OpenSSL.)\n"
"\n"
"       -Q, --quote\n"
, stdout);
 fputs(
"              (FTP SFTP) Send an arbitrary command to the remote FTP  or  SFTP\n"
"              server.  Quote commands are sent BEFORE the transfer takes place\n"
"              (just after the initial PWD command in an FTP  transfer,  to  be\n"
"              exact). To make commands take place after a successful transfer,\n"
"              prefix them with a dash '-'.  To make  commands  be  sent  after\n"
"              curl has changed the working directory, just before the transfer\n"
, stdout);
 fputs(
"              command(s), prefix the command with a '+'  (this  is  only  sup-\n"
"              ported for FTP). You may specify any number of commands.\n"
"\n"
"              If  the  server returns failure for one of the commands, the en-\n"
"              tire operation will be aborted. You must send syntactically cor-\n"
"              rect  FTP  commands as RFC 959 defines to FTP servers, or one of\n"
"              the commands listed below to SFTP servers.\n"
"\n"
, stdout);
 fputs(
"              Prefix the command with an asterisk (*) to  make  curl  continue\n"
"              even  if the command fails as by default curl will stop at first\n"
"              failure.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"              SFTP is a binary protocol. Unlike for FTP, curl interprets  SFTP\n"
"              quote  commands  itself before sending them to the server.  File\n"
"              names may be quoted shell-style to embed spaces or special char-\n"
, stdout);
 fputs(
"              acters.   Following is the list of all supported SFTP quote com-\n"
"              mands:\n"
"\n"
"              atime date file\n"
"                     The atime command sets the last access time of  the  file\n"
"                     named  by  the file operand. The <date expression> can be\n"
"                     all sorts of date strings, see  the  curl_getdate(3)  man\n"
"                     page for date expression details. (Added in 7.73.0)\n"
"\n"
"              chgrp group file\n"
, stdout);
 fputs(
"                     The  chgrp command sets the group ID of the file named by\n"
"                     the file operand to the group ID specified by  the  group\n"
"                     operand. The group operand is a decimal integer group ID.\n"
"\n"
"              chmod mode file\n"
"                     The  chmod  command  modifies  the  file mode bits of the\n"
"                     specified file. The mode operand is an octal integer mode\n"
"                     number.\n"
"\n"
"              chown user file\n"
, stdout);
 fputs(
"                     The chown command sets the owner of the file named by the\n"
"                     file operand to the user ID specified by the  user  oper-\n"
"                     and. The user operand is a decimal integer user ID.\n"
"\n"
"              ln source_file target_file\n"
"                     The ln and symlink commands create a symbolic link at the\n"
"                     target_file location pointing to  the  source_file  loca-\n"
"                     tion.\n"
"\n"
"              mkdir directory_name\n"
, stdout);
 fputs(
"                     The  mkdir command creates the directory named by the di-\n"
"                     rectory_name operand.\n"
"\n"
"              mtime date file\n"
"                     The mtime command sets the last modification time of  the\n"
"                     file named by the file operand. The <date expression> can\n"
"                     be all sorts of date strings, see the curl_getdate(3) man\n"
"                     page for date expression details. (Added in 7.73.0)\n"
"\n"
, stdout);
 fputs(
"              pwd    The pwd command returns the absolute pathname of the cur-\n"
"                     rent working directory.\n"
"\n"
"              rename source target\n"
"                     The rename command renames the file or directory named by\n"
"                     the  source  operand to the destination path named by the\n"
"                     target operand.\n"
"\n"
"              rm file\n"
"                     The rm command removes the file specified by the file op-\n"
"                     erand.\n"
"\n"
, stdout);
 fputs(
"              rmdir directory\n"
"                     The  rmdir  command removes the directory entry specified\n"
"                     by the directory operand, provided it is empty.\n"
"\n"
"              symlink source_file target_file\n"
"                     See ln.\n"
"\n"
"       --random-file <file>\n"
"              Specify the path name to file containing what will be considered\n"
"              as  random  data. The data may be used to seed the random engine\n"
, stdout);
 fputs(
"              for SSL connections.  See also the --egd-file option.\n"
"\n"
"       -r, --range <range>\n"
"              (HTTP FTP SFTP FILE) Retrieve a byte range (i.e. a partial docu-\n"
"              ment)  from  an  HTTP/1.1,  FTP  or SFTP server or a local FILE.\n"
"              Ranges can be specified in a number of ways.\n"
"\n"
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
, stdout);
 fputs(
"              9500-     specifies the bytes from offset 9500 and forward\n"
"\n"
"              0-0,-1    specifies the first and last byte only(*)(HTTP)\n"
"\n"
"              100-199,500-599\n"
"                        specifies two separate 100-byte ranges(*) (HTTP)\n"
"\n"
"              (*) = NOTE that this will cause the server to reply with a  mul-\n"
"              tipart  response,  which will be returned as-is by curl! Parsing\n"
"              or otherwise transforming this response is the responsibility of\n"
, stdout);
 fputs(
"              the caller.\n"
"\n"
"              Only  digit characters (0-9) are valid in the 'start' and 'stop'\n"
"              fields of the 'start-stop' range syntax. If a non-digit  charac-\n"
"              ter is given in the range, the server's response will be unspec-\n"
"              ified, depending on the server's configuration.\n"
"\n"
"              You should also be aware that many HTTP/1.1 servers do not  have\n"
"              this  feature  enabled, so that when you attempt to get a range,\n"
, stdout);
 fputs(
"              you'll instead get the whole document.\n"
"\n"
"              FTP and SFTP range downloads only  support  the  simple  'start-\n"
"              stop'  syntax  (optionally with one of the numbers omitted). FTP\n"
"              use depends on the extended FTP command SIZE.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --raw  (HTTP) When used, it disables all internal HTTP decoding of con-\n"
, stdout);
 fputs(
"              tent  or transfer encodings and instead makes them passed on un-\n"
"              altered, raw.\n"
"\n"
"              Added in 7.16.2.\n"
"\n"
"       -e, --referer <URL>\n"
"              (HTTP) Sends the \"Referrer Page\" information to the HTTP server.\n"
"              This can also be set with the -H, --header flag of course.  When\n"
"              used with -L, --location you  can  append  \";auto\"  to  the  -e,\n"
"              --referer  URL  to  make curl automatically set the previous URL\n"
, stdout);
 fputs(
"              when it follows a Location: header. The \";auto\"  string  can  be\n"
"              used alone, even if you don't set an initial -e, --referer.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -A, --user-agent and -H, --header.\n"
"\n"
"       -J, --remote-header-name\n"
"              (HTTP) This option tells the -O, --remote-name option to use the\n"
"              server-specified Content-Disposition  filename  instead  of  ex-\n"
, stdout);
 fputs(
"              tracting a filename from the URL.\n"
"\n"
"              If  the  server  specifies a file name and a file with that name\n"
"              already exists in the current working directory it will  not  be\n"
"              overwritten and an error will occur. If the server doesn't spec-\n"
"              ify a file name then this option has no effect.\n"
"\n"
"              There's no attempt to decode %-sequences (yet) in  the  provided\n"
, stdout);
 fputs(
"              file name, so this option may provide you with rather unexpected\n"
"              file names.\n"
"\n"
"              WARNING: Exercise judicious use of this  option,  especially  on\n"
"              Windows.  A  rogue  server  could  send you the name of a DLL or\n"
"              other file that could possibly be loaded automatically  by  Win-\n"
"              dows or some third party software.\n"
"\n"
"       --remote-name-all\n"
"              This  option changes the default action for all given URLs to be\n"
, stdout);
 fputs(
"              dealt with as if -O, --remote-name were used for each one. So if\n"
"              you want to disable that for a specific URL after --remote-name-\n"
"              all has been used, you must use \"-o -\" or --no-remote-name.\n"
"\n"
"              Added in 7.19.0.\n"
"\n"
"       -O, --remote-name\n"
"              Write output to a local file named like the remote file we  get.\n"
"              (Only  the file part of the remote file is used, the path is cut\n"
"              off.)\n"
"\n"
, stdout);
 fputs(
"              The file will be saved in the current working directory. If  you\n"
"              want  the  file  saved  in  a different directory, make sure you\n"
"              change the current working directory before invoking  curl  with\n"
"              this option.\n"
"\n"
"              The  remote  file  name  to use for saving is extracted from the\n"
"              given URL, nothing else, and if it already  exists  it  will  be\n"
, stdout);
 fputs(
"              overwritten.  If  you  want  the server to be able to choose the\n"
"              file name refer to -J, --remote-header-name which can be used in\n"
"              addition  to  this option. If the server chooses a file name and\n"
"              that name already exists it will not be overwritten.\n"
"\n"
"              There is no URL decoding done on the file name. If it has %20 or\n"
"              other  URL  encoded parts of the name, they will end up as-is as\n"
"              file name.\n"
"\n"
, stdout);
 fputs(
"              You may use this option as many times as the number of URLs  you\n"
"              have.\n"
"\n"
"       -R, --remote-time\n"
"              When  used,  this will make curl attempt to figure out the time-\n"
"              stamp of the remote file, and if that is available make the  lo-\n"
"              cal file get that same timestamp.\n"
"\n"
"       --request-target\n"
"              (HTTP)  Tells curl to use an alternative \"target\" (path) instead\n"
, stdout);
 fputs(
"              of using the path as provided in the  URL.  Particularly  useful\n"
"              when  wanting  to  issue  HTTP requests without leading slash or\n"
"              other data that doesn't follow the  regular  URL  pattern,  like\n"
"              \"OPTIONS *\".\n"
"\n"
"              Added in 7.55.0.\n"
"\n"
"       -X, --request <command>\n"
"              (HTTP) Specifies a custom request method to use when communicat-\n"
"              ing with the HTTP server.  The specified request method will  be\n"
, stdout);
 fputs(
"              used  instead  of  the  method otherwise used (which defaults to\n"
"              GET). Read the HTTP 1.1 specification for details  and  explana-\n"
"              tions.  Common  additional HTTP requests include PUT and DELETE,\n"
"              but related technologies like WebDAV offers PROPFIND, COPY, MOVE\n"
"              and more.\n"
"\n"
"              Normally  you  don't  need  this option. All sorts of GET, HEAD,\n"
"              POST and PUT requests are rather invoked by using dedicated com-\n"
, stdout);
 fputs(
"              mand line options.\n"
"\n"
"              This  option  only  changes the actual word used in the HTTP re-\n"
"              quest, it does not alter the way curl behaves. So for example if\n"
"              you  want  to make a proper HEAD request, using -X HEAD will not\n"
"              suffice. You need to use the -I, --head option.\n"
"\n"
"              The method string you set with -X, --request will  be  used  for\n"
"              all  requests,  which  if you for example use -L, --location may\n"
, stdout);
 fputs(
"              cause unintended side-effects when curl doesn't  change  request\n"
"              method according to the HTTP 30x response codes - and similar.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead of LIST when\n"
"              doing file lists with FTP.\n"
"\n"
"              (POP3) Specifies a custom POP3 command to use instead of LIST or\n"
"              RETR. (Added in 7.26.0)\n"
"\n"
"              (IMAP)  Specifies  a custom IMAP command to use instead of LIST.\n"
, stdout);
 fputs(
"              (Added in 7.30.0)\n"
"\n"
"              (SMTP) Specifies a custom SMTP command to use instead of HELP or\n"
"              VRFY. (Added in 7.34.0)\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --resolve <[+]host:port:addr[,addr]...>\n"
"              Provide  a custom address for a specific host and port pair. Us-\n"
"              ing this, you can make the curl requests(s) use a specified  ad-\n"
, stdout);
 fputs(
"              dress  and prevent the otherwise normally resolved address to be\n"
"              used. Consider it a sort of /etc/hosts alternative  provided  on\n"
"              the  command line. The port number should be the number used for\n"
"              the specific protocol the host will be used for.  It  means  you\n"
"              need several entries if you want to provide address for the same\n"
"              host but different ports.\n"
"\n"
, stdout);
 fputs(
"              By specifying '*' as host you can tell curl to resolve any  host\n"
"              and specific port pair to the specified address. Wildcard is re-\n"
"              solved last so any --resolve with a specific host and port  will\n"
"              be used first.\n"
"\n"
"              The provided address set by this option will be used even if -4,\n"
"              --ipv4 or -6, --ipv6 is set to make curl use another IP version.\n"
, stdout);
 fputs(
"              By prefixing the host with a '+' you can make the entry time out\n"
"              after  curl's  default  timeout  (1 minute). Note that this will\n"
"              only make sense for long running parallel transfers with  a  lot\n"
"              of files. In such cases, if this option is used curl will try to\n"
"              resolve the host as it normally would once the timeout  has  ex-\n"
"              pired.\n"
"\n"
"              Support for providing the IP address within [brackets] was added\n"
, stdout);
 fputs(
"              in 7.57.0.\n"
"\n"
"              Support for providing multiple IP addresses per entry was  added\n"
"              in 7.59.0.\n"
"\n"
"              Support for resolving with wildcard was added in 7.64.0.\n"
"\n"
"              Support for the '+' prefix was was added in 7.75.0.\n"
"\n"
"              This option can be used many times to add many host names to re-\n"
"              solve.\n"
"\n"
"              Added in 7.21.3.\n"
"\n"
"       --retry-all-errors\n"
, stdout);
 fputs(
"              Retry on any error. This option is used together with --retry.\n"
"\n"
"              This option is the \"sledgehammer\" of retrying. Do not  use  this\n"
"              option by default (eg in curlrc), there may be unintended conse-\n"
"              quences such as sending or receiving duplicate data. Do not  use\n"
"              with  redirected  input or output. You'd be much better off han-\n"
"              dling your unique problems in shell script. Please read the  ex-\n"
"              ample below.\n"
, stdout);
 fputs(
"\n"
"              Warning:  For server compatibility curl attempts to retry failed\n"
"              flaky transfers as close as possible to how they  were  started,\n"
"              but  this  is  not possible with redirected input or output. For\n"
"              example, before retrying it removes output data  from  a  failed\n"
"              partial  transfer  that  was  written to an output file. However\n"
"              this is not true of data redirected to a | pipe or > file, which\n"
, stdout);
 fputs(
"              are  not reset. We strongly suggest don't parse or record output\n"
"              via redirect in combination with this option, since you may  re-\n"
"              ceive duplicate data.\n"
"\n"
"              Added in 7.71.0.\n"
"\n"
"       --retry-connrefused\n"
"              In  addition to the other conditions, consider ECONNREFUSED as a\n"
"              transient error too for --retry. This option  is  used  together\n"
"              with --retry.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
, stdout);
 fputs(
"       --retry-delay <seconds>\n"
"              Make  curl  sleep  this  amount of time before each retry when a\n"
"              transfer has failed with a transient error (it changes  the  de-\n"
"              fault  backoff  time  algorithm between retries). This option is\n"
"              only interesting if --retry is also used. Setting this delay  to\n"
"              zero will make curl use the default backoff time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.12.3.\n"
"\n"
"       --retry-max-time <seconds>\n"
"              The  retry timer is reset before the first transfer attempt. Re-\n"
"              tries will be done as usual (see --retry) as long as  the  timer\n"
"              hasn't reached this given limit. Notice that if the timer hasn't\n"
"              reached the limit, the request will be made and  while  perform-\n"
"              ing,  it may take longer than this given time period. To limit a\n"
, stdout);
 fputs(
"              single request's maximum time, use -m, --max-time.  Set this op-\n"
"              tion to zero to not timeout retries.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.12.3.\n"
"\n"
"       --retry <num>\n"
"              If  a  transient  error is returned when curl tries to perform a\n"
"              transfer, it will retry this number of times before  giving  up.\n"
, stdout);
 fputs(
"              Setting  the  number to 0 makes curl do no retries (which is the\n"
"              default). Transient error means either: a timeout,  an  FTP  4xx\n"
"              response code or an HTTP 408, 429 or 5xx response code.\n"
"\n"
"              When  curl  is about to retry a transfer, it will first wait one\n"
"              second and then for all forthcoming retries it will  double  the\n"
"              waiting  time until it reaches 10 minutes which then will be the\n"
, stdout);
 fputs(
"              delay between the rest of the retries.  By  using  --retry-delay\n"
"              you   disable  this  exponential  backoff  algorithm.  See  also\n"
"              --retry-max-time to limit the total time allowed for retries.\n"
"\n"
"              Since curl 7.66.0, curl will comply with  the  Retry-After:  re-\n"
"              sponse  header if one was present to know when to issue the next\n"
"              retry.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.12.3.\n"
"\n"
"       --sasl-authzid <identity>\n"
"              Use this authorisation identity (authzid), during SASL PLAIN au-\n"
"              thentication,  in addition to the authentication identity (auth-\n"
"              cid) as specified by -u, --user.\n"
"\n"
"              If the option isn't specified, the server will  derive  the  au-\n"
"              thzid  from  the authcid, but if specified, and depending on the\n"
, stdout);
 fputs(
"              server implementation, it may be used to access  another  user's\n"
"              inbox,  that  the  user  has been granted access to, or a shared\n"
"              mailbox for example.\n"
"\n"
"              Added in 7.66.0.\n"
"\n"
"       --sasl-ir\n"
"              Enable initial response in SASL authentication.\n"
"\n"
"              Added in 7.31.0.\n"
"\n"
"       --service-name <name>\n"
"              This option allows you to change the service name for SPNEGO.\n"
"\n"
, stdout);
 fputs(
"              Examples:   --negotiate   --service-name   sockd    would    use\n"
"              sockd/server-name.\n"
"\n"
"              Added in 7.43.0.\n"
"       -S, --show-error\n"
"              When used with -s, --silent, it makes curl show an error message\n"
"              if it fails.\n"
"\n"
"              See also --no-progress-meter.\n"
"\n"
"       -s, --silent\n"
"              Silent or quiet mode. Don't show progress meter  or  error  mes-\n"
"              sages.   Makes  Curl mute. It will still output the data you ask\n"
, stdout);
 fputs(
"              for, potentially even to the terminal/stdout unless you redirect\n"
"              it.\n"
"\n"
"              Use  -S,  --show-error  in  addition  to  this option to disable\n"
"              progress meter but still show error messages.\n"
"\n"
"              See also -v, --verbose, --stderr and --no-progress-meter.\n"
"\n"
"       --socks4 <host[:port]>\n"
"              Use the specified SOCKS4 proxy. If the port number is not speci-\n"
"              fied, it is assumed at port 1080.\n"
"\n"
, stdout);
 fputs(
"              This  option  overrides any previous use of -x, --proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks4 proxy with -x, --proxy using a socks4:// protocol prefix.\n"
"              Since 7.52.0, --preproxy can be used to specify a SOCKS proxy at\n"
"              the same time -x, --proxy is used with an HTTP/HTTPS  proxy.  In\n"
, stdout);
 fputs(
"              such a case curl first connects to the SOCKS proxy and then con-\n"
"              nects (through SOCKS) to the HTTP or HTTPS proxy.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.15.2.\n"
"\n"
"       --socks4a <host[:port]>\n"
"              Use the specified SOCKS4a proxy. If the port number is not spec-\n"
"              ified, it is assumed at port 1080.\n"
"\n"
"              This  option  overrides any previous use of -x, --proxy, as they\n"
, stdout);
 fputs(
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks4a  proxy with -x, --proxy using a socks4a:// protocol pre-\n"
"              fix.\n"
"\n"
"              Since 7.52.0, --preproxy can be used to specify a SOCKS proxy at\n"
"              the  same  time -x, --proxy is used with an HTTP/HTTPS proxy. In\n"
"              such a case curl first connects to the SOCKS proxy and then con-\n"
, stdout);
 fputs(
"              nects (through SOCKS) to the HTTP or HTTPS proxy.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.18.0.\n"
"\n"
"       --socks5-basic\n"
"              Tells curl to use username/password authentication when connect-\n"
"              ing to a SOCKS5 proxy.  The username/password authentication  is\n"
"              enabled  by  default.   Use --socks5-gssapi to force GSS-API au-\n"
"              thentication to SOCKS5 proxies.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.55.0.\n"
"\n"
"       --socks5-gssapi-nec\n"
"              As part of the GSS-API negotiation a protection mode is  negoti-\n"
"              ated.  RFC  1961 says in section 4.3/4.4 it should be protected,\n"
"              but the NEC  reference  implementation  does  not.   The  option\n"
"              --socks5-gssapi-nec  allows the unprotected exchange of the pro-\n"
"              tection mode negotiation.\n"
"\n"
"              Added in 7.19.4.\n"
"\n"
"       --socks5-gssapi-service <name>\n"
, stdout);
 fputs(
"              The default service name for a socks server is rcmd/server-fqdn.\n"
"              This option allows you to change it.\n"
"\n"
"              Examples:   --socks5  proxy-name  --socks5-gssapi-service  sockd\n"
"              would use sockd/proxy-name --socks5 proxy-name  --socks5-gssapi-\n"
"              service  sockd/real-name  would  use  sockd/real-name  for cases\n"
"              where the proxy-name does not match the principal name.\n"
"\n"
"              Added in 7.19.4.\n"
"\n"
"       --socks5-gssapi\n"
, stdout);
 fputs(
"              Tells curl to use GSS-API authentication when  connecting  to  a\n"
"              SOCKS5  proxy.  The GSS-API authentication is enabled by default\n"
"              (if curl is compiled with GSS-API support).  Use  --socks5-basic\n"
"              to force username/password authentication to SOCKS5 proxies.\n"
"\n"
"              Added in 7.55.0.\n"
"\n"
"       --socks5-hostname <host[:port]>\n"
"              Use  the  specified  SOCKS5 proxy (and let the proxy resolve the\n"
, stdout);
 fputs(
"              host name). If the port number is not specified, it  is  assumed\n"
"              at port 1080.\n"
"\n"
"              This  option  overrides any previous use of -x, --proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks5 hostname proxy with -x, --proxy using a socks5h:// proto-\n"
"              col prefix.\n"
"\n"
"              Since 7.52.0, --preproxy can be used to specify a SOCKS proxy at\n"
, stdout);
 fputs(
"              the  same  time -x, --proxy is used with an HTTP/HTTPS proxy. In\n"
"              such a case curl first connects to the SOCKS proxy and then con-\n"
"              nects (through SOCKS) to the HTTP or HTTPS proxy.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.18.0.\n"
"\n"
"       --socks5 <host[:port]>\n"
"              Use  the  specified SOCKS5 proxy - but resolve the host name lo-\n"
, stdout);
 fputs(
"              cally. If the port number is not specified,  it  is  assumed  at\n"
"              port 1080.\n"
"\n"
"              This  option  overrides any previous use of -x, --proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              Since 7.21.7, this option is superfluous since you can specify a\n"
"              socks5 proxy with -x, --proxy using a socks5:// protocol prefix.\n"
"              Since 7.52.0, --preproxy can be used to specify a SOCKS proxy at\n"
, stdout);
 fputs(
"              the same time -x, --proxy is used with an HTTP/HTTPS  proxy.  In\n"
"              such a case curl first connects to the SOCKS proxy and then con-\n"
"              nects (through SOCKS) to the HTTP or HTTPS proxy.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              This option (as well as --socks4) does not work with IPV6,  FTPS\n"
"              or LDAP.\n"
"\n"
"              Added in 7.18.0.\n"
"\n"
"       -Y, --speed-limit <speed>\n"
, stdout);
 fputs(
"              If a download is slower than this given speed (in bytes per sec-\n"
"              ond) for speed-time seconds it gets aborted. speed-time  is  set\n"
"              with -y, --speed-time and is 30 if not set.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -y, --speed-time <seconds>\n"
"              If a download is slower than speed-limit bytes per second during\n"
"              a speed-time period, the download gets aborted. If speed-time is\n"
, stdout);
 fputs(
"              used,  the  default  speed-limit  will  be 1 unless set with -Y,\n"
"              --speed-limit.\n"
"\n"
"              This option controls transfers and thus  will  not  affect  slow\n"
"              connects  etc.  If this is a concern for you, try the --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --ssl-allow-beast\n"
"              This option tells curl to not work around a security flaw in the\n"
, stdout);
 fputs(
"              SSL3  and TLS1.0 protocols known as BEAST.  If this option isn't\n"
"              used, the SSL layer may use workarounds known to cause  interop-\n"
"              erability problems with some older SSL implementations. WARNING:\n"
"              this option loosens the SSL security, and by using this flag you\n"
"              ask for exactly that.\n"
"\n"
"              Added in 7.25.0.\n"
"\n"
"       --ssl-no-revoke\n"
"              (Schannel) This option tells curl to disable certificate revoca-\n"
, stdout);
 fputs(
"              tion checks.  WARNING: this option loosens the SSL security, and\n"
"              by using this flag you ask for exactly that.\n"
"\n"
"              Added in 7.44.0.\n"
"\n"
"       --ssl-reqd\n"
"              (FTP IMAP POP3 SMTP) Require SSL/TLS for the connection.  Termi-\n"
"              nates the connection if the server doesn't support SSL/TLS.\n"
"\n"
"              This option was formerly known as --ftp-ssl-reqd.\n"
"\n"
"              Added in 7.20.0.\n"
"\n"
"       --ssl-revoke-best-effort\n"
, stdout);
 fputs(
"              (Schannel) This option tells curl to ignore certificate  revoca-\n"
"              tion checks when they failed due to missing/offline distribution\n"
"              points for the revocation check lists.\n"
"\n"
"              Added in 7.70.0.\n"
"\n"
"       --ssl  (FTP IMAP POP3 SMTP) Try to use SSL/TLS for the connection.  Re-\n"
"              verts  to  a non-secure connection if the server doesn't support\n"
"              SSL/TLS.  See also --ftp-ssl-control and --ssl-reqd for  differ-\n"
, stdout);
 fputs(
"              ent levels of encryption required.\n"
"\n"
"              This  option  was formerly known as --ftp-ssl (Added in 7.11.0).\n"
"              That option name can still be used but will be removed in a  fu-\n"
"              ture version.\n"
"\n"
"              Added in 7.20.0.\n"
"\n"
"       -2, --sslv2\n"
"              (SSL)  Forces  curl to use SSL version 2 when negotiating with a\n"
"              remote SSL server. Sometimes curl is built  without  SSLv2  sup-\n"
, stdout);
 fputs(
"              port. SSLv2 is widely considered insecure (see RFC 6176).\n"
"\n"
"              See  also  --http1.1  and --http2. -2, --sslv2 requires that the\n"
"              underlying libcurl was built to support TLS. This  option  over-\n"
"              rides -3, --sslv3 and -1, --tlsv1 and --tlsv1.1 and --tlsv1.2.\n"
"\n"
"       -3, --sslv3\n"
"              (SSL)  Forces  curl to use SSL version 3 when negotiating with a\n"
"              remote SSL server. Sometimes curl is built  without  SSLv3  sup-\n"
, stdout);
 fputs(
"              port. SSLv3 is widely considered insecure (see RFC 7568).\n"
"\n"
"              See  also  --http1.1  and --http2. -3, --sslv3 requires that the\n"
"              underlying libcurl was built to support TLS. This  option  over-\n"
"              rides -2, --sslv2 and -1, --tlsv1 and --tlsv1.1 and --tlsv1.2.\n"
"\n"
"       --stderr\n"
"              Redirect  all writes to stderr to the specified file instead. If\n"
"              the file name is a plain '-', it is instead written to stdout.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"              See also -v, --verbose and -s, --silent.\n"
"\n"
"       --styled-output\n"
"              Enables the automatic use of bold font styles when writing  HTTP\n"
"              headers  to  the terminal. Use --no-styled-output to switch them\n"
"              off.\n"
"\n"
"              Added in 7.61.0.\n"
"\n"
"       --suppress-connect-headers\n"
"              When -p, --proxytunnel is used and a  CONNECT  request  is  made\n"
, stdout);
 fputs(
"              don't  output  proxy  CONNECT  response  headers. This option is\n"
"              meant to be used with -D, --dump-header or -i,  --include  which\n"
"              are  used  to show protocol headers in the output. It has no ef-\n"
"              fect on debug options such as -v, --verbose or --trace,  or  any\n"
"              statistics.\n"
"\n"
"              See also -D, --dump-header, -i, --include and -p, --proxytunnel.\n"
"\n"
"       --tcp-fastopen\n"
"              Enable use of TCP Fast Open (RFC7413).\n"
"\n"
, stdout);
 fputs(
"              Added in 7.49.0.\n"
"\n"
"       --tcp-nodelay\n"
"              Turn  on the TCP_NODELAY option. See the curl_easy_setopt(3) man\n"
"              page for details about this option.\n"
"\n"
"              Since 7.50.2, curl sets this option by default and you  need  to\n"
"              explicitly switch it off if you don't want it on.\n"
"\n"
"              Added in 7.11.2.\n"
"\n"
"       -t, --telnet-option <opt=val>\n"
"              Pass options to the telnet protocol. Supported options are:\n"
"\n"
, stdout);
 fputs(
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       --tftp-blksize <value>\n"
"              (TFTP) Set TFTP BLKSIZE option (must be >512). This is the block\n"
"              size that curl will try to use when transferring data to or from\n"
"              a TFTP server. By default 512 bytes will be used.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"              Added in 7.20.0.\n"
"\n"
"       --tftp-no-options\n"
"              (TFTP) Tells curl not to send TFTP options requests.\n"
"\n"
"              This  option  improves  interop with some legacy servers that do\n"
"              not acknowledge or properly implement TFTP  options.  When  this\n"
"              option is used --tftp-blksize is ignored.\n"
"\n"
"              Added in 7.48.0.\n"
"\n"
"       -z, --time-cond <time>\n"
, stdout);
 fputs(
"              (HTTP  FTP) Request a file that has been modified later than the\n"
"              given time and date, or one that has been modified  before  that\n"
"              time.  The <date expression> can be all sorts of date strings or\n"
"              if it doesn't match any internal ones, it is taken as a filename\n"
"              and  tries  to get the modification date (mtime) from <file> in-\n"
"              stead. See the curl_getdate(3) man pages for date expression de-\n"
"              tails.\n"
"\n"
, stdout);
 fputs(
"              Start the date expression with a dash (-) to make it request for\n"
"              a document that is older than the given date/time, default is  a\n"
"              document that is newer than the specified date/time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --tls-max <VERSION>\n"
"              (SSL) VERSION defines maximum supported TLS version. The minimum\n"
"              acceptable version  is  set  by  tlsv1.0,  tlsv1.1,  tlsv1.2  or\n"
, stdout);
 fputs(
"              tlsv1.3.\n"
"\n"
"              If  the  connection  is done without TLS, this option has no ef-\n"
"              fect. This includes QUIC-using (HTTP/3) transfers.\n"
"\n"
"              default\n"
"                     Use up to recommended TLS version.\n"
"\n"
"              1.0    Use up to TLSv1.0.\n"
"              1.1    Use up to TLSv1.1.\n"
"              1.2    Use up to TLSv1.2.\n"
"              1.3    Use up to TLSv1.3.\n"
"\n"
"       See also --tlsv1.0, --tlsv1.1, --tlsv1.2 and --tlsv1.3.  --tls-max  re-\n"
, stdout);
 fputs(
"       quires  that  the underlying libcurl was built to support TLS. Added in\n"
"       7.54.0.\n"
"\n"
"       --tls13-ciphers <ciphersuite list>\n"
"              (TLS) Specifies which cipher suites to use in the connection  if\n"
"              it  negotiates  TLS 1.3. The list of ciphers suites must specify\n"
"              valid ciphers. Read up on TLS 1.3 cipher suite details  on  this\n"
"              URL:\n"
"\n"
"               https://curl.se/docs/ssl-ciphers.html\n"
"\n"
, stdout);
 fputs(
"              This  option  is  currently  used only when curl is built to use\n"
"              OpenSSL 1.1.1 or later. If you are using a different SSL backend\n"
"              you can try setting TLS 1.3 cipher suites by using the --ciphers\n"
"              option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --tlsauthtype <type>\n"
"              Set TLS authentication type. Currently, the only  supported  op-\n"
, stdout);
 fputs(
"              tion  is  \"SRP\",  for  TLS-SRP  (RFC  5054).  If  --tlsuser  and\n"
"              --tlspassword are specified but --tlsauthtype is not, then  this\n"
"              option  defaults to \"SRP\".  This option works only if the under-\n"
"              lying libcurl is built  with  TLS-SRP  support,  which  requires\n"
"              OpenSSL or GnuTLS with TLS-SRP support.\n"
"\n"
"              Added in 7.21.4.\n"
"\n"
"       --tlspassword\n"
, stdout);
 fputs(
"              Set  password  for use with the TLS authentication method speci-\n"
"              fied with --tlsauthtype. Requires that --tlsuser also be set.\n"
"\n"
"              This doesn't work with TLS 1.3.\n"
"\n"
"              Added in 7.21.4.\n"
"       --tlsuser <name>\n"
"              Set username for use with the TLS authentication  method  speci-\n"
"              fied  with  --tlsauthtype.  Requires  that --tlspassword also is\n"
"              set.\n"
"\n"
"              This doesn't work with TLS 1.3.\n"
"\n"
, stdout);
 fputs(
"              Added in 7.21.4.\n"
"\n"
"       --tlsv1.0\n"
"              (TLS) Forces curl to use TLS version 1.0 or later when  connect-\n"
"              ing to a remote TLS server.\n"
"\n"
"              In  old  versions  of  curl  this option was documented to allow\n"
"              _only_ TLS 1.0, but behavior was inconsistent depending  on  the\n"
"              TLS library. Use --tls-max if you want to set a maximum TLS ver-\n"
"              sion.\n"
"\n"
"              Added in 7.34.0.\n"
"\n"
"       --tlsv1.1\n"
, stdout);
 fputs(
"              (TLS) Forces curl to use TLS version 1.1 or later when  connect-\n"
"              ing to a remote TLS server.\n"
"\n"
"              In  old  versions  of  curl  this option was documented to allow\n"
"              _only_ TLS 1.1, but behavior was inconsistent depending  on  the\n"
"              TLS library. Use --tls-max if you want to set a maximum TLS ver-\n"
"              sion.\n"
"\n"
"              Added in 7.34.0.\n"
"\n"
"       --tlsv1.2\n"
, stdout);
 fputs(
"              (TLS) Forces curl to use TLS version 1.2 or later when  connect-\n"
"              ing to a remote TLS server.\n"
"\n"
"              In  old  versions  of  curl  this option was documented to allow\n"
"              _only_ TLS 1.2, but behavior was inconsistent depending  on  the\n"
"              TLS library. Use --tls-max if you want to set a maximum TLS ver-\n"
"              sion.\n"
"\n"
"              Added in 7.34.0.\n"
"\n"
"       --tlsv1.3\n"
, stdout);
 fputs(
"              (TLS) Forces curl to use TLS version 1.3 or later when  connect-\n"
"              ing to a remote TLS server.\n"
"\n"
"              If  the  connection  is done without TLS, this option has no ef-\n"
"              fect. This includes QUIC-using (HTTP/3) transfers.\n"
"\n"
"              Note that TLS 1.3 is not supported by all TLS backends.\n"
"\n"
"              Added in 7.52.0.\n"
"\n"
"       -1, --tlsv1\n"
"              (SSL) Tells curl to use at least TLS version 1.x when  negotiat-\n"
, stdout);
 fputs(
"              ing  with  a  remote  TLS  server. That means TLS version 1.0 or\n"
"              higher\n"
"\n"
"              See also --http1.1 and --http2. -1, --tlsv1  requires  that  the\n"
"              underlying  libcurl  was built to support TLS. This option over-\n"
"              rides --tlsv1.1 and --tlsv1.2 and --tlsv1.3.\n"
"\n"
"       --tr-encoding\n"
"              (HTTP) Request a compressed Transfer-Encoding response using one\n"
"              of  the  algorithms curl supports, and uncompress the data while\n"
, stdout);
 fputs(
"              receiving it.\n"
"\n"
"              Added in 7.21.6.\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables a full trace dump of all incoming and outgoing data, in-\n"
"              cluding  descriptive  information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the hex part and\n"
"              only  shows  the ASCII part of the dump. It makes smaller output\n"
, stdout);
 fputs(
"              that might be easier to read for untrained humans.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              This option overrides --trace and -v, --verbose.\n"
"\n"
"       --trace-time\n"
"              Prepends a time stamp to each trace or verbose  line  that  curl\n"
"              displays.\n"
"\n"
"              Added in 7.14.0.\n"
"\n"
"       --trace <file>\n"
"              Enables a full trace dump of all incoming and outgoing data, in-\n"
, stdout);
 fputs(
"              cluding descriptive information, to the given output  file.  Use\n"
"              \"-\"  as  filename  to have the output sent to stdout. Use \"%\" as\n"
"              filename to have the output sent to stderr.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"              This option overrides -v, --verbose and --trace-ascii.\n"
"\n"
"       --unix-socket <path>\n"
"              (HTTP) Connect through this Unix domain socket, instead of using\n"
, stdout);
 fputs(
"              the network.\n"
"\n"
"              Added in 7.40.0.\n"
"\n"
"       -T, --upload-file <file>\n"
"              This  transfers  the  specified local file to the remote URL. If\n"
"              there is no file part in the specified URL, curl will append the\n"
"              local file name. NOTE that you must use a trailing / on the last\n"
"              directory to really prove to Curl that there is no file name  or\n"
"              curl will think that your last directory name is the remote file\n"
, stdout);
 fputs(
"              name to use. That will most likely cause the upload operation to\n"
"              fail. If this is used on an HTTP(S) server, the PUT command will\n"
"              be used.\n"
"\n"
"              Use the file name \"-\" (a single dash) to use stdin instead of  a\n"
"              given  file.   Alternately,  the file name \".\" (a single period)\n"
"              may be specified instead of \"-\" to  use  stdin  in  non-blocking\n"
"              mode  to  allow  reading  server output while stdin is being up-\n"
, stdout);
 fputs(
"              loaded.\n"
"\n"
"              You can specify one -T, --upload-file for each URL on  the  com-\n"
"              mand  line.  Each -T, --upload-file + URL pair specifies what to\n"
"              upload and to where. curl also supports \"globbing\"  of  the  -T,\n"
"              --upload-file  argument,  meaning  that  you can upload multiple\n"
"              files to a single URL by using the same URL globbing style  sup-\n"
"              ported in the URL, like this:\n"
"\n"
, stdout);
 fputs(
"               curl --upload-file \"{file1,file2}\" http://www.example.com\n"
"\n"
"              or even\n"
"\n"
"               curl -T \"img[1-1000].png\" ftp://ftp.example.com/upload/\n"
"\n"
"              When  uploading  to an SMTP server: the uploaded data is assumed\n"
"              to be RFC 5322 formatted. It has to feature the necessary set of\n"
"              headers  and  mail  body formatted correctly by the user as curl\n"
"              will not transcode nor encode it further in any way.\n"
"\n"
"       --url <url>\n"
, stdout);
 fputs(
"              Specify a URL to fetch. This option is  mostly  handy  when  you\n"
"              want to specify URL(s) in a config file.\n"
"\n"
"              If  the given URL is missing a scheme name (such as \"http://\" or\n"
"              \"ftp://\" etc) then curl will make a guess based on the host.  If\n"
"              the  outermost  sub-domain  name  matches DICT, FTP, IMAP, LDAP,\n"
"              POP3 or SMTP then that protocol will  be  used,  otherwise  HTTP\n"
, stdout);
 fputs(
"              will be used. Since 7.45.0 guessing can be disabled by setting a\n"
"              default protocol, see --proto-default for details.\n"
"\n"
"              This option may be used any number of times.  To  control  where\n"
"              this  URL  is written, use the -o, --output or the -O, --remote-\n"
"              name options.\n"
"\n"
"              Warning: On Windows, particular file://  accesses  can  be  con-\n"
"              verted to network accesses by the operating system. Beware!\n"
"\n"
, stdout);
 fputs(
"       -B, --use-ascii\n"
"              (FTP  LDAP) Enable ASCII transfer. For FTP, this can also be en-\n"
"              forced by using a URL that  ends  with  \";type=A\".  This  option\n"
"              causes data sent to stdout to be in text mode for win32 systems.\n"
"\n"
"       -A, --user-agent <name>\n"
"              (HTTP) Specify the User-Agent string to send to the HTTP server.\n"
"              To encode blanks in the string, surround the string with  single\n"
, stdout);
 fputs(
"              quote  marks.  This header can also be set with the -H, --header\n"
"              or the --proxy-header options.\n"
"\n"
"              If you give an empty argument to -A, --user-agent (\"\"), it  will\n"
"              remove  the  header completely from the request. If you prefer a\n"
"              blank header, you can set it to a single space (\" \").\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -u, --user <user:password>\n"
, stdout);
 fputs(
"              Specify the user name and password to use for server authentica-\n"
"              tion. Overrides -n, --netrc and --netrc-optional.\n"
"\n"
"              If  you  simply  specify  the  user name, curl will prompt for a\n"
"              password.\n"
"\n"
"              The user name and passwords are split up  on  the  first  colon,\n"
"              which  makes  it impossible to use a colon in the user name with\n"
"              this option. The password can, still.\n"
"\n"
, stdout);
 fputs(
"              On systems where it works, curl will hide the given option argu-\n"
"              ment  from  process listings. This is not enough to protect cre-\n"
"              dentials from possibly getting seen by other users on  the  same\n"
"              system  as  they will still be visible for a brief moment before\n"
"              cleared. Such sensitive data should be retrieved from a file in-\n"
"              stead or similar and never used in clear text in a command line.\n"
, stdout);
 fputs(
"              When  using  Kerberos  V5 with a Windows based server you should\n"
"              include the Windows domain name in the user name, in  order  for\n"
"              the  server  to  successfully  obtain  a Kerberos Ticket. If you\n"
"              don't then the initial authentication handshake may fail.\n"
"\n"
"              When using NTLM, the user name can be specified  simply  as  the\n"
"              user  name,  without the domain, if there is a single domain and\n"
, stdout);
 fputs(
"              forest in your setup for example.\n"
"\n"
"              To specify the domain name use either Down-Level Logon  Name  or\n"
"              UPN (User Principal Name) formats. For example, EXAMPLE\\user and\n"
"              user@example.com respectively.\n"
"\n"
"              If you use a Windows SSPI-enabled curl binary and  perform  Ker-\n"
"              beros  V5, Negotiate, NTLM or Digest authentication then you can\n"
"              tell curl to select the user name and password from  your  envi-\n"
, stdout);
 fputs(
"              ronment by specifying a single colon with this option: \"-u :\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -v, --verbose\n"
"              Makes  curl  verbose  during the operation. Useful for debugging\n"
"              and seeing what's going on \"under the  hood\".  A  line  starting\n"
"              with  '>'  means  \"header  data\" sent by curl, '<' means \"header\n"
"              data\" received by curl that is hidden in  normal  cases,  and  a\n"
, stdout);
 fputs(
"              line starting with '*' means additional info provided by curl.\n"
"\n"
"              If you only want HTTP headers in the output, -i, --include might\n"
"              be the option you're looking for.\n"
"\n"
"              If you think this option still doesn't give you enough  details,\n"
"              consider using --trace or --trace-ascii instead.\n"
"\n"
"              Use -s, --silent to make curl really quiet.\n"
"\n"
"              See  also  -i,  --include.  This  option  overrides  --trace and\n"
, stdout);
 fputs(
"              --trace-ascii.\n"
"\n"
"       -V, --version\n"
"              Displays information about curl and the libcurl version it uses.\n"
"              The first line includes the full version of  curl,  libcurl  and\n"
"              other 3rd party libraries linked with the executable.\n"
"\n"
"              The  second  line (starts with \"Protocols:\") shows all protocols\n"
"              that libcurl reports to support.\n"
"\n"
"              The third line (starts with \"Features:\") shows specific features\n"
, stdout);
 fputs(
"              libcurl reports to offer. Available features include:\n"
"\n"
"              alt-svc\n"
"                     Support for the Alt-Svc: header is provided.\n"
"\n"
"              AsynchDNS\n"
"                     This  curl  uses asynchronous name resolves. Asynchronous\n"
"                     name resolves can be done using either the c-ares or  the\n"
"                     threaded resolver backends.\n"
"\n"
"              brotli Support for automatic brotli compression over HTTP(S).\n"
"\n"
"              CharConv\n"
, stdout);
 fputs(
"                     curl was built with support for character set conversions\n"
"                     (like EBCDIC)\n"
"\n"
"              Debug  This curl uses a libcurl built with Debug.  This  enables\n"
"                     more  error-tracking  and memory debugging etc. For curl-\n"
"                     developers only!\n"
"\n"
"              GSS-API\n"
"                     GSS-API is supported.\n"
"\n"
"              HSTS   HSTS support is present.\n"
"\n"
"              HTTP2  HTTP/2 support has been built-in.\n"
, stdout);
 fputs(
"              HTTP3  HTTP/3 support has been built-in.\n"
"\n"
"              HTTPS-proxy\n"
"                     This curl is built to support HTTPS proxy.\n"
"\n"
"              IDN    This curl supports IDN - international domain names.\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for FTP is supported.\n"
"\n"
"              Largefile\n"
"                     This curl supports transfers of large files, files larger\n"
"                     than 2GB.\n"
"\n"
, stdout);
 fputs(
"              libz   Automatic  decompression of compressed files over HTTP is\n"
"                     supported.\n"
"\n"
"              Metalink\n"
"                     This curl supports Metalink\n"
"\n"
"              MultiSSL\n"
"                     This curl supports multiple TLS backends.\n"
"\n"
"              NTLM   NTLM authentication is supported.\n"
"              NTLM   NTLM authentication is supported.\n"
"\n"
"              PSL    PSL is short for Public Suffix List and means  that  this\n"
, stdout);
 fputs(
"                     curl  has  been  built  with knowledge about \"public suf-\n"
"                     fixes\".\n"
"\n"
"              SPNEGO SPNEGO authentication is supported.\n"
"\n"
"              SSL    SSL versions of various protocols are supported, such  as\n"
"                     HTTPS, FTPS, POP3S and so on.\n"
"\n"
"              SSPI   SSPI is supported.\n"
"\n"
"              TLS-SRP\n"
"                     SRP  (Secure Remote Password) authentication is supported\n"
"                     for TLS.\n"
"\n"
"              UnixSockets\n"
, stdout);
 fputs(
"                     Unix sockets support is provided.\n"
"\n"
"       -w, --write-out <format>\n"
"              Make curl display information on stdout after a completed trans-\n"
"              fer.  The  format  is a string that may contain plain text mixed\n"
"              with any number of variables. The format can be specified  as  a\n"
"              literal  \"string\",  or  you can have curl read the format from a\n"
"              file with \"@filename\" and to tell curl to read the  format  from\n"
, stdout);
 fputs(
"              stdin you write \"@-\".\n"
"\n"
"              The  variables  present in the output format will be substituted\n"
"              by the value or text that curl thinks fit, as  described  below.\n"
"              All  variables are specified as %{variable_name} and to output a\n"
"              normal % you just write them as %%. You can output a newline  by\n"
"              using \\n, a carriage return with \\r and a tab space with \\t.\n"
"\n"
, stdout);
 fputs(
"              The  output  will be written to standard output, but this can be\n"
"              switched to standard error by using %{stderr}.\n"
"\n"
"              NOTE: The %-symbol is a special symbol in the win32-environment,\n"
"              where  all  occurrences of % must be doubled when using this op-\n"
"              tion.\n"
"\n"
"              The variables available are:\n"
"\n"
"              content_type   The Content-Type of the  requested  document,  if\n"
"                             there was any.\n"
"\n"
, stdout);
 fputs(
"              errormsg       The error message. (Added in 7.75.0)\n"
"\n"
"              exitcode       The numerical exitcode. (Added in 7.75.0)\n"
"\n"
"              filename_effective\n"
"                             The  ultimate  filename  that curl writes out to.\n"
"                             This is only meaningful if curl is told to  write\n"
"                             to  a  file  with  the  -O,  --remote-name or -o,\n"
"                             --output option. It's most useful in  combination\n"
, stdout);
 fputs(
"                             with  the -J, --remote-header-name option. (Added\n"
"                             in 7.26.0)\n"
"\n"
"              ftp_entry_path The initial path curl ended up in when logging on\n"
"                             to the remote FTP server. (Added in 7.15.4)\n"
"\n"
"              http_code      The numerical response code that was found in the\n"
"                             last retrieved HTTP(S)  or  FTP(s)  transfer.  In\n"
, stdout);
 fputs(
"                             7.18.2  the alias response_code was added to show\n"
"                             the same info.\n"
"\n"
"              http_connect   The numerical code that was found in the last re-\n"
"                             sponse  (from a proxy) to a curl CONNECT request.\n"
"                             (Added in 7.12.4)\n"
"\n"
"              http_version   The  http  version  that  was  effectively  used.\n"
"                             (Added in 7.50.0)\n"
"\n"
, stdout);
 fputs(
"              json           A JSON object with all available keys.\n"
"\n"
"              local_ip       The  IP  address of the local end of the most re-\n"
"                             cently done connection - can be  either  IPv4  or\n"
"                             IPv6 (Added in 7.29.0)\n"
"\n"
"              local_port     The  local  port number of the most recently done\n"
"                             connection (Added in 7.29.0)\n"
"\n"
"              method         The http method used in the most recent HTTP  re-\n"
, stdout);
 fputs(
"                             quest (Added in 7.72.0)\n"
"\n"
"              num_connects   Number  of new connects made in the recent trans-\n"
"                             fer. (Added in 7.12.3)\n"
"\n"
"              num_headers    The number of response headers in the most recent\n"
"                             request (restarted at each\n"
"                              redirect).  Note  that  the status line IS NOT a\n"
"                             header. (Added in 7.73.0)\n"
"\n"
, stdout);
 fputs(
"              num_redirects  Number of redirects that were followed in the re-\n"
"                             quest. (Added in 7.12.3)\n"
"\n"
"              onerror        The  rest  of  the  output  is  only shown if the\n"
"                             transfer returned  a  non-zero  error  (Added  in\n"
"                             7.75.0)\n"
"\n"
"              proxy_ssl_verify_result\n"
"                             The result of the HTTPS proxy's SSL peer certifi-\n"
, stdout);
 fputs(
"                             cate verification that was requested. 0 means the\n"
"                             verification was successful. (Added in 7.52.0)\n"
"\n"
"              redirect_url   When an HTTP request was made without -L, --loca-\n"
"                             tion to follow redirects (or when --max-redir  is\n"
"                             met),  this  variable  will show the actual URL a\n"
"                             redirect would have gone to. (Added in 7.18.2)\n"
"\n"
, stdout);
 fputs(
"              remote_ip      The remote IP address of the most  recently  done\n"
"                             connection - can be either IPv4 or IPv6 (Added in\n"
"                             7.29.0)\n"
"\n"
"              remote_port    The remote port number of the most recently  done\n"
"                             connection (Added in 7.29.0)\n"
"\n"
"              response_code  The numerical response code that was found in the\n"
"                             last transfer (formerly  known  as  \"http_code\").\n"
, stdout);
 fputs(
"                             (Added in 7.18.2)\n"
"\n"
"              scheme         The  URL  scheme (sometimes called protocol) that\n"
"                             was effectively used (Added in 7.52.0)\n"
"\n"
"              size_download  The total amount of bytes that were downloaded.\n"
"\n"
"              size_header    The total amount of bytes of the downloaded head-\n"
"                             ers.\n"
"\n"
"              size_request   The  total  amount of bytes that were sent in the\n"
, stdout);
 fputs(
"                             HTTP request.\n"
"\n"
"              size_upload    The total amount of bytes that were uploaded.\n"
"\n"
"              speed_download The average download speed that curl measured for\n"
"                             the complete download. Bytes per second.\n"
"\n"
"              speed_upload   The  average  upload speed that curl measured for\n"
"                             the complete upload. Bytes per second.\n"
"\n"
"              ssl_verify_result\n"
, stdout);
 fputs(
"                             The result of the SSL peer certificate  verifica-\n"
"                             tion that was requested. 0 means the verification\n"
"                             was successful. (Added in 7.19.0)\n"
"\n"
"              stderr         From this point on, the  -w,  --write-out  output\n"
"                             will  be  written  to  standard  error. (Added in\n"
"                             7.63.0)\n"
"\n"
"              stdout         From this point on, the  -w,  --write-out  output\n"
, stdout);
 fputs(
"                             will  be written to standard output.  This is the\n"
"                             default, but can be used  to  switch  back  after\n"
"                             switching to stderr.  (Added in 7.63.0)\n"
"\n"
"              time_appconnect\n"
"                             The  time, in seconds, it took from the start un-\n"
"                             til the SSL/SSH/etc connect/handshake to the  re-\n"
"                             mote host was completed. (Added in 7.19.0)\n"
"\n"
, stdout);
 fputs(
"              time_connect   The  time, in seconds, it took from the start un-\n"
"                             til the TCP connect to the remote host (or proxy)\n"
"                             was completed.\n"
"\n"
"              time_namelookup\n"
"                             The  time, in seconds, it took from the start un-\n"
"                             til the name resolving was completed.\n"
"\n"
"              time_pretransfer\n"
"                             The time, in seconds, it took from the start  un-\n"
, stdout);
 fputs(
"                             til  the  file  transfer was just about to begin.\n"
"                             This includes all pre-transfer commands and nego-\n"
"                             tiations that are specific to the particular pro-\n"
"                             tocol(s) involved.\n"
"\n"
"              time_redirect  The time, in seconds, it took for all redirection\n"
"                             steps including name lookup, connect, pretransfer\n"
, stdout);
 fputs(
"                             and transfer before  the  final  transaction  was\n"
"                             started.  time_redirect shows the complete execu-\n"
"                             tion time for multiple  redirections.  (Added  in\n"
"                             7.12.3)\n"
"\n"
"              time_starttransfer\n"
"                             The  time, in seconds, it took from the start un-\n"
"                             til the first byte was just about  to  be  trans-\n"
, stdout);
 fputs(
"                             ferred.  This  includes time_pretransfer and also\n"
"                             the time the server needed to calculate  the  re-\n"
"                             sult.\n"
"\n"
"              time_total     The  total time, in seconds, that the full opera-\n"
"                             tion lasted.\n"
"\n"
"              url            The URL that was fetched. (Added in 7.75.0)\n"
"\n"
"              urlnum         The URL index number of this transfer, 0-indexed.\n"
, stdout);
 fputs(
"                             (Added in 7.75.0)\n"
"\n"
"              url_effective  The URL that was fetched last. This is most mean-\n"
"                             ingful if you've told curl  to  follow  location:\n"
"                             headers.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --xattr\n"
"              When  saving  output  to a file, this option tells curl to store\n"
"              certain file metadata in extended  file  attributes.  Currently,\n"
, stdout);
 fputs(
"              the URL is stored in the xdg.origin.url attribute and, for HTTP,\n"
"              the content type is stored in the mime_type  attribute.  If  the\n"
"              file  system  does not support extended attributes, a warning is\n"
"              issued.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file, see -K, --config for details.\n"
"\n"
"ENVIRONMENT\n"
"       The environment variables can be specified in lower case or upper case.\n"
, stdout);
 fputs(
"       The lower case version has precedence. http_proxy is an exception as it\n"
"       is only available in lower case.\n"
"\n"
"       Using an environment variable to set the proxy has the same  effect  as\n"
"       using the -x, --proxy option.\n"
"\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets the proxy server to use for HTTP.\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets the proxy server to use for HTTPS.\n"
"\n"
"       [url-protocol]_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets  the proxy server to use for [url-protocol], where the pro-\n"
"              tocol is a protocol that curl supports and  as  specified  in  a\n"
"              URL. FTP, FTPS, POP3, IMAP, SMTP, LDAP etc.\n"
"\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
"              Sets  the  proxy  server to use if no protocol-specific proxy is\n"
"              set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts/domains>\n"
"              list of host names that shouldn't go through any proxy.  If  set\n"
, stdout);
 fputs(
"              to an asterisk '*' only, it matches all hosts. Each name in this\n"
"              list is matched as either a domain name which contains the host-\n"
"              name, or the hostname itself.\n"
"\n"
"              This  environment  variable  disables use of the proxy even when\n"
"              specified with the -x,  --proxy  option.  That  is  NO_PROXY=di-\n"
"              rect.example.com  curl  -x  http://proxy.example.com  http://di-\n"
, stdout);
 fputs(
"              rect.example.com  accesses  the   target   URL   directly,   and\n"
"              NO_PROXY=direct.example.com   curl  -x  http://proxy.example.com\n"
"              http://somewhere.example.com accesses the target URL through the\n"
"              proxy.\n"
"\n"
"              The  list  of  host  names  can also be include numerical IP ad-\n"
"              dresses, and IPv6 versions should then be given without  enclos-\n"
"              ing brackets.\n"
"\n"
, stdout);
 fputs(
"              IPv6  numerical  addresses are compared as strings, so they will\n"
"              only match if the representations are the  same:  \"::1\"  is  the\n"
"              same as \"::0:1\" but they don't match.\n"
"\n"
"       CURL_SSL_BACKEND <TLS backend>\n"
"              If  curl  was built with support for \"MultiSSL\", meaning that it\n"
"              has built-in support for more than one TLS backend,  this  envi-\n"
"              ronment  variable can be set to the case insensitive name of the\n"
, stdout);
 fputs(
"              particular backend to use when curl is invoked. Setting  a  name\n"
"              that  isn't a built-in alternative, will make curl stay with the\n"
"              default.\n"
"\n"
"       QLOGDIR <directory name>\n"
"              If curl was built with HTTP/3 support, setting this  environment\n"
"              variable  to  a  local directory will make curl produce qlogs in\n"
"              that directory, using file names  named  after  the  destination\n"
, stdout);
 fputs(
"              connection  id  (in  hex).  Do  note that these files can become\n"
"              rather large. Works with both QUIC backends.\n"
"\n"
"       SSLKEYLOGFILE <file name>\n"
"              If you set this environment variable to a file name,  curl  will\n"
"              store TLS secrets from its connections in that file when invoked\n"
"              to enable you to analyze the TLS traffic in real time using net-\n"
"              work analyzing tools such as Wireshark. This works with the fol-\n"
, stdout);
 fputs(
"              lowing TLS backends: OpenSSL, libressl, BoringSSL,  GnuTLS,  NSS\n"
"              and wolfSSL.\n"
"\n"
"PROXY PROTOCOL PREFIXES\n"
"       Since  curl  version  7.21.7,  the proxy string may be specified with a\n"
"       protocol:// prefix to specify alternative proxy protocols.\n"
"\n"
"       If no protocol is specified in  the  proxy  string  or  if  the  string\n"
"       doesn't  match  a  supported  one, the proxy will be treated as an HTTP\n"
"       proxy.\n"
"\n"
, stdout);
 fputs(
"       The supported proxy protocol prefixes are as follows:\n"
"\n"
"       http://\n"
"              Makes it use it as an HTTP proxy. The default if no scheme  pre-\n"
"              fix is used.\n"
"\n"
"       https://\n"
"              Makes it treated as an HTTPS proxy.\n"
"\n"
"       socks4://\n"
"              Makes it the equivalent of --socks4\n"
"\n"
"       socks4a://\n"
"              Makes it the equivalent of --socks4a\n"
"\n"
"       socks5://\n"
"              Makes it the equivalent of --socks5\n"
"\n"
"       socks5h://\n"
, stdout);
 fputs(
"              Makes it the equivalent of --socks5-hostname\n"
"\n"
"EXIT CODES\n"
"       There  are a bunch of different error codes and their corresponding er-\n"
"       ror messages that may appear during bad conditions. At the time of this\n"
"       writing, the exit codes are:\n"
"\n"
"       1      Unsupported protocol. This build of curl has no support for this\n"
"              protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformed. The syntax was not correct.\n"
"\n"
, stdout);
 fputs(
"       4      A feature or option that was needed to perform the  desired  re-\n"
"              quest  was not enabled or was explicitly disabled at build-time.\n"
"              To make curl able to do this, you probably need another build of\n"
"              libcurl!\n"
"\n"
"       5      Couldn't  resolve  proxy.  The given proxy host could not be re-\n"
"              solved.\n"
"\n"
"       6      Couldn't resolve host. The given remote host was not resolved.\n"
"\n"
"       7      Failed to connect to host.\n"
"\n"
, stdout);
 fputs(
"       8      Weird server reply. The server sent data curl couldn't parse.\n"
"\n"
"       9      FTP access denied. The server denied login or denied  access  to\n"
"              the  particular  resource or directory you wanted to reach. Most\n"
"              often you tried to change to a directory that doesn't  exist  on\n"
"              the server.\n"
"\n"
"       10     FTP  accept failed. While waiting for the server to connect back\n"
"              when an active FTP session is used, an error code was sent  over\n"
, stdout);
 fputs(
"              the control connection or similar.\n"
"\n"
"       11     FTP  weird PASS reply. Curl couldn't parse the reply sent to the\n"
"              PASS request.\n"
"\n"
"       12     During an active FTP session while waiting  for  the  server  to\n"
"              connect back to curl, the timeout expired.\n"
"\n"
"       13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the\n"
"              PASV request.\n"
"\n"
"       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the\n"
, stdout);
 fputs(
"              server sent.\n"
"\n"
"       15     FTP  can't  get host. Couldn't resolve the host IP we got in the\n"
"              227-line.\n"
"\n"
"       16     HTTP/2 error. A problem was detected in the HTTP2 framing layer.\n"
"              This is somewhat generic and can be one out of several problems,\n"
"              see the error message for details.\n"
"\n"
"       17     FTP couldn't set binary. Couldn't change transfer method to  bi-\n"
"              nary.\n"
"\n"
, stdout);
 fputs(
"       18     Partial file. Only a part of the file was transferred.\n"
"\n"
"       19     FTP  couldn't download/access the given file, the RETR (or simi-\n"
"              lar) command failed.\n"
"\n"
"       21     FTP quote error. A quote command returned error from the server.\n"
"       22     HTTP page not retrieved. The requested url was not found or  re-\n"
"              turned  another  error  with  the  HTTP  error code being 400 or\n"
"              above. This return code only appears if -f, --fail is used.\n"
"\n"
, stdout);
 fputs(
"       23     Write error. Curl couldn't write data to a local  filesystem  or\n"
"              similar.\n"
"\n"
"       25     FTP  couldn't  STOR  file. The server denied the STOR operation,\n"
"              used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request failed.\n"
"\n"
"       28     Operation timeout. The specified time-out period was reached ac-\n"
"              cording to the conditions.\n"
"\n"
, stdout);
 fputs(
"       30     FTP  PORT  failed.  The PORT command failed. Not all FTP servers\n"
"              support the PORT command, try doing a transfer  using  PASV  in-\n"
"              stead!\n"
"\n"
"       31     FTP  couldn't use REST. The REST command failed. This command is\n"
"              used for resumed FTP transfers.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't work.\n"
"\n"
"       34     HTTP post error. Internal post-request generation error.\n"
"\n"
, stdout);
 fputs(
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     Bad download resume. Couldn't continue an earlier aborted  down-\n"
"              load.\n"
"\n"
"       37     FILE couldn't read file. Failed to open the file. Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
"       41     Function not found. A required LDAP function was not found.\n"
"\n"
"       42     Aborted by callback. An application told curl to abort the oper-\n"
, stdout);
 fputs(
"              ation.\n"
"\n"
"       43     Internal error. A function was called with a bad parameter.\n"
"\n"
"       45     Interface error. A specified outgoing  interface  could  not  be\n"
"              used.\n"
"\n"
"       47     Too many redirects. When following redirects, curl hit the maxi-\n"
"              mum amount.\n"
"\n"
"       48     Unknown option specified to libcurl.  This  indicates  that  you\n"
"              passed  a weird option to curl that was passed on to libcurl and\n"
, stdout);
 fputs(
"              rejected. Read up in the manual!\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The peer's SSL certificate or SSH MD5 fingerprint was not OK.\n"
"\n"
"       52     The server didn't reply anything, which here  is  considered  an\n"
"              error.\n"
"\n"
"       53     SSL crypto engine not found.\n"
"\n"
"       54     Cannot set SSL crypto engine as default.\n"
"\n"
"       55     Failed sending network data.\n"
"\n"
"       56     Failure in receiving network data.\n"
"\n"
, stdout);
 fputs(
"       58     Problem with the local certificate.\n"
"\n"
"       59     Couldn't use specified SSL cipher.\n"
"\n"
"       60     Peer  certificate cannot be authenticated with known CA certifi-\n"
"              cates.\n"
"\n"
"       61     Unrecognized transfer encoding.\n"
"\n"
"       62     Invalid LDAP URL.\n"
"\n"
"       63     Maximum file size exceeded.\n"
"\n"
"       64     Requested FTP SSL level failed.\n"
"\n"
"       65     Sending the data requires a rewind that failed.\n"
"\n"
"       66     Failed to initialise SSL Engine.\n"
"\n"
, stdout);
 fputs(
"       67     The user name, password, or similar was not  accepted  and  curl\n"
"              failed to log in.\n"
"\n"
"       68     File not found on TFTP server.\n"
"\n"
"       69     Permission problem on TFTP server.\n"
"\n"
"       70     Out of disk space on TFTP server.\n"
"\n"
"       71     Illegal TFTP operation.\n"
"\n"
"       72     Unknown TFTP transfer ID.\n"
"\n"
"       73     File already exists (TFTP).\n"
"\n"
"       74     No such user (TFTP).\n"
"\n"
"       75     Character conversion failed.\n"
"\n"
, stdout);
 fputs(
"       76     Character conversion functions required.\n"
"\n"
"       77     Problem with reading the SSL CA cert (path? access rights?).\n"
"\n"
"       78     The resource referenced in the URL does not exist.\n"
"\n"
"       79     An unspecified error occurred during the SSH session.\n"
"\n"
"       80     Failed to shut down the SSL connection.\n"
"\n"
"       82     Could  not  load  CRL  file,  missing  or wrong format (added in\n"
"              7.19.0).\n"
"\n"
"       83     Issuer check failed (added in 7.19.0).\n"
"\n"
, stdout);
 fputs(
"       84     The FTP PRET command failed\n"
"\n"
"       85     RTSP: mismatch of CSeq numbers\n"
"\n"
"       86     RTSP: mismatch of Session Identifiers\n"
"\n"
"       87     unable to parse FTP file list\n"
"\n"
"       88     FTP chunk callback reported error\n"
"\n"
"       89     No connection available, the session will be queued\n"
"\n"
"       90     SSL public key does not matched pinned public key\n"
"\n"
"       91     Invalid SSL certificate status.\n"
"\n"
"       92     Stream error in HTTP/2 framing layer.\n"
"\n"
, stdout);
 fputs(
"       93     An API function was called from inside a callback.\n"
"\n"
"       94     An authentication function returned an error.\n"
"\n"
"       95     A problem was detected in the HTTP/3  layer.  This  is  somewhat\n"
"              generic  and  can  be one out of several problems, see the error\n"
"              message for details.\n"
"\n"
"       96     QUIC connection error. This error may be caused by  an  SSL  li-\n"
"              brary error. QUIC is the protocol used for HTTP/3 transfers.\n"
"\n"
, stdout);
 fputs(
"       XX     More error codes will appear here in future releases. The exist-\n"
"              ing ones are meant to never change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel Stenberg is the main author, but the whole list of  contributors\n"
"       is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       https://curl.se\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1)\n"
"\n"
, stdout) ;
}
#else /* !USE_MANUAL */
/* built-in manual is disabled, blank function */
#include "tool_hugehelp.h"
void hugehelp(void) {}
#endif /* USE_MANUAL */
