/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.xml.common.ElementWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.BoundWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.NodeWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayWriter;

public class OsmWriter
extends ElementWriter {
    private SubElementWriter subElementWriter;
    private boolean renderAttributes;

    public OsmWriter(String elementName, int indentLevel, boolean renderAttributes, boolean legacyBound) {
        super(elementName, indentLevel);
        this.renderAttributes = renderAttributes;
        this.subElementWriter = new SubElementWriter(indentLevel + 1, legacyBound);
    }

    public void begin() {
        this.beginOpenElement();
        if (this.renderAttributes) {
            this.addAttribute("version", "0.6");
            this.addAttribute("generator", "Osmosis 0.43.1");
        }
        this.endOpenElement(false);
    }

    public void end() {
        this.closeElement();
    }

    public void process(EntityContainer entityContainer) {
        entityContainer.process(this.subElementWriter);
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.subElementWriter.updateWriter(writer);
    }

    private static class SubElementWriter
    implements EntityProcessor {
        private NodeWriter nodeWriter;
        private WayWriter wayWriter;
        private RelationWriter relationWriter;
        private BoundWriter boundWriter;
        private boolean boundWritten = false;
        private boolean entitiesWritten = false;

        public SubElementWriter(int indentLevel, boolean legacyBound) {
            this.nodeWriter = new NodeWriter("node", indentLevel);
            this.wayWriter = new WayWriter("way", indentLevel);
            this.relationWriter = new RelationWriter("relation", indentLevel);
            this.boundWriter = legacyBound ? new BoundWriter("bound", indentLevel, legacyBound) : new BoundWriter("bounds", indentLevel, legacyBound);
        }

        public void updateWriter(Writer writer) {
            this.nodeWriter.setWriter(writer);
            this.wayWriter.setWriter(writer);
            this.relationWriter.setWriter(writer);
            this.boundWriter.setWriter(writer);
            this.boundWritten = false;
            this.entitiesWritten = false;
        }

        @Override
        public void process(NodeContainer node) {
            this.nodeWriter.process(node.getEntity());
            this.entitiesWritten = true;
        }

        @Override
        public void process(WayContainer way) {
            this.wayWriter.process(way.getEntity());
            this.entitiesWritten = true;
        }

        @Override
        public void process(RelationContainer relation) {
            this.relationWriter.process(relation.getEntity());
            this.entitiesWritten = true;
        }

        @Override
        public void process(BoundContainer bound) {
            if (this.boundWritten) {
                throw new OsmosisRuntimeException("Bound element already written and only one allowed.");
            }
            if (this.entitiesWritten) {
                throw new OsmosisRuntimeException("Can't write bound element after other entities.");
            }
            this.boundWriter.process(bound.getEntity());
            this.boundWritten = true;
        }
    }
}

