/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagWriter;

public class NodeWriter
extends EntityWriter {
    private TagWriter tagWriter;
    private NumberFormat numberFormat;

    public NodeWriter(String elementName, int indentLevel) {
        super(elementName, indentLevel);
        this.tagWriter = new TagWriter("tag", indentLevel + 1);
        this.numberFormat = new DecimalFormat("0.#######;-0.#######", new DecimalFormatSymbols(Locale.US));
    }

    public void process(Node node) {
        this.beginOpenElement();
        this.addCommonAttributes(node);
        if (!Double.isNaN(node.getLatitude())) {
            this.addAttribute("lat", this.numberFormat.format(node.getLatitude()));
        }
        if (!Double.isNaN(node.getLongitude())) {
            this.addAttribute("lon", this.numberFormat.format(node.getLongitude()));
        }
        this.addMetatags(node);
        Collection<Tag> tags = node.getTags();
        if (tags.size() > 0) {
            this.endOpenElement(false);
            for (Tag tag : tags) {
                this.tagWriter.process(tag);
            }
            this.closeElement();
        } else {
            this.endOpenElement(true);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.tagWriter.setWriter(writer);
    }
}

