/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.SourceElementProcessor;
import org.xml.sax.Attributes;

public class LegacyBoundElementProcessor
extends SourceElementProcessor {
    private static final String ATTRIBUTE_NAME_BOX = "box";
    private static final String ATTRIBUTE_NAME_ORIGIN = "origin";
    private Bound bound;

    public LegacyBoundElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing) {
        super(parentProcessor, sink, enableDateParsing);
    }

    @Override
    public void begin(Attributes attributes) {
        Double right;
        Double top;
        Double left;
        Double bottom;
        String boxString = attributes.getValue(ATTRIBUTE_NAME_BOX);
        if (boxString == null) {
            throw new OsmosisRuntimeException("Missing required box attribute of bound element");
        }
        String[] boundStrings = boxString.split(",");
        if (boundStrings.length != 4) {
            throw new OsmosisRuntimeException("Badly formed box attribute of bound element");
        }
        try {
            bottom = Double.parseDouble(boundStrings[0]);
            left = Double.parseDouble(boundStrings[1]);
            top = Double.parseDouble(boundStrings[2]);
            right = Double.parseDouble(boundStrings[3]);
        }
        catch (NumberFormatException e) {
            throw new OsmosisRuntimeException("Can't parse box attribute of bound element", e);
        }
        String origin = attributes.getValue(ATTRIBUTE_NAME_ORIGIN);
        if (origin == null || origin.equals("")) {
            throw new OsmosisRuntimeException("Origin attribute of bound element is empty or missing.");
        }
        this.bound = new Bound(right, left, top, bottom, origin);
    }

    @Override
    public void end() {
        this.getSink().process(new BoundContainer(this.bound));
        this.bound = null;
    }
}

