/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.RunnableSourceManager;
import org.openstreetmap.osmosis.xml.v0_6.XmlDownloader;

public class XmlDownloaderFactory
extends TaskManagerFactory {
    private static final String ARG_LEFT = "left";
    private static final String ARG_RIGHT = "right";
    private static final String ARG_TOP = "top";
    private static final String ARG_BOTTOM = "bottom";
    private static final String ARG_URL = "url";
    private static final double DEFAULT_LEFT = -180.0;
    private static final double DEFAULT_RIGHT = 180.0;
    private static final double DEFAULT_TOP = 90.0;
    private static final double DEFAULT_BOTTOM = -90.0;

    @Override
    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        double left = this.getDoubleArgument(taskConfig, ARG_LEFT, -180.0);
        double right = this.getDoubleArgument(taskConfig, ARG_RIGHT, 180.0);
        double top = this.getDoubleArgument(taskConfig, ARG_TOP, 90.0);
        double bottom = this.getDoubleArgument(taskConfig, ARG_BOTTOM, -90.0);
        String url = this.getStringArgument(taskConfig, ARG_URL, "http://www.openstreetmap.org/api/0.6");
        return new RunnableSourceManager(taskConfig.getId(), new XmlDownloader(left, right, top, bottom, url), taskConfig.getPipeArgs());
    }
}

