/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.util.MultiMemberGZIPInputStream;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDownloader
implements RunnableSource {
    private static final int RESPONSECODE_OK = 200;
    private static Logger log = Logger.getLogger(XmlDownloader.class.getName());
    private static final int TIMEOUT = 15000;
    private Sink mySink;
    private double myLeft;
    private double myRight;
    private double myTop;
    private double myBottom;
    private String myBaseUrl = "http://www.openstreetmap.org/api/0.6";
    private HttpURLConnection myActiveConnection;
    private InputStream responseStream;

    public XmlDownloader(double left, double right, double top, double bottom, String baseUrl) {
        this.myLeft = Math.min(left, right);
        this.myRight = Math.max(left, right);
        this.myTop = Math.max(top, bottom);
        this.myBottom = Math.min(top, bottom);
        if (baseUrl != null) {
            this.myBaseUrl = baseUrl;
        }
    }

    @Override
    public void setSink(Sink aSink) {
        this.mySink = aSink;
    }

    private void cleanup() {
        if (this.myActiveConnection != null) {
            try {
                this.myActiveConnection.disconnect();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to disconnect.", e);
            }
            this.myActiveConnection = null;
        }
        if (this.responseStream != null) {
            try {
                this.responseStream.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to close response stream.", e);
            }
            this.responseStream = null;
        }
    }

    private SAXParser createParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mySink.initialize(Collections.<String, Object>emptyMap());
            SAXParser parser = this.createParser();
            InputStream inputStream = this.getInputStream(this.myBaseUrl + "/map?bbox=" + this.myLeft + "," + this.myBottom + "," + this.myRight + "," + this.myTop);
            this.mySink.process(new BoundContainer(new Bound(this.myRight, this.myLeft, this.myTop, this.myBottom, this.myBaseUrl)));
            try {
                parser.parse(inputStream, (DefaultHandler)new OsmHandler(this.mySink, true));
            }
            finally {
                inputStream.close();
                inputStream = null;
            }
            this.mySink.complete();
        }
        catch (SAXParseException e) {
            throw new OsmosisRuntimeException("Unable to parse xml.  publicId=(" + e.getPublicId() + "), systemId=(" + e.getSystemId() + "), lineNumber=" + e.getLineNumber() + ", columnNumber=" + e.getColumnNumber() + ".", e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to parse XML.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read XML.", e);
        }
        finally {
            this.mySink.release();
            this.cleanup();
        }
    }

    private InputStream getInputStream(String pUrlStr) throws IOException {
        URL url = new URL(pUrlStr);
        this.myActiveConnection = (HttpURLConnection)url.openConnection();
        this.myActiveConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        int responseCode = this.myActiveConnection.getResponseCode();
        if (responseCode != 200) {
            String apiErrorMessage = this.myActiveConnection.getHeaderField("Error");
            String message = apiErrorMessage != null ? "Received API HTTP response code " + responseCode + " with message \"" + apiErrorMessage + "\" for URL \"" + pUrlStr + "\"." : "Received API HTTP response code " + responseCode + " for URL \"" + pUrlStr + "\".";
            throw new OsmosisRuntimeException(message);
        }
        this.myActiveConnection.setConnectTimeout(15000);
        String encoding = this.myActiveConnection.getContentEncoding();
        this.responseStream = this.myActiveConnection.getInputStream();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            this.responseStream = new MultiMemberGZIPInputStream(this.responseStream);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            this.responseStream = new InflaterInputStream(this.responseStream, new Inflater(true));
        }
        return this.responseStream;
    }
}

