/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;

public class StoreableConstructorCache {
    private Map<Class<?>, Constructor<?>> cache = new HashMap();

    public Constructor<?> getStoreableConstructor(Class<?> clazz) {
        Constructor<?> constructor;
        if (this.cache.containsKey(clazz)) {
            constructor = this.cache.get(clazz);
        } else {
            try {
                constructor = clazz.getConstructor(StoreReader.class, StoreClassRegister.class);
            }
            catch (NoSuchMethodException e) {
                throw new OsmosisRuntimeException("Class " + clazz.getName() + " does not have a constructor accepting a " + StoreReader.class.getName() + " argument, this is required for all Storeable classes.", e);
            }
            this.cache.put(clazz, constructor);
        }
        return constructor;
    }
}

