/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.GenericObjectSerializationFactory;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class EntitySorter
implements SinkSource {
    private FileBasedSort<EntityContainer> fileBasedSort;
    private Sink sink;

    public EntitySorter(Comparator<EntityContainer> comparator) {
        this.fileBasedSort = new FileBasedSort<EntityContainer>(new GenericObjectSerializationFactory(), comparator, true);
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        this.fileBasedSort.add(entityContainer);
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        ReleasableIterator<EntityContainer> iterator = null;
        try {
            iterator = this.fileBasedSort.iterate();
            while (iterator.hasNext()) {
                this.sink.process((EntityContainer)iterator.next());
            }
            this.sink.complete();
        }
        finally {
            if (iterator != null) {
                iterator.release();
            }
        }
    }

    @Override
    public void release() {
        this.fileBasedSort.release();
        this.sink.release();
    }
}

