/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.java.plugin.JpfException;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.StandardPluginLocation;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactoryRegister;
import org.openstreetmap.osmosis.core.plugin.PluginLoader;

public class TaskRegistrar {
    private static final Logger LOG = Logger.getLogger(TaskRegistrar.class.getName());
    private TaskManagerFactoryRegister factoryRegister = new TaskManagerFactoryRegister();

    public TaskManagerFactoryRegister getFactoryRegister() {
        return this.factoryRegister;
    }

    public void initialize(List<String> plugins) {
        this.loadBuiltInPlugins();
        for (String plugin : plugins) {
            this.loadPlugin(plugin);
        }
        this.loadJPFPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuiltInPlugins() {
        String pluginResourceName = "osmosis-plugins.conf";
        try {
            for (URL pluginConfigurationUrl : Collections.list(Thread.currentThread().getContextClassLoader().getResources("osmosis-plugins.conf"))) {
                LOG.finer("Loading plugin configuration file from url " + pluginConfigurationUrl + ".");
                InputStream pluginInputStream = pluginConfigurationUrl.openStream();
                if (pluginInputStream == null) {
                    throw new OsmosisRuntimeException("Cannot open URL " + pluginConfigurationUrl + ".");
                }
                try {
                    String plugin;
                    BufferedReader pluginReader = new BufferedReader(new InputStreamReader(pluginInputStream));
                    while ((plugin = pluginReader.readLine()) != null) {
                        if ((plugin = plugin.trim()).isEmpty()) continue;
                        LOG.finer("Loading plugin via loader " + plugin + ".");
                        this.loadPlugin(plugin);
                    }
                }
                finally {
                    try {
                        pluginInputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warning("Unable to close plugin resource osmosis-plugins.conf.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to load the plugins based on osmosis-plugins.conf resources.");
        }
    }

    private void loadJPFPlugins() {
        PluginManager pluginManager = ObjectFactory.newInstance().createManager();
        LOG.fine("Searching for JPF plugins.");
        List<PluginManager.PluginLocation> locations = this.gatherJpfPlugins();
        LOG.fine("Registering the core plugin.");
        this.registerCorePlugin(pluginManager);
        LOG.fine("Registering the extension plugins.");
        if (locations.size() == 0) {
            return;
        }
        this.registerJpfPlugins(pluginManager, locations);
        LOG.fine("Activating the plugins.");
        PluginDescriptor core = pluginManager.getRegistry().getPluginDescriptor("org.openstreetmap.osmosis.core.plugin.Core");
        ExtensionPoint point = pluginManager.getRegistry().getExtensionPoint(core.getId(), "Task");
        for (Extension ext : point.getConnectedExtensions()) {
            PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
            try {
                pluginManager.enablePlugin(descr, true);
                pluginManager.activatePlugin(descr.getId());
                PluginClassLoader classLoader = pluginManager.getPluginClassLoader(descr);
                this.loadPluginClass(ext.getParameter("class").valueAsString(), classLoader);
            }
            catch (PluginLifecycleException e) {
                throw new OsmosisRuntimeException("Cannot load JPF-plugin '" + ext.getId() + "' for extensionpoint '" + ext.getExtendedPointId() + "'", e);
            }
        }
    }

    private void registerCorePlugin(PluginManager pluginManager) {
        try {
            URL core = this.getClass().getResource("/org/openstreetmap/osmosis/core/plugin/plugin.xml");
            LOG.finest("Plugin URL: " + core);
            pluginManager.getRegistry().register(new URL[]{core});
            PluginDescriptor coreDescriptor = pluginManager.getRegistry().getPluginDescriptor("org.openstreetmap.osmosis.core.plugin.Core");
            pluginManager.enablePlugin(coreDescriptor, true);
            pluginManager.activatePlugin("org.openstreetmap.osmosis.core.plugin.Core");
        }
        catch (ManifestProcessingException e) {
            throw new OsmosisRuntimeException("Unable to register core plugin.", e);
        }
        catch (PluginLifecycleException e) {
            throw new OsmosisRuntimeException("Unable to enable core plugin.", e);
        }
    }

    private void registerJpfPlugins(PluginManager pluginManager, List<PluginManager.PluginLocation> locations) {
        if (locations == null) {
            throw new IllegalArgumentException("null plugin-list given");
        }
        try {
            pluginManager.publishPlugins(locations.toArray(new PluginManager.PluginLocation[locations.size()]));
        }
        catch (JpfException e) {
            throw new OsmosisRuntimeException("Unable to publish plugins.", e);
        }
    }

    private List<PluginManager.PluginLocation> gatherJpfPlugins() {
        File[] pluginsDirs = new File[]{new File("plugins"), new File(System.getProperty("user.home") + "/.openstreetmap" + File.separator + "osmosis" + File.separator + "plugins"), new File(System.getenv("APPDATA") + File.separator + "openstreetmap" + File.separator + "osmosis" + File.separator + "plugins")};
        FilenameFilter pluginFileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".zip") || name.toLowerCase().endsWith(".jar");
            }
        };
        LinkedList<PluginManager.PluginLocation> locations = new LinkedList<PluginManager.PluginLocation>();
        for (File pluginDir : pluginsDirs) {
            LOG.finer("Loading plugins in " + pluginDir.getAbsolutePath());
            if (!pluginDir.exists()) continue;
            File[] plugins = pluginDir.listFiles(pluginFileNameFilter);
            try {
                for (int i = 0; i < plugins.length; ++i) {
                    LOG.finest("Found plugin " + plugins[i].getAbsolutePath());
                    PluginManager.PluginLocation location = StandardPluginLocation.create(plugins[i]);
                    if (location != null) {
                        locations.add(location);
                        continue;
                    }
                    LOG.warning("JPF Plugin " + plugins[i].getAbsolutePath() + " is malformed and cannot be loaded.");
                }
            }
            catch (MalformedURLException e) {
                throw new OsmosisRuntimeException("Cannot create plugin location " + pluginDir.getAbsolutePath(), e);
            }
        }
        return locations;
    }

    private void loadPlugin(String plugin) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.loadPluginClass(plugin, classLoader);
    }

    private void loadPluginClass(String pluginClassName, ClassLoader classLoader) {
        PluginLoader pluginLoader;
        Class<?> untypedPluginClass;
        try {
            untypedPluginClass = classLoader.loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OsmosisRuntimeException("Unable to load plugin class (" + pluginClassName + ").", e);
        }
        if (!PluginLoader.class.isAssignableFrom(untypedPluginClass)) {
            throw new OsmosisRuntimeException("The class (" + pluginClassName + ") does not implement interface (" + PluginLoader.class.getName() + "). Maybe it's not a plugin?");
        }
        Class<?> pluginClass = untypedPluginClass;
        try {
            pluginLoader = (PluginLoader)pluginClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unable to instantiate plugin class (" + pluginClassName + ").", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to instantiate plugin class (" + pluginClassName + ").", e);
        }
        Map<String, TaskManagerFactory> pluginTasks = pluginLoader.loadTaskFactories();
        for (Map.Entry<String, TaskManagerFactory> taskEntry : pluginTasks.entrySet()) {
            this.factoryRegister.register(taskEntry.getKey(), taskEntry.getValue());
        }
    }
}

