/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.mapviewer.TileFactory;

public class Tile
extends AbstractBean {
    private Priority priority = Priority.High;
    private TileFactory dtf;
    private boolean isLoading = false;
    private String url;
    private boolean loaded = false;
    private int zoom;
    private int x;
    private int y;
    SoftReference<BufferedImage> image = new SoftReference<Object>(null);

    public Tile(int x, int y, int zoom) {
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
    }

    Tile(int x, int y, int zoom, String url, Priority priority, TileFactory dtf) {
        this.url = url;
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.priority = priority;
        this.dtf = dtf;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    synchronized void setLoaded(boolean loaded) {
        boolean old = this.isLoaded();
        this.loaded = loaded;
        this.firePropertyChange("loaded", old, this.isLoaded());
    }

    public BufferedImage getImage() {
        BufferedImage img = this.image.get();
        if (img == null) {
            this.setLoaded(false);
            if (this.dtf != null) {
                this.dtf.startLoading(this);
            }
        }
        return img;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getURL() {
        return this.url;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static enum Priority {
        High,
        Low;

    }
}

