/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalResponseCache
extends ResponseCache {
    private static final Log log = LogFactory.getLog(LocalResponseCache.class);
    private final File cacheDir;
    private boolean checkForUpdates;
    private String baseURL;

    private LocalResponseCache(String baseURL, File cacheDir, boolean checkForUpdates) {
        this.baseURL = baseURL;
        this.cacheDir = cacheDir;
        this.checkForUpdates = checkForUpdates;
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }

    public static void installResponseCache(String baseURL, File cacheDir, boolean checkForUpdates) {
        ResponseCache.setDefault(new LocalResponseCache(baseURL, cacheDir, checkForUpdates));
    }

    public File getLocalFile(URI remoteUri) {
        String remote;
        if (this.baseURL != null && !(remote = remoteUri.toString()).startsWith(this.baseURL)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String host = remoteUri.getHost();
        String query = remoteUri.getQuery();
        String path = remoteUri.getPath();
        String fragment = remoteUri.getFragment();
        if (host != null) {
            sb.append(host);
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(fragment);
        }
        int maxLen = 250;
        String name = sb.length() < 250 ? sb.toString() : sb.substring(0, 250);
        name = name.replace('?', '$');
        name = name.replace('*', '$');
        name = name.replace(':', '$');
        name = name.replace('<', '$');
        name = name.replace('>', '$');
        name = name.replace('\"', '$');
        File f = new File(this.cacheDir, name);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUpdateAvailable(URI remoteUri, File localFile) {
        URLConnection conn;
        try {
            conn = remoteUri.toURL().openConnection();
        }
        catch (MalformedURLException ex) {
            log.error("An exception occurred", ex);
            return false;
        }
        catch (IOException ex) {
            log.error("An exception occurred", ex);
            return false;
        }
        if (!(conn instanceof HttpURLConnection)) {
            return false;
        }
        long localLastMod = localFile.lastModified();
        long remoteLastMod = 0L;
        HttpURLConnection httpconn = (HttpURLConnection)conn;
        httpconn.setUseCaches(false);
        try {
            httpconn.connect();
            remoteLastMod = httpconn.getLastModified();
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            httpconn.disconnect();
        }
        return remoteLastMod > localLastMod;
    }

    @Override
    public CacheResponse get(URI uri, String rqstMethod, Map<String, List<String>> rqstHeaders) throws IOException {
        File localFile = this.getLocalFile(uri);
        if (localFile == null) {
            return null;
        }
        if (!localFile.exists()) {
            return null;
        }
        if (this.checkForUpdates && LocalResponseCache.isUpdateAvailable(uri, localFile)) {
            return null;
        }
        return new LocalCacheResponse(localFile, rqstHeaders);
    }

    @Override
    public CacheRequest put(URI uri, URLConnection conn) throws IOException {
        if (!(conn instanceof HttpURLConnection) || !((HttpURLConnection)conn).getRequestMethod().equals("GET")) {
            return null;
        }
        File localFile = this.getLocalFile(uri);
        if (localFile == null) {
            return null;
        }
        new File(localFile.getParent()).mkdirs();
        return new LocalCacheRequest(localFile);
    }

    private class LocalCacheRequest
    extends CacheRequest {
        private final File localFile;
        private FileOutputStream fos;

        private LocalCacheRequest(File localFile) {
            this.localFile = localFile;
            try {
                this.fos = new FileOutputStream(localFile);
            }
            catch (FileNotFoundException ex) {
                log.error("An exception occurred", ex);
            }
        }

        @Override
        public OutputStream getBody() throws IOException {
            return this.fos;
        }

        @Override
        public void abort() {
            try {
                this.fos.close();
                this.localFile.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class LocalCacheResponse
    extends CacheResponse {
        private FileInputStream fis;
        private final Map<String, List<String>> headers;

        private LocalCacheResponse(File localFile, Map<String, List<String>> rqstHeaders) {
            try {
                this.fis = new FileInputStream(localFile);
            }
            catch (FileNotFoundException ex) {
                log.error("An exception occurred", ex);
            }
            this.headers = rqstHeaders;
        }

        @Override
        public Map<String, List<String>> getHeaders() throws IOException {
            return this.headers;
        }

        @Override
        public InputStream getBody() throws IOException {
            return this.fis;
        }
    }
}

