/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class Serializer {
    protected static final SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    public static void serialize(Class clazz, Object instance, String schemaLocation, File output) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
        m.marshal(instance, output);
    }

    public static void serialize(Class clazz, Object instance, File output) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(instance, output);
    }

    public static String serializeToString(Class clazz, Object instance) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter(2048);
        m.marshal(instance, (Writer)sw);
        sw.flush();
        String res = sw.toString();
        sw.close();
        return res;
    }

    public static <S> S deserialize(Class<S> clazz, File xml, File schema) throws SAXException, JAXBException {
        Schema s = sf.newSchema(schema);
        return Serializer.deserialize(clazz, xml, s);
    }

    public static <S> S deserialize(Class<S> clazz, File xml, URL schema) throws SAXException, JAXBException {
        Schema s = sf.newSchema(schema);
        return Serializer.deserialize(clazz, xml, s);
    }

    public static <S> S deserialize(Class<S> clazz, File xml, Schema schema) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        Object deserialized = unmarshaller.unmarshal(xml);
        return (S)deserialized;
    }

    public static <S> S deserialize(Class<S> clazz, File xml) throws JAXBException, IOException, SAXException {
        return Serializer.deserialize(clazz, xml, true);
    }

    public static <S> S deserialize(Class<S> clazz, File xml, boolean validate) throws JAXBException, IOException, SAXException {
        if (validate) {
            Schema schema = Serializer.generateSchema(clazz);
            return Serializer.deserialize(clazz, xml, schema);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Object deserialized = unmarshaller.unmarshal(xml);
        return (S)deserialized;
    }

    public static <S> S deserializeFromString(Class<S> clazz, String xml) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StringReader read = new StringReader(xml);
        Object deserialized = unmarshaller.unmarshal((Reader)read);
        read.close();
        return (S)deserialized;
    }

    public static Schema generateSchema(Class clazz) throws JAXBException, IOException, SAXException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        final ArrayList results = new ArrayList();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        DOMResult res = (DOMResult)results.get(0);
        DOMSource src = new DOMSource(res.getNode());
        return sf.newSchema(src);
    }

    public static void generateSchema(final File dest, Class clazz) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                return new StreamResult(dest);
            }
        });
    }
}

