/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.gis;

import de.nx42.maps4cim.config.bounds.CenterDef;
import de.nx42.maps4cim.util.gis.Geo;

public enum UnitOfLength {
    DEGREE{

        @Override
        public double toKilometer(double input) {
            return 111.31949079327357 * input;
        }

        @Override
        public double fromKilometer(double input) {
            return input / 111.31949079327357;
        }

        @Override
        public double toKilometer(double input, double atLatitude) {
            return Geo.degreeOfLongitudeLength(atLatitude) * input;
        }

        @Override
        public double fromKilometer(double input, double atLatitude) {
            return input / Geo.degreeOfLongitudeLength(atLatitude);
        }
    }
    ,
    METER{

        @Override
        public double toKilometer(double input) {
            return input / 1000.0;
        }

        @Override
        public double fromKilometer(double input) {
            return input * 1000.0;
        }

        @Override
        public double toKilometer(double input, double atLatitude) {
            return this.toKilometer(input);
        }

        @Override
        public double fromKilometer(double input, double atLatitude) {
            return this.fromKilometer(input);
        }
    }
    ,
    KILOMETER{

        @Override
        public double toKilometer(double input) {
            return input;
        }

        @Override
        public double fromKilometer(double input) {
            return input;
        }

        @Override
        public double toKilometer(double input, double atLatitude) {
            return input;
        }

        @Override
        public double fromKilometer(double input, double atLatitude) {
            return input;
        }
    };


    private UnitOfLength() {
    }

    public abstract double toKilometer(double var1);

    public abstract double fromKilometer(double var1);

    public abstract double toKilometer(double var1, double var3);

    public abstract double fromKilometer(double var1, double var3);

    public double convert(double input, UnitOfLength output) {
        return output.fromKilometer(this.toKilometer(input));
    }

    public double convert(double input, UnitOfLength output, double atLatitude) {
        return output.fromKilometer(this.toKilometer(input, atLatitude), atLatitude);
    }

    public static UnitOfLength fromUnit(CenterDef.Unit unit) {
        switch (unit) {
            case DEG: {
                return DEGREE;
            }
            case KM: {
                return KILOMETER;
            }
            case M: {
                return METER;
            }
        }
        return null;
    }

    /* synthetic */ UnitOfLength(String string, int n, UnitOfLength unitOfLength) {
        this();
    }
}

