/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.gis;

import de.nx42.maps4cim.util.MathExt;
import de.nx42.maps4cim.util.gis.Area;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class Coordinate {
    protected final double latitudeWGS84;
    protected final double longitudeWGS84;

    public Coordinate(double latitude, double longitude) {
        this.latitudeWGS84 = latitude;
        this.longitudeWGS84 = longitude;
    }

    public Coordinate(String latitude, String longitude) {
        this.latitudeWGS84 = MathExt.parseDoubleAggressive(latitude);
        this.longitudeWGS84 = MathExt.parseDoubleAggressive(longitude);
    }

    public Coordinate(Node node) {
        this.latitudeWGS84 = node.getLatitude();
        this.longitudeWGS84 = node.getLongitude();
    }

    public double getLatitude() {
        return this.latitudeWGS84;
    }

    public double getLongitude() {
        return this.longitudeWGS84;
    }

    public String toString() {
        return String.format("%s\u00b0, %s\u00b0", MathExt.roundf(this.latitudeWGS84, 4), MathExt.roundf(this.longitudeWGS84, 4));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitudeWGS84);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitudeWGS84);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.latitudeWGS84) != Double.doubleToLongBits(other.latitudeWGS84)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitudeWGS84) == Double.doubleToLongBits(other.longitudeWGS84);
    }

    public static Coordinate parse(String s) throws ParseException {
        try {
            double[] parsed = MathExt.parseDoubleValues(s, ",");
            if (parsed.length < 2) {
                throw new ParseException(String.format("No coordinates were recognized in the string \"%s\"", s), -1);
            }
            return new Coordinate(parsed[0], parsed[1]);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public static List<Coordinate> convert(List<Node> wayNodes) {
        ArrayList<Coordinate> nodes = new ArrayList<Coordinate>(wayNodes.size());
        for (Node node : wayNodes) {
            nodes.add(new Coordinate(node));
        }
        return nodes;
    }

    public RelativeCoord relativeWithinArea(Area area) {
        double relLat = (this.latitudeWGS84 - area.getMinLat()) / area.getHeightDeg();
        double relLon = (this.longitudeWGS84 - area.getMinLon()) / area.getWidthDeg();
        return new RelativeCoord(relLat, relLon);
    }

    public class RelativeCoord {
        public final double x;
        public final double y;

        public RelativeCoord(double latitude, double longitude) {
            this.y = 1.0 - latitude;
            this.x = longitude;
        }
    }
}

