/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.gis;

import com.google.common.base.Splitter;
import de.nx42.maps4cim.config.bounds.BBoxDef;
import de.nx42.maps4cim.config.bounds.BoundsDef;
import de.nx42.maps4cim.config.bounds.CenterDef;
import de.nx42.maps4cim.util.MathExt;
import de.nx42.maps4cim.util.gis.Coordinate;
import de.nx42.maps4cim.util.gis.UnitOfLength;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Map;

public class Area {
    protected final double minLat;
    protected final double minLon;
    protected final double maxLat;
    protected final double maxLon;
    protected int precision = 8;
    protected static final String[] parseOrder = new String[]{"minlat", "minlon", "maxlat", "maxlon"};

    public Area(double minLat, double minLon, double maxLat, double maxLon) {
        this.minLat = this.store(minLat);
        this.minLon = this.store(minLon);
        this.maxLat = this.store(maxLat);
        this.maxLon = this.store(maxLon);
    }

    public Area(double[] boundries) {
        this(boundries[0], boundries[1], boundries[2], boundries[3]);
    }

    public Area(Coordinate boundNW, Coordinate boundSE) {
        this(boundSE.getLatitude(), boundNW.getLongitude(), boundNW.getLatitude(), boundSE.getLongitude());
    }

    public Area(Coordinate center, double extent) {
        this(center, extent, UnitOfLength.DEGREE);
    }

    public Area(Coordinate center, double extent, UnitOfLength unit) {
        this(center, extent, extent, unit);
    }

    public Area(Coordinate center, double extentLat, double extentLon) {
        this(center, extentLat, extentLon, UnitOfLength.DEGREE);
    }

    public Area(Coordinate center, double extentLat, double extentLon, UnitOfLength unit) {
        double adjustedLat = unit.convert(extentLat, UnitOfLength.DEGREE);
        double adjustedLon = unit.convert(extentLon, UnitOfLength.DEGREE, center.getLatitude());
        this.minLat = this.store(center.latitudeWGS84 - adjustedLat / 2.0);
        this.maxLat = this.store(center.latitudeWGS84 + adjustedLat / 2.0);
        this.minLon = this.store(center.longitudeWGS84 - adjustedLon / 2.0);
        this.maxLon = this.store(center.longitudeWGS84 + adjustedLon / 2.0);
    }

    public static Area of(BoundsDef def) {
        if (def instanceof CenterDef) {
            return Area.of((CenterDef)def);
        }
        if (def instanceof BBoxDef) {
            return Area.of((BBoxDef)def);
        }
        throw new IllegalArgumentException("BoundsDef implementation not supported!");
    }

    public static Area of(BBoxDef def) {
        return new Area(def.minLat, (double)def.minLon, (double)def.maxLat, def.maxLon);
    }

    public static Area of(CenterDef def) {
        if (def.isValid()) {
            Double extLat = def.extent;
            Double extLon = def.extent;
            if (def.extentLat != null) {
                extLat = def.extentLat;
            }
            if (def.extentLon != null) {
                extLon = def.extentLon;
            }
            if (def.unit != null) {
                return new Area(new Coordinate(def.centerLat, def.centerLon), (double)extLat, (double)extLon, UnitOfLength.fromUnit(def.unit));
            }
            return new Area(new Coordinate(def.centerLat, def.centerLon), (double)extLat, extLon);
        }
        String err = String.format("Extent not sufficiently defined in configuration: extent=%s, extent-lat=%s, extent-lon=%s", def.extent, def.extentLat, def.extentLon);
        throw new IllegalArgumentException(err);
    }

    protected double store(double d) {
        return Area.round(d, this.precision).doubleValue();
    }

    protected static BigDecimal round(double d, int scale) {
        return BigDecimal.valueOf(d).setScale(scale, 4);
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public Coordinate getBoundNW() {
        return new Coordinate(this.maxLat, this.minLon);
    }

    public Coordinate getBoundSE() {
        return new Coordinate(this.minLat, this.maxLon);
    }

    public double getWidth(UnitOfLength unit) {
        double widthDeg = this.maxLon - this.minLon;
        double medianLat = this.minLat + (this.maxLat - this.minLat) / 2.0;
        return UnitOfLength.DEGREE.convert(widthDeg, unit, medianLat);
    }

    public double getHeight(UnitOfLength unit) {
        double heightDeg = this.maxLat - this.minLat;
        return UnitOfLength.DEGREE.convert(heightDeg, unit);
    }

    public double getWidthDeg() {
        return this.maxLon - this.minLon;
    }

    public double getHeightDeg() {
        return this.maxLat - this.minLat;
    }

    public double getWidthKm() {
        return this.getWidth(UnitOfLength.KILOMETER);
    }

    public double getHeightKm() {
        return this.getHeight(UnitOfLength.KILOMETER);
    }

    public Coordinate getCenter() {
        return new Coordinate((this.minLat + this.maxLat) / 2.0, (this.minLon + this.maxLon) / 2.0);
    }

    public String getStringOsmUrl() {
        return String.format("minlon=%s&minlat=%s&maxlon=%s&maxlat=%s", this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    public String getStringOverpassBounds() {
        return String.format("(%s,%s,%s,%s)", this.minLat, this.minLon, this.maxLat, this.maxLon);
    }

    public String toString() {
        return this.getStringOverpassBounds();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Area) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.minLat) ^ Double.doubleToLongBits(this.minLat) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.minLon) ^ Double.doubleToLongBits(this.minLon) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.maxLat) ^ Double.doubleToLongBits(this.maxLat) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.maxLon) ^ Double.doubleToLongBits(this.maxLon) >>> 32);
        return hash;
    }

    public static Area parse(String s) throws ParseException {
        String input = s.trim().toLowerCase();
        if (input.contains("minlon")) {
            return Area.parseOsmStyle(input);
        }
        return Area.parseSimple(input);
    }

    public static Area parseOsmStyle(String s) throws ParseException {
        try {
            Map<String, String> entries = Splitter.on('&').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split(s);
            double[] boundries = new double[4];
            int i = 0;
            while (i < parseOrder.length) {
                String value = entries.get(parseOrder[i]);
                boundries[i] = MathExt.parseDoubleAggressive(value);
                ++i;
            }
            return new Area(boundries);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public static Area parseSimple(String s) throws ParseException {
        try {
            double[] parsed = MathExt.parseDoubleValues(s, ",");
            return new Area(parsed);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public static Area parseCenter(String s) throws ParseException {
        try {
            double[] parsed = MathExt.parseDoubleValues(s, ",");
            if (parsed.length >= 4) {
                return new Area(new Coordinate(parsed[1], parsed[0]), parsed[3], parsed[2]);
            }
            return new Area(new Coordinate(parsed[1], parsed[0]), parsed[2]);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }
}

