/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.arr2d;

import de.nx42.maps4cim.util.arr2d.Arrays2D;
import de.nx42.maps4cim.util.arr2d.Bicubic;
import de.nx42.maps4cim.util.arr2d.Bilinear;
import de.nx42.maps4cim.util.arr2d.NearestNeighbor;
import java.lang.reflect.Constructor;

public abstract class Interpolation {
    protected float[][] input;
    protected int samplesX = 4;
    protected int samplesY = 4;
    protected int inputLenY;
    protected int inputLenX;
    protected int inputMaxIdxY;
    protected int inputMaxIdxX;
    protected int inputMaxSampleY;
    protected int inputMaxSampleX;

    public Interpolation(float[][] input) {
        this(input, input[0].length, input.length);
    }

    public Interpolation(float[][] input, int lenX, int lenY) {
        this(input, lenX, lenY, 4);
    }

    public Interpolation(float[][] input, int lenX, int lenY, int samples) {
        this.input = input;
        this.inputLenX = lenX;
        this.inputLenY = lenY;
        this.samplesX = this.samplesY = samples;
        this.inputMaxIdxX = this.inputLenX - 1;
        this.inputMaxIdxY = this.inputLenY - 1;
        this.inputMaxSampleX = this.inputMaxIdxX - 1;
        this.inputMaxSampleY = this.inputMaxIdxY - 1;
    }

    private void validateInput() throws IllegalArgumentException {
        System.out.println("test");
        throw new IllegalArgumentException("");
    }

    protected Interpolation() {
    }

    public static Interpolation getInstance(Type type, float[][] input) {
        return type.getInstance(input);
    }

    public abstract float interpolateSampleX(float[] var1, float var2);

    public float interpolateX(float[] arr, float fracX, int offsetX) {
        if (fracX == 0.0f) {
            return arr[offsetX];
        }
        float[] interpX = new float[this.samplesX];
        int i = 0;
        while (i < this.samplesX) {
            interpX[i] = arr[Interpolation.adjustOffset(offsetX, arr.length, i)];
            ++i;
        }
        return this.interpolateSampleX(interpX, fracX);
    }

    public float interpolateSampleY(float[] samples, float fracY) {
        return this.interpolateSampleX(samples, fracY);
    }

    public float interpolateY(float[] arr, float fracY, int offsetY) {
        return this.interpolateX(arr, fracY, offsetY);
    }

    public float interpolateSample(float[][] samples, float fracX, float fracY) {
        float[] interpY = new float[this.samplesY];
        int i = 0;
        while (i < this.samplesY) {
            float val;
            interpY[i] = val = this.interpolateSampleX(samples[i], fracX);
            ++i;
        }
        return this.interpolateSampleY(interpY, fracY);
    }

    public float interpolate(float[][] arr, float fracX, float fracY, int offsetX, int offsetY) {
        if (fracY == 0.0f) {
            return this.interpolateX(arr[offsetY], fracX, offsetX);
        }
        float[] interpY = new float[this.samplesY];
        int i = 0;
        while (i < this.samplesY) {
            int line = Interpolation.adjustOffset(offsetY, arr[i].length, i);
            interpY[i] = this.interpolateX(arr[line], fracX, offsetX);
            ++i;
        }
        return this.interpolateSampleY(interpY, fracY);
    }

    public float interpolate(float[][] arr, float inputX, float inputY) {
        return this.interpolate(arr, Interpolation.getSigFig(inputX), Interpolation.getSigFig(inputY), (int)inputX, (int)inputY);
    }

    protected static int adjustOffset(int offset, int arrLen, int i) {
        if (i == 0 & offset == 0) {
            return 0;
        }
        if (i == 3 && offset >= arrLen - 2) {
            return offset + 1;
        }
        return offset - 1 + i;
    }

    public static float getSigFig(float value) {
        return (float)((double)value - Math.floor(value));
    }

    public float[][] resize(int lenX, int lenY) {
        float[][] output = new float[lenY][lenX];
        float outputMaxIdxX = lenX - 1;
        float outputMaxIdxY = lenY - 1;
        int y = 0;
        while (y < lenY) {
            int x = 0;
            while (x < lenX) {
                float xSrc = (float)x / outputMaxIdxX * (float)this.inputMaxIdxX;
                float ySrc = (float)y / outputMaxIdxY * (float)this.inputMaxIdxY;
                output[y][x] = this.interpolate(this.input, xSrc, ySrc);
                ++x;
            }
            ++y;
        }
        return output;
    }

    public float[][] crop(float top, float right, float bottom, float left) {
        return Arrays2D.copyOfRange(this.input, (int)top, (int)Math.ceil(right), (int)Math.ceil(bottom), (int)left);
    }

    public float[][] cropAndResize(int lenX, int lenY, float minX, float minY, float maxX, float maxY) {
        float[][] output = new float[lenY][lenX];
        float outputMaxIdxX = lenX - 1;
        float outputMaxIdxY = lenY - 1;
        float cropLenX = maxX - minX;
        float cropLenY = maxY - minY;
        int y = 0;
        while (y < lenY) {
            int x = 0;
            while (x < lenX) {
                float xSrc = (float)x / outputMaxIdxX * cropLenX + minX;
                float ySrc = (float)y / outputMaxIdxY * cropLenY + minY;
                output[y][x] = this.interpolate(this.input, xSrc, ySrc);
                ++x;
            }
            ++y;
        }
        return output;
    }

    public static enum Type {
        NEAREST(NearestNeighbor.class),
        BILINEAR(Bilinear.class),
        BICUBIC(Bicubic.class);

        protected Class<? extends Interpolation> clazz;

        private Type(Class<? extends Interpolation> clazz) {
            this.clazz = clazz;
        }

        public Interpolation getInstance(float[][] input) {
            try {
                Constructor<? extends Interpolation> ctor = this.clazz.getConstructor(float[][].class);
                return ctor.newInstance(new Object[]{input});
            }
            catch (Exception ex) {
                System.err.println("fail! " + ex);
                return null;
            }
        }
    }
}

