/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.arr2d;

import de.nx42.maps4cim.util.arr2d.Bicubic;
import de.nx42.maps4cim.util.arr2d.Interpolation;

public class GapInterpolator {
    protected static final Interpolation igap = new Bicubic(new float[1][1]);
    protected static short gap;

    public GapInterpolator(short gap) {
        GapInterpolator.gap = gap;
    }

    public float area(short[][] arr, int x, int y) {
        float[][] samples = new float[4][4];
        int xLow = this.findNextValidIndex(arr, Direction.X_MINUS, x, y);
        int xHigh = this.findNextValidIndex(arr, Direction.X_PLUS, x, y);
        int yLow = this.findNextValidIndex(arr, Direction.Y_MINUS, x, y);
        int yHigh = this.findNextValidIndex(arr, Direction.Y_PLUS, x, y);
        int xWidth = xHigh - xLow;
        int yWidth = yHigh - yLow;
        int maxX = arr[0].length - 1;
        int maxY = arr.length - 1;
        int iy = 0;
        while (iy < samples.length) {
            int ix = 0;
            while (ix < samples[0].length) {
                int yPos;
                int xPos;
                int n = ix < 2 ? (ix == 1 ? xLow : xLow - xWidth) : (xPos = ix == 2 ? xHigh : xHigh + xWidth);
                int n2 = iy < 2 ? (iy == 1 ? yLow : yLow - yWidth) : (yPos = iy == 2 ? yHigh : yHigh + yWidth);
                int n3 = xPos < 0 ? 0 : (xPos = xPos > maxX ? maxX : xPos);
                yPos = yPos < 0 ? 0 : (yPos > maxY ? maxY : yPos);
                samples[iy][ix] = this.findNearestValidValue(arr, xPos, yPos);
                ++ix;
            }
            ++iy;
        }
        float fracX = xWidth == 0 ? 0.0f : (float)(x - xLow) / (float)xWidth;
        float fracY = yWidth == 0 ? 0.0f : (float)(y - yLow) / (float)yWidth;
        return igap.interpolateSample(samples, fracX, fracY);
    }

    public float star(short[][] arr, int x, int y) {
        float[] samplesX = new float[4];
        float[] samplesY = new float[4];
        int x1 = this.findNextValidIndex(arr, Direction.X_MINUS, x, y);
        int x2 = this.findNextValidIndex(arr, Direction.X_PLUS, x, y);
        int y1 = this.findNextValidIndex(arr, Direction.Y_MINUS, x, y);
        int y2 = this.findNextValidIndex(arr, Direction.Y_PLUS, x, y);
        int xWidth = x2 - x1;
        int yWidth = y2 - y1;
        int maxX = arr[0].length - 1;
        int maxY = arr.length - 1;
        int x0 = x1 - xWidth < 0 ? 0 : x1 - xWidth;
        int x3 = x2 + xWidth > maxX ? maxX : x2 + xWidth;
        int y0 = y1 - yWidth < 0 ? 0 : y1 - yWidth;
        int y3 = y2 + yWidth > maxY ? maxY : y2 + yWidth;
        samplesX[0] = this.findNearestValidValue(arr, x0, y);
        samplesX[1] = arr[y][x1];
        samplesX[2] = arr[y][x2];
        samplesX[3] = this.findNearestValidValue(arr, x3, y);
        samplesY[0] = this.findNearestValidValue(arr, x, y0);
        samplesY[1] = arr[y1][x];
        samplesY[2] = arr[y2][x];
        samplesY[3] = this.findNearestValidValue(arr, x, y3);
        float fracX = xWidth == 0 ? 0.0f : (float)(x - x1) / (float)xWidth;
        float fracY = yWidth == 0 ? 0.0f : (float)(y - y1) / (float)yWidth;
        float interpX = igap.interpolateSampleX(samplesX, fracX);
        float interpY = igap.interpolateSampleY(samplesY, fracY);
        return (interpX + interpY) / 2.0f;
    }

    protected int findNextValidIndex(short[][] arr, Direction dir, int x, int y) {
        int idx = dir.nextIndex(arr, x, y);
        if (idx == gap) {
            idx = dir.getOpposite().nextIndex(arr, x, y);
        }
        if (idx == gap) {
            idx = 0;
        }
        return idx;
    }

    protected short findNearestValidValue(short[][] arr, int x, int y) {
        if (arr[y][x] != gap) {
            return arr[y][x];
        }
        int lenY = arr.length;
        int lenX = arr[0].length;
        int dist = 1;
        while (x - dist >= 0 || x + dist < lenX || y - dist >= 0 || y + dist < lenY) {
            int pos = x - dist;
            if (pos >= 0 && arr[y][pos] != gap) {
                return arr[y][pos];
            }
            pos = x + dist;
            if (pos < lenX && arr[y][pos] != gap) {
                return arr[y][pos];
            }
            pos = y - dist;
            if (pos >= 0 && arr[pos][x] != gap) {
                return arr[pos][x];
            }
            pos = y + dist;
            if (pos < lenY && arr[pos][x] != gap) {
                return arr[pos][x];
            }
            ++dist;
        }
        return 0;
    }

    protected static enum Direction {
        Y_MINUS{

            @Override
            public int nextIndex(short[][] arr, int x, int y) {
                int yIdx = y;
                while (yIdx > 0) {
                    if (arr[--yIdx][x] == gap) continue;
                    return yIdx;
                }
                return gap;
            }

            @Override
            public Direction getOpposite() {
                return Y_PLUS;
            }
        }
        ,
        Y_PLUS{

            @Override
            public int nextIndex(short[][] arr, int x, int y) {
                int yIdx = y;
                int maxIdx = arr.length - 2;
                while (yIdx <= maxIdx) {
                    if (arr[++yIdx][x] == gap) continue;
                    return yIdx;
                }
                return gap;
            }

            @Override
            public Direction getOpposite() {
                return Y_MINUS;
            }
        }
        ,
        X_MINUS{

            @Override
            public int nextIndex(short[][] arr, int x, int y) {
                int xIdx = x;
                while (xIdx > 0) {
                    if (arr[y][--xIdx] == gap) continue;
                    return xIdx;
                }
                return gap;
            }

            @Override
            public Direction getOpposite() {
                return X_PLUS;
            }
        }
        ,
        X_PLUS{

            @Override
            public int nextIndex(short[][] arr, int x, int y) {
                int xIdx = x;
                int maxIdx = arr[0].length - 2;
                while (xIdx <= maxIdx) {
                    if (arr[y][++xIdx] == gap) continue;
                    return xIdx;
                }
                return gap;
            }

            @Override
            public Direction getOpposite() {
                return X_MINUS;
            }
        };


        public abstract int nextIndex(short[][] var1, int var2, int var3);

        public abstract Direction getOpposite();
    }
}

