/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util.arr2d;

import java.util.Arrays;
import java.util.InputMismatchException;

public class Arrays2D {
    public static float[][] copyOfRange(float[][] input, int topleft, int bottomright) {
        return Arrays2D.copyOfRange(input, topleft, bottomright, topleft, bottomright);
    }

    public static float[][] copyOfRange(float[][] input, int top, int right, int bottom, int left) {
        int height = bottom - top;
        int width = right - left;
        float[][] result = new float[height][width];
        int i = 0;
        while (i < result.length) {
            int iOuter = i + top;
            result[i] = iOuter < input.length ? Arrays.copyOfRange(input[iOuter], left, right) : new float[width];
            ++i;
        }
        return result;
    }

    public static short[][] combine(short[][][][] wrapper) {
        return Arrays2D.combine(wrapper, 0, false);
    }

    public static short[][] combine(short[][][][] wrapper, int width, int height) {
        return Arrays2D.combine(wrapper, width, height, 0, false);
    }

    public static short[][] combine(short[][][][] wrapper, int overlap, boolean validate) {
        return Arrays2D.combine(wrapper, wrapper[0][0][0].length, wrapper[0][0].length, overlap, validate);
    }

    public static short[][] combine(short[][][][] wrapper, int width, int height, int overlap, boolean validate) {
        int lenY = wrapper.length;
        int lenX = wrapper[0].length;
        int combHeight = lenY * (height - overlap) + overlap;
        int combWidth = lenX * (width - overlap) + overlap;
        short[][] combined = new short[combHeight][combWidth];
        int wY = 0;
        while (wY < lenY) {
            int wX = 0;
            while (wX < lenX) {
                int startX;
                short[][] subArr = wrapper[wY][wX];
                int top = Arrays2D.calculateOffset(height, overlap, wY);
                int left = Arrays2D.calculateOffset(width, overlap, wX);
                int extY = wY == 0 ? height : height - 1;
                int extX = wX == 0 ? width : width - 1;
                int startY = wY == 0 ? 0 : overlap;
                int n = startX = wX == 0 ? 0 : overlap;
                if (validate && overlap > 0) {
                    if (wY > 0) {
                        Arrays2D.validateAbove(subArr, wrapper[wY - 1][wX], overlap);
                    }
                    if (wX > 0) {
                        Arrays2D.validateLeft(subArr, wrapper[wY][wX - 1], overlap);
                    }
                }
                int y = 0;
                while (y < extY) {
                    int x = 0;
                    while (x < extX) {
                        combined[top + y][left + x] = subArr[startY + y][startX + x];
                        ++x;
                    }
                    ++y;
                }
                ++wX;
            }
            ++wY;
        }
        return combined;
    }

    private static int calculateOffset(int arrLen, int overlap, int idx) {
        return idx == 0 ? 0 : arrLen + (idx - 1) * (arrLen - overlap);
    }

    private static void validateAbove(short[][] current, short[][] above, int overlap) {
        int i = 0;
        while (i < overlap) {
            short[] yAbove = above[above.length - 1 - i];
            short[] yCurrent = current[i];
            int j = 0;
            while (j < yCurrent.length) {
                if (yAbove[j] != yCurrent[j]) {
                    throw new InputMismatchException("The overlapping parts of the current array and the one above do not match!");
                }
                ++j;
            }
            ++i;
        }
    }

    private static void validateLeft(short[][] current, short[][] left, int overlap) {
        int x = 0;
        while (x < overlap) {
            int y = 0;
            while (y < current.length) {
                if (current[y][x] != left[y][left[y].length - 1 - x]) {
                    throw new InputMismatchException("The overlapping parts of the current array and the one to the left do not match!");
                }
                ++y;
            }
            ++x;
        }
    }
}

