/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util;

import java.text.DecimalFormat;

public class MathExt {
    private static final double defaultPrecision = 1.0E-10;
    private static final DecimalFormat df2 = new DecimalFormat("#0.00");

    public static boolean equalsDouble(double a, double b) {
        return Math.abs(a - b) < 1.0E-10;
    }

    public static boolean equalsDouble(double a, double b, double precision) {
        return Math.abs(a - b) < precision;
    }

    public static double parseDoubleAggressive(String s) {
        String clean = s.replaceAll("[^x0-9|^\\.]", "").trim();
        return Double.parseDouble(clean);
    }

    public static double[] parseDoubleValues(String s, String separator) throws NumberFormatException {
        String[] values = s.split(separator);
        double[] result = new double[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = MathExt.parseDoubleAggressive(values[i]);
            ++i;
        }
        return result;
    }

    public static String roundf(double a) {
        return String.valueOf((double)Math.round(a * 100.0) / 100.0);
    }

    public static String roundf(double a, int sigDigits) {
        double mul = Math.pow(10.0, sigDigits);
        return String.valueOf((double)Math.round(a * mul) / mul);
    }
}

