/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class Compression {
    public static byte[] readFirstZipEntry(File zipFile) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<ZipArchiveEntry> entries = zf.getEntries();
        ZipArchiveEntry entry = entries.nextElement();
        InputStream is = zf.getInputStream(entry);
        byte[] raw = ByteStreams.toByteArray(is);
        is.close();
        zf.close();
        return raw;
    }

    public static File readFirstZipEntry(File zipFile, File dest) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<ZipArchiveEntry> entries = zf.getEntries();
        ZipArchiveEntry entry = entries.nextElement();
        InputStream in = zf.getInputStream(entry);
        FileOutputStream out = new FileOutputStream(dest);
        ByteStreams.copy(in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        zf.close();
        return dest;
    }

    public static File storeAsZip(File input, File zipOutput) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipOutput));
        ZipEntry ze = new ZipEntry(input.getName());
        zos.putNextEntry(ze);
        FileInputStream in = new FileInputStream(input);
        ByteStreams.copy((InputStream)in, (OutputStream)zos);
        zos.closeEntry();
        ((InputStream)in).close();
        zos.close();
        return zipOutput;
    }
}

