/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm.primitives;

import de.nx42.maps4cim.config.texture.ColorDef;
import de.nx42.maps4cim.config.texture.EntityDef;
import de.nx42.maps4cim.map.texture.CiMTexture;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenderPrimitive {
    private static final Logger log = LoggerFactory.getLogger(RenderPrimitive.class);
    public final int color;

    public RenderPrimitive() {
        this.color = CiMTexture.GRASS.draw();
    }

    public RenderPrimitive(int color) {
        this.color = color;
    }

    public RenderPrimitive(ColorDef def) {
        this.color = CiMTexture.draw(def);
    }

    public RenderPrimitive(Collection<ColorDef> colors, EntityDef def) {
        ColorDef color = ColorDef.getColorByName(colors, def.color);
        if (color == null) {
            log.warn("The color with name '{}' was not found. Using the default texture (which will be invisible on plain grass...)", (Object)def.color);
        }
        this.color = CiMTexture.draw(color);
    }

    public int getColor() {
        return this.color;
    }
}

